/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeType;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeTypeManager;
import org.wso2.carbon.registry.jcr.nodetype.RegistryPropertyDefinitionTemplate;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;
import org.wso2.carbon.registry.jcr.util.nodetype.xml.NodeTypeReader;

public class RegistryNodeTypeUtil {
    public static PropertyDefinitionTemplate createJCRPrimaryTypeProperty(NodeTypeManager nodeTypeManager, String name) throws RepositoryException {
        PropertyDefinitionTemplate propertyDefinitionTemplate1 = nodeTypeManager.createPropertyDefinitionTemplate();
        propertyDefinitionTemplate1.setName("jcr:primaryType");
        propertyDefinitionTemplate1.setRequiredType(7);
        propertyDefinitionTemplate1.setDefaultValues(null);
        propertyDefinitionTemplate1.setAutoCreated(true);
        propertyDefinitionTemplate1.setMandatory(true);
        propertyDefinitionTemplate1.setOnParentVersion(4);
        propertyDefinitionTemplate1.setProtected(true);
        propertyDefinitionTemplate1.setMultiple(false);
        ((RegistryPropertyDefinitionTemplate)propertyDefinitionTemplate1).setDeclaringNodeTypeName(name);
        return propertyDefinitionTemplate1;
    }

    public static void locadJCRBuiltInNodeTypesToSystemFromXML(NodeTypeManager nodeTypeManager) throws RepositoryException {
        String streamPath = System.getProperty("wso2.registry.nodetype.xml");
        FileInputStream is = null;
        try {
            is = new FileInputStream(streamPath);
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(is);
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement processInfoElement = builder.getDocumentElement();
            AXIOMXPath expression = new AXIOMXPath("/nodeTypes/nodeType");
            List attributes = expression.selectNodes((Object)processInfoElement);
            for (Object o : attributes) {
                OMElement omNode = (OMElement)o;
                NodeTypeTemplate nodeTypeTemplate = new NodeTypeReader(nodeTypeManager).buildNodeType(omNode);
                ((RegistryNodeTypeManager)nodeTypeManager).registerNodeTypeFromXML((NodeTypeDefinition)nodeTypeTemplate, false);
            }
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new RepositoryException("Exception occurred while reading from : " + streamPath);
        }
        catch (JaxenException e) {
            throw new RepositoryException("Exception occurred while reading from : " + streamPath);
        }
        catch (XMLStreamException e) {
            throw new RepositoryException("Exception occurred while reading from : " + streamPath);
        }
    }

    public static void persistNodeTypeToRegistry(NodeTypeDefinition nodeTypeDefinition, RegistrySession registrySession) {
        try {
            NodeTypeDefinition nodeTypeTemplate = nodeTypeDefinition;
            String nodeTypePath = RegistryJCRSpecificStandardLoderUtil.getSystemConfigNodeTypePath(registrySession) + "/" + nodeTypeTemplate.getName();
            CollectionImpl nodetype = (CollectionImpl)registrySession.getUserRegistry().newCollection();
            nodetype.setName(nodeTypeTemplate.getName());
            nodetype.setProperty("name", nodeTypeTemplate.getName());
            nodetype.setProperty("primaryItemName", nodeTypeTemplate.getPrimaryItemName());
            if (nodeTypeTemplate.getDeclaredSupertypeNames() != null) {
                nodetype.setProperty("declaredSuperTypes", Arrays.asList(nodeTypeTemplate.getDeclaredSupertypeNames()));
            }
            nodetype.setProperty("hasOrderableChildNodes", String.valueOf(nodeTypeTemplate.hasOrderableChildNodes()));
            nodetype.setProperty("isAbstract", String.valueOf(nodeTypeTemplate.isAbstract()));
            nodetype.setProperty("isMixin", String.valueOf(nodeTypeTemplate.isMixin()));
            nodetype.setProperty("isQueryable", String.valueOf(nodeTypeTemplate.isQueryable()));
            nodetype.setParentPath(RegistryJCRSpecificStandardLoderUtil.getSystemConfigNodeTypePath(registrySession));
            registrySession.getUserRegistry().put(nodeTypePath, (Resource)nodetype);
            for (PropertyDefinition propertyDefinition : nodeTypeTemplate.getDeclaredPropertyDefinitions()) {
                PropertyDefinitionTemplate pd = (PropertyDefinitionTemplate)propertyDefinition;
                String propDefPath = nodeTypePath + "/" + "prop_defs" + "/" + pd.getName();
                Resource pdNode = registrySession.getUserRegistry().newResource();
                pdNode.setProperty("name", pd.getName());
                pdNode.setProperty("autoCreated", String.valueOf(pd.isAutoCreated()));
                pdNode.setProperty("mandatory", String.valueOf(pd.isMandatory()));
                pdNode.setProperty("protected", String.valueOf(pd.isProtected()));
                pdNode.setProperty("multiple", String.valueOf(pd.isMultiple()));
                pdNode.setProperty("isFullTextSearchable", String.valueOf(pd.isFullTextSearchable()));
                pdNode.setProperty("isQueryOrderable", String.valueOf(pd.isQueryOrderable()));
                if (pd.getAvailableQueryOperators() != null) {
                    pdNode.setProperty("availableQueryOperators", Arrays.asList(pd.getAvailableQueryOperators()));
                }
                pdNode.setProperty("requiredType", String.valueOf(pd.getRequiredType()));
                if (pd.getValueConstraints() != null) {
                    pdNode.setProperty("valueConstraints", Arrays.asList(pd.getValueConstraints()));
                }
                pdNode.setProperty("onParentVersion", String.valueOf(pd.getOnParentVersion()));
                if (pd.getDefaultValues() != null) {
                    ArrayList<String> defaultValList = new ArrayList<String>();
                    for (Value value : pd.getDefaultValues()) {
                        defaultValList.add(value.getString());
                    }
                    pdNode.setProperty("defaultValues", defaultValList);
                }
                registrySession.getUserRegistry().put(propDefPath, pdNode);
            }
            for (PropertyDefinition propertyDefinition : nodeTypeTemplate.getDeclaredChildNodeDefinitions()) {
                NodeDefinitionTemplate nd = (NodeDefinitionTemplate)propertyDefinition;
                String childDefPath = nodeTypePath + "/" + "child_defs" + "/" + nd.getName();
                Resource childNode = registrySession.getUserRegistry().newResource();
                childNode.setProperty("name", nd.getName());
                childNode.setProperty("autoCreated", String.valueOf(nd.isAutoCreated()));
                childNode.setProperty("mandatory", String.valueOf(nd.isMandatory()));
                childNode.setProperty("protected", String.valueOf(nd.isProtected()));
                childNode.setProperty("onParentVersion", String.valueOf(nd.getOnParentVersion()));
                childNode.setProperty("sameNameSiblings", String.valueOf(nd.allowsSameNameSiblings()));
                childNode.setProperty("defaultPrimaryType", nd.getDefaultPrimaryTypeName());
                if (nd.getRequiredPrimaryTypeNames() != null) {
                    childNode.setProperty("requiredPrimaryTypes", Arrays.asList(nd.getRequiredPrimaryTypeNames()));
                }
                registrySession.getUserRegistry().put(childDefPath, childNode);
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        catch (ValueFormatException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public static void loadNodeTypesFromRegistry(RegistryNodeTypeManager registryNodeTypeManager, RegistrySession registrySession) {
        NodeTypeTemplate nodeTypeTemplate = null;
        try {
            String[] paths;
            nodeTypeTemplate = registryNodeTypeManager.createNodeTypeTemplate();
            for (String path : paths = ((CollectionImpl)registrySession.getUserRegistry().get(RegistryJCRSpecificStandardLoderUtil.getSystemConfigNodeTypePath(registrySession))).getChildren()) {
                CollectionImpl nodeType = (CollectionImpl)registrySession.getUserRegistry().get(path);
                nodeTypeTemplate.setName(nodeType.getProperty("name"));
                if (nodeType.getPropertyValues("declaredSuperTypes") != null) {
                    nodeTypeTemplate.setDeclaredSuperTypeNames(nodeType.getPropertyValues("declaredSuperTypes").toArray(new String[0]));
                }
                nodeTypeTemplate.setMixin(Boolean.valueOf(nodeType.getProperty("isMixin")).booleanValue());
                nodeTypeTemplate.setOrderableChildNodes(Boolean.valueOf(nodeType.getProperty("hasOrderableChildNodes")).booleanValue());
                nodeTypeTemplate.setAbstract(Boolean.valueOf(nodeType.getProperty("isAbstract")).booleanValue());
                nodeTypeTemplate.setQueryable(Boolean.valueOf(nodeType.getProperty("isQueryable")).booleanValue());
                nodeTypeTemplate.setPrimaryItemName(nodeType.getProperty("primaryItemName"));
                String childDefRootPath = path + "/" + "child_defs";
                if (registrySession.getUserRegistry().resourceExists(childDefRootPath)) {
                    String[] childDefPaths;
                    for (String childPath : childDefPaths = ((CollectionImpl)registrySession.getUserRegistry().get(childDefRootPath)).getChildren()) {
                        Resource childDef = registrySession.getUserRegistry().get(childPath);
                        NodeDefinitionTemplate nodeDefinitionTemplate = registryNodeTypeManager.createNodeDefinitionTemplate();
                        nodeDefinitionTemplate.setName(childDef.getProperty("name"));
                        nodeDefinitionTemplate.setAutoCreated(Boolean.valueOf(childDef.getProperty("autoCreated")).booleanValue());
                        nodeDefinitionTemplate.setMandatory(Boolean.valueOf(childDef.getProperty("mandatory")).booleanValue());
                        nodeDefinitionTemplate.setProtected(Boolean.valueOf(childDef.getProperty("protected")).booleanValue());
                        nodeDefinitionTemplate.setOnParentVersion(Integer.valueOf(childDef.getProperty("onParentVersion")).intValue());
                        nodeDefinitionTemplate.setSameNameSiblings(Boolean.valueOf(childDef.getProperty("sameNameSiblings")).booleanValue());
                        nodeDefinitionTemplate.setDefaultPrimaryTypeName(childDef.getProperty("defaultPrimaryType"));
                        if (childDef.getPropertyValues("requiredPrimaryTypes") != null) {
                            nodeDefinitionTemplate.setRequiredPrimaryTypeNames(childDef.getPropertyValues("requiredPrimaryTypes").toArray(new String[0]));
                        }
                        nodeTypeTemplate.getNodeDefinitionTemplates().add(nodeDefinitionTemplate);
                    }
                }
                String propDefRootPath = path + "/" + "prop_defs";
                if (registrySession.getUserRegistry().resourceExists(propDefRootPath)) {
                    String[] propDefPaths;
                    for (String propPath : propDefPaths = ((CollectionImpl)registrySession.getUserRegistry().get(propDefRootPath)).getChildren()) {
                        Resource propdDef = registrySession.getUserRegistry().get(propPath);
                        PropertyDefinitionTemplate propertyDefinitionTemplate = registryNodeTypeManager.createPropertyDefinitionTemplate();
                        propertyDefinitionTemplate.setName(propdDef.getProperty("name"));
                        propertyDefinitionTemplate.setAutoCreated(Boolean.valueOf(propdDef.getProperty("autoCreated")).booleanValue());
                        propertyDefinitionTemplate.setMandatory(Boolean.valueOf(propdDef.getProperty("mandatory")).booleanValue());
                        propertyDefinitionTemplate.setProtected(Boolean.valueOf(propdDef.getProperty("protected")).booleanValue());
                        propertyDefinitionTemplate.setMultiple(Boolean.valueOf(propdDef.getProperty("multiple")).booleanValue());
                        propertyDefinitionTemplate.setFullTextSearchable(Boolean.valueOf(propdDef.getProperty("isFullTextSearchable")).booleanValue());
                        propertyDefinitionTemplate.setQueryOrderable(Boolean.valueOf(propdDef.getProperty("isQueryOrderable")).booleanValue());
                        if (propdDef.getPropertyValues("availableQueryOperators") != null) {
                            propertyDefinitionTemplate.setAvailableQueryOperators(propdDef.getPropertyValues("availableQueryOperators").toArray(new String[0]));
                        }
                        propertyDefinitionTemplate.setOnParentVersion(Integer.valueOf(propdDef.getProperty("onParentVersion")).intValue());
                        propertyDefinitionTemplate.setOnParentVersion(Integer.valueOf(propdDef.getProperty("requiredType")).intValue());
                        if (propdDef.getPropertyValues("valueConstraints") != null) {
                            propertyDefinitionTemplate.setValueConstraints(propdDef.getPropertyValues("valueConstraints").toArray(new String[0]));
                        }
                        if (propdDef.getPropertyValues("defaultValues") != null) {
                            propertyDefinitionTemplate.setValueConstraints(propdDef.getPropertyValues("defaultValues").toArray(new String[0]));
                        }
                        nodeTypeTemplate.getPropertyDefinitionTemplates().add(propertyDefinitionTemplate);
                    }
                }
                RegistryNodeType nodeTypeBean = new RegistryNodeType((NodeTypeDefinition)nodeTypeTemplate, registryNodeTypeManager);
                if (nodeTypeTemplate.getName() != null && nodeTypeTemplate.getName().startsWith("mix")) {
                    registryNodeTypeManager.getMixinNodetypes().add(nodeTypeBean);
                } else {
                    registryNodeTypeManager.getPrimaryNodetypes().add(nodeTypeBean);
                }
                registryNodeTypeManager.getNodeTypesList().add(nodeTypeBean);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
    }

    public static void unregisterNodeTypeFromRegistry(RegistrySession registrySession, RegistryNodeTypeManager registryNodeTypeManager, String nodeType) {
        try {
            String[] paths;
            for (String path : paths = ((CollectionImpl)registrySession.getUserRegistry().get(RegistryJCRSpecificStandardLoderUtil.getSystemConfigNodeTypePath(registrySession))).getChildren()) {
                String name = path.split("/")[path.split("/").length - 1];
                if (!name.equals(nodeType)) continue;
                registrySession.getUserRegistry().delete(path);
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
    }
}

