/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.util.nodetype.xml;

import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.version.OnParentVersionAction;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.jaxen.JaxenException;
import org.wso2.carbon.registry.jcr.RegistryValue;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeDefinitionTemplate;
import org.wso2.carbon.registry.jcr.nodetype.RegistryPropertyDefinitionTemplate;

public class NodeTypeReader {
    NodeTypeManager nodeTypeManager;
    NodeTypeTemplate nodeTypeTemplate;

    public NodeTypeReader(NodeTypeManager nodeTypeManager) {
        this.nodeTypeManager = nodeTypeManager;
    }

    private void buildSupertypes(OMElement omElement) throws ConstraintViolationException {
        Iterator supertypeIt = omElement.getChildrenWithLocalName("supertypes");
        while (supertypeIt.hasNext()) {
            OMElement supertypes = (OMElement)supertypeIt.next();
            Iterator it1 = supertypes.getChildrenWithLocalName("supertype");
            ArrayList<String> superTypeList = new ArrayList<String>();
            while (it1.hasNext()) {
                superTypeList.add(((OMElement)it1.next()).getText());
            }
            this.nodeTypeTemplate.setDeclaredSuperTypeNames(superTypeList.toArray(new String[0]));
        }
    }

    private void buildChildNodeDefs(OMElement omElement) throws RepositoryException {
        Iterator cndIt = omElement.getChildrenWithLocalName("childNodeDefinition");
        while (cndIt.hasNext()) {
            NodeDefinitionTemplate nodeDefinitionTemplate = this.nodeTypeManager.createNodeDefinitionTemplate();
            OMElement childDefs = (OMElement)cndIt.next();
            nodeDefinitionTemplate.setName(this.getAttrValue("name", childDefs));
            nodeDefinitionTemplate.setAutoCreated(Boolean.valueOf(this.getAttrValue("autoCreated", childDefs)).booleanValue());
            nodeDefinitionTemplate.setMandatory(Boolean.valueOf(this.getAttrValue("mandatory", childDefs)).booleanValue());
            nodeDefinitionTemplate.setProtected(Boolean.valueOf(this.getAttrValue("protected", childDefs)).booleanValue());
            nodeDefinitionTemplate.setOnParentVersion(OnParentVersionAction.valueFromName((String)this.getAttrValue("onParentVersion", childDefs)));
            nodeDefinitionTemplate.setSameNameSiblings(Boolean.valueOf(this.getAttrValue("sameNameSiblings", childDefs)).booleanValue());
            String dpt = this.getAttrValue("defaultPrimaryType", childDefs);
            if (dpt != null && dpt.length() > 0) {
                nodeDefinitionTemplate.setDefaultPrimaryTypeName(dpt);
            }
            Iterator reqPriTypesIt = childDefs.getChildrenWithLocalName("requiredPrimaryTypes");
            while (reqPriTypesIt.hasNext()) {
                OMElement supertypes = (OMElement)reqPriTypesIt.next();
                Iterator supertype = supertypes.getChildrenWithLocalName("requiredPrimaryType");
                ArrayList<String> rptList = new ArrayList<String>();
                while (supertype.hasNext()) {
                    rptList.add(((OMElement)supertype.next()).getText());
                }
                nodeDefinitionTemplate.setRequiredPrimaryTypeNames(rptList.toArray(new String[0]));
            }
            ((RegistryNodeDefinitionTemplate)nodeDefinitionTemplate).setDeclaringNodeTypeName(this.nodeTypeTemplate.getName());
            this.nodeTypeTemplate.getNodeDefinitionTemplates().add(nodeDefinitionTemplate);
        }
    }

    private String getAttrValue(String key, OMElement omElement) {
        if (omElement.getAttribute(new QName(key)) != null && !"".equals(omElement.getAttribute(new QName(key)).getAttributeValue())) {
            return omElement.getAttribute(new QName(key)).getAttributeValue();
        }
        return null;
    }

    private void buildPropertyDefs(OMElement omElement) throws RepositoryException {
        Iterator iterator = omElement.getChildrenWithName(new QName("propertyDefinition"));
        while (iterator.hasNext()) {
            String defaultValues;
            PropertyDefinitionTemplate propertyDefinitionTemplate = this.nodeTypeManager.createPropertyDefinitionTemplate();
            OMElement child = (OMElement)iterator.next();
            propertyDefinitionTemplate.setName(this.getAttrValue("name", child));
            propertyDefinitionTemplate.setAutoCreated(Boolean.valueOf(this.getAttrValue("autoCreated", child)).booleanValue());
            propertyDefinitionTemplate.setMandatory(Boolean.valueOf(this.getAttrValue("mandatory", child)).booleanValue());
            propertyDefinitionTemplate.setProtected(Boolean.valueOf(this.getAttrValue("protected", child)).booleanValue());
            propertyDefinitionTemplate.setOnParentVersion(OnParentVersionAction.valueFromName((String)this.getAttrValue("onParentVersion", child)));
            propertyDefinitionTemplate.setMultiple(Boolean.valueOf(this.getAttrValue("multiple", child)).booleanValue());
            propertyDefinitionTemplate.setFullTextSearchable(Boolean.valueOf(this.getAttrValue("isFullTextSearchable", child)).booleanValue());
            propertyDefinitionTemplate.setQueryOrderable(Boolean.valueOf(this.getAttrValue("isQueryOrderable", child)).booleanValue());
            String aqop = this.getAttrValue("availableQueryOperators", child);
            if (aqop != null && aqop.length() > 0) {
                String[] ops = aqop.split(" ");
                ArrayList<String> queryOpt = new ArrayList<String>();
                for (String op1 : ops) {
                    String opt = op1.trim();
                    if (opt.equals("OP_EQ")) {
                        queryOpt.add("jcr.operator.equal.to");
                        continue;
                    }
                    if (opt.equals("OP_NE")) {
                        queryOpt.add("jcr.operator.not.equal.to");
                        continue;
                    }
                    if (opt.equals("OP_LT")) {
                        queryOpt.add("jcr.operator.less.than");
                        continue;
                    }
                    if (opt.equals("OP_LE")) {
                        queryOpt.add("jcr.operator.less.than.or.equal.to");
                        continue;
                    }
                    if (opt.equals("OP_GT")) {
                        queryOpt.add("jcr.operator.greater.than");
                        continue;
                    }
                    if (opt.equals("OP_GE")) {
                        queryOpt.add("jcr.operator.greater.than.or.equal.to");
                        continue;
                    }
                    if (opt.equals("OP_LIKE")) {
                        queryOpt.add("jcr.operator.like");
                        continue;
                    }
                    throw new NoSuchNodeTypeException("Not a valid query operator" + op1);
                }
                propertyDefinitionTemplate.setAvailableQueryOperators(queryOpt.toArray(new String[0]));
            }
            propertyDefinitionTemplate.setRequiredType(PropertyType.valueFromName((String)this.getAttrValue("requiredType", child)));
            String valueConstraints = this.getAttrValue("valueConstraints", child);
            if (valueConstraints != null) {
                String tmp = valueConstraints.substring(1, valueConstraints.length() - 1);
                String[] s = tmp.split(",");
                propertyDefinitionTemplate.setValueConstraints(s);
            }
            if ((defaultValues = this.getAttrValue("defaultValues", child)) != null && !"".equals(defaultValues)) {
                String tmp = defaultValues.substring(1, defaultValues.length() - 1);
                String[] s = tmp.split(",");
                Value[] values = new Value[s.length];
                for (int i = 0; i < s.length; ++i) {
                    values[i] = new RegistryValue(s[i]);
                }
                propertyDefinitionTemplate.setDefaultValues(values);
            }
            ((RegistryPropertyDefinitionTemplate)propertyDefinitionTemplate).setDeclaringNodeTypeName(this.nodeTypeTemplate.getName());
            this.nodeTypeTemplate.getPropertyDefinitionTemplates().add(propertyDefinitionTemplate);
        }
    }

    public NodeTypeTemplate buildNodeType(OMElement omElement) throws JaxenException, RepositoryException {
        this.nodeTypeTemplate = this.nodeTypeManager.createNodeTypeTemplate();
        this.nodeTypeTemplate.setName(this.getAttrValue("name", omElement));
        this.nodeTypeTemplate.setMixin(Boolean.valueOf(this.getAttrValue("isMixin", omElement)).booleanValue());
        this.nodeTypeTemplate.setOrderableChildNodes(Boolean.valueOf(this.getAttrValue("hasOrderableChildNodes", omElement)).booleanValue());
        this.nodeTypeTemplate.setAbstract(Boolean.valueOf(this.getAttrValue("isAbstract", omElement)).booleanValue());
        this.nodeTypeTemplate.setQueryable(Boolean.valueOf(this.getAttrValue("isQueryable", omElement)).booleanValue());
        this.nodeTypeTemplate.setPrimaryItemName(this.getAttrValue("primaryItemName", omElement));
        this.buildSupertypes(omElement);
        this.buildChildNodeDefs(omElement);
        this.buildPropertyDefs(omElement);
        return this.nodeTypeTemplate;
    }
}

