/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.util.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.wso2.carbon.registry.jcr.security.RegistryPrivilege;
import org.wso2.carbon.registry.jcr.util.security.RegistryPrivilegeDefinition;

public class PrivilegeRegistry {
    private static int HASH_COUNT = 0;
    private Map<String, Privilege> localPrivilegeCache;
    private static Set<RegistryPrivilegeDefinition> REGISTERED_JCR_PRIVELEDGES;
    private static RegistryPrivilegeDefinition READ_PRIVILEGE;
    private static RegistryPrivilegeDefinition ADD_CHILD_NODES_PRIVILEGE;
    private static RegistryPrivilegeDefinition REMOVE_CHILD_NODES_PRIVILEGE;
    private static RegistryPrivilegeDefinition MODIFY_PROPERTIES_PRIVILEGE;
    private static RegistryPrivilegeDefinition REMOVE_NODE_PRIVILEGE;
    private static RegistryPrivilegeDefinition READ_AC_PRIVILEGE;
    private static RegistryPrivilegeDefinition MODIFY_AC_PRIVILEGE;
    private static RegistryPrivilegeDefinition NODE_TYPE_MANAGEMENT_PRIVILEGE;
    private static RegistryPrivilegeDefinition VERSION_MANAGEMENT_PRIVILEGE;
    private static RegistryPrivilegeDefinition LOCK_MANAGEMENT_PRIVILEGE;
    private static RegistryPrivilegeDefinition LIFECYCLE_MANAGEMENT_PRIVILEGE;
    private static RegistryPrivilegeDefinition RETENTION_MANAGEMENT_PRIVILEGE;
    private static RegistryPrivilegeDefinition WRITE_PRIVILEGE;
    private static RegistryPrivilegeDefinition ALL_PRIVILEGE;

    public Map<String, Privilege> getLocalPrivilegeCache() {
        return this.localPrivilegeCache;
    }

    private static RegistryPrivilegeDefinition registerPrivilege(RegistryPrivilegeDefinition registryPrivilegeDefinition) {
        REGISTERED_JCR_PRIVELEDGES.add(registryPrivilegeDefinition);
        return registryPrivilegeDefinition;
    }

    public static void registerAllPrivileges() {
        READ_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}read"));
        ADD_CHILD_NODES_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}addChildNodes"));
        REMOVE_CHILD_NODES_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}removeChildNodes"));
        MODIFY_PROPERTIES_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}modifyProperties"));
        REMOVE_NODE_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}removeNode"));
        READ_AC_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}readAccessControl"));
        MODIFY_AC_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}modifyAccessControl"));
        NODE_TYPE_MANAGEMENT_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}nodeTypeManagement"));
        VERSION_MANAGEMENT_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}versionManagement"));
        LOCK_MANAGEMENT_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}lockManagement"));
        LIFECYCLE_MANAGEMENT_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}lifecycleManagement"));
        RETENTION_MANAGEMENT_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}retentionManagement"));
        WRITE_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}write", new RegistryPrivilegeDefinition[]{MODIFY_PROPERTIES_PRIVILEGE, ADD_CHILD_NODES_PRIVILEGE, REMOVE_CHILD_NODES_PRIVILEGE, REMOVE_NODE_PRIVILEGE}));
        ALL_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new RegistryPrivilegeDefinition("{http://www.jcp.org/jcr/1.0}all", new RegistryPrivilegeDefinition[]{READ_PRIVILEGE, WRITE_PRIVILEGE, READ_AC_PRIVILEGE, MODIFY_AC_PRIVILEGE, NODE_TYPE_MANAGEMENT_PRIVILEGE, VERSION_MANAGEMENT_PRIVILEGE, LOCK_MANAGEMENT_PRIVILEGE, LIFECYCLE_MANAGEMENT_PRIVILEGE, RETENTION_MANAGEMENT_PRIVILEGE}));
    }

    public PrivilegeRegistry() {
        this.init();
    }

    public void refreshPrivRegistry() {
        this.init();
    }

    private void init() {
        REGISTERED_JCR_PRIVELEDGES = new HashSet<RegistryPrivilegeDefinition>();
        HASH_COUNT = 0;
        PrivilegeRegistry.registerAllPrivileges();
        this.localPrivilegeCache = new HashMap<String, Privilege>(REGISTERED_JCR_PRIVELEDGES.size());
        for (RegistryPrivilegeDefinition rpd : REGISTERED_JCR_PRIVELEDGES) {
            RegistryPrivilege priv = new RegistryPrivilege(rpd);
            this.localPrivilegeCache.put(priv.getName(), priv);
        }
    }

    public Privilege getPrivilegeFromName(String name) throws AccessControlException {
        String key = RegistryPrivilegeDefinition.getNameFromPrefix(name);
        if (this.localPrivilegeCache.containsKey(key)) {
            return this.localPrivilegeCache.get(key);
        }
        throw new AccessControlException(key + " isn't the name of a known privilege.");
    }

    public Privilege[] getRegisteredPrivileges() {
        return this.localPrivilegeCache.values().toArray(new Privilege[this.localPrivilegeCache.size()]);
    }

    public static int getHashCounter() {
        return HASH_COUNT++;
    }
}

