/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.util.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.wso2.carbon.registry.jcr.util.RegistryJCRItemOperationUtil;
import org.wso2.carbon.registry.jcr.util.security.PrivilegeRegistry;

public class RegistryPrivilegeDefinition {
    private String name;
    private boolean isAbstract;
    private boolean isAggregate;
    private RegistryPrivilegeDefinition[] declaredAggregatePrivileges;
    private Set<RegistryPrivilegeDefinition> aggregatePrivileges;
    private String URI_NAME = "";
    private int HASH_CODE = PrivilegeRegistry.getHashCounter();

    public int getHASH_CODE() {
        return this.HASH_CODE;
    }

    public RegistryPrivilegeDefinition(String name, RegistryPrivilegeDefinition[] declaredAggregatePrivileges) {
        this.URI_NAME = name;
        this.name = RegistryPrivilegeDefinition.getNameFromPrefix(name);
        this.isAbstract = false;
        this.isAggregate = true;
        this.declaredAggregatePrivileges = Arrays.copyOf(declaredAggregatePrivileges, declaredAggregatePrivileges.length);
        HashSet<RegistryPrivilegeDefinition> tempAggregates = new HashSet<RegistryPrivilegeDefinition>();
        for (RegistryPrivilegeDefinition priv : declaredAggregatePrivileges) {
            if (priv.isAggregate()) {
                tempAggregates.addAll(priv.getAggregatePrivileges());
                tempAggregates.add(priv);
                continue;
            }
            tempAggregates.add(priv);
        }
        this.aggregatePrivileges = Collections.unmodifiableSet(tempAggregates);
    }

    public RegistryPrivilegeDefinition(String name) {
        this.URI_NAME = name;
        this.name = RegistryPrivilegeDefinition.getNameFromPrefix(name);
        this.isAbstract = false;
        this.isAggregate = false;
        this.declaredAggregatePrivileges = null;
        this.aggregatePrivileges = null;
    }

    public String getURI_NAME() {
        return this.URI_NAME;
    }

    public static String getNameFromPrefix(String _name) {
        if (_name.contains("{")) {
            return RegistryJCRItemOperationUtil.replaceNameSpacePrefixURIS(_name);
        }
        return _name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Set<RegistryPrivilegeDefinition> getAggregatePrivileges() {
        return this.aggregatePrivileges;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public RegistryPrivilegeDefinition[] getDeclaredAggregatePrivileges() {
        return this.declaredAggregatePrivileges;
    }
}

