/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.util.test.data;

import javax.jcr.RepositoryException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.jcr.RegistrySession;

public class TCKTestDataLoader {
    public static void loadRetentionPolicies(RegistrySession session) throws RepositoryException {
        try {
            if (!session.getUserRegistry().resourceExists("/jcr_system/workspaces/default_workspace/test_policy_holder")) {
                session.getRootNode().addNode("test_policy_holder");
            }
            Resource r = session.getUserRegistry().get("/jcr_system/workspaces/default_workspace/test_policy_holder");
            r.setProperty("org.wso2.carbon.registry.jcr.retention.policy", "fullLocked");
            session.getUserRegistry().put("/jcr_system/workspaces/default_workspace/test_policy_holder", r);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Unable to load TCK test data");
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Unable to load TCK test data");
        }
    }

    public static void removeRetentionPolicies(RegistrySession session) throws RepositoryException {
        try {
            if (session.getUserRegistry().resourceExists("/jcr_system/workspaces/default_workspace/testroot")) {
                Resource r = session.getUserRegistry().get("/jcr_system/workspaces/default_workspace/testroot");
                r.removeProperty("org.wso2.carbon.registry.jcr.retention.policy");
                r.removeProperty("org.wso2.carbon.registry.jcr.retention.holds");
                session.getUserRegistry().put(r.getPath(), r);
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Unable to remove TCK retention test data");
        }
    }
}

