/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.version;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.jcr.RegistryNode;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.util.RegistryJCRItemOperationUtil;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;
import org.wso2.carbon.registry.jcr.version.RegistryVersion;
import org.wso2.carbon.registry.jcr.version.RegistryVersionHistory;

public class RegistryVersionManager
implements VersionManager {
    private static long versionCounter = 0L;
    private Session session;
    private Map<String, VersionHistory> versionHistories = new HashMap<String, VersionHistory>();
    private String currentActivityNodePath = "";
    private int configNodeCount = 0;

    public RegistryVersionManager(Session session) {
        this.session = session;
    }

    private Version createVersionOnNode(String nodePath) throws RegistryException {
        String latestVersionPath = "";
        RegistryVersion version = null;
        ((RegistrySession)this.session).getUserRegistry().createVersion(nodePath);
        String[] regVerPaths = ((RegistrySession)this.session).getUserRegistry().getVersions(nodePath);
        latestVersionPath = regVerPaths[0];
        this.addVersionToHistory(nodePath, latestVersionPath);
        version = new RegistryVersion(latestVersionPath, System.currentTimeMillis(), nodePath, this.session);
        if (this.versionHistories.get(nodePath) != null) {
            ((RegistryVersionHistory)this.versionHistories.get(nodePath)).getVersionList().add(version);
            version.setVersionHistory((RegistryVersionHistory)this.versionHistories.get(nodePath));
        } else {
            RegistryVersionHistory vh = new RegistryVersionHistory(this.session, nodePath);
            vh.getVersionList().add(version);
            version.setVersionHistory(vh);
            this.versionHistories.put(nodePath, vh);
        }
        return version;
    }

    public Version checkin(String s) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        Version version = null;
        String latestVersionPath = "";
        if (!this.isNodeTypeVersionable(s)) {
            throw new UnsupportedRepositoryOperationException("Cannot apply checkin for non versionalbe nodes .!!!");
        }
        try {
            RegistryJCRItemOperationUtil.validateSessionSaved((RegistrySession)this.session);
            Value propVal = ((Node)this.session.getItem(s)).getProperty("jcr:checkedOut").getValue();
            if (propVal != null && propVal.getString().equals("true")) {
                CollectionImpl vnode = (CollectionImpl)((RegistrySession)this.session).getUserRegistry().get(s);
                vnode.setProperty("jcr:checkedOut", "false");
                vnode.setProperty("jcr:isCheckedOut", "false");
                ((RegistrySession)this.session).getUserRegistry().put(s, (Resource)vnode);
                version = this.createVersionOnNode(s);
            } else {
                List<String> list = this.getVersionList(s);
                version = new RegistryVersion(list.get(list.size() - 1), System.currentTimeMillis(), s, this.session);
            }
        }
        catch (PathNotFoundException e) {
            version = this.getBaseVersion(s);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Exception occurred at registry level..!!" + e.getMessage());
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("Cannot do checkin to unsaved nodes..!!!");
        }
        return version;
    }

    private void addVersionToHistory(String nodePath, String nodeVersion) {
        try {
            String confPath = RegistryJCRSpecificStandardLoderUtil.getSystemConfigVersionPath((RegistrySession)this.session);
            Resource resource = ((RegistrySession)this.session).getUserRegistry().get(confPath);
            if (resource.getProperty(nodePath) != null) {
                resource.getPropertyValues(nodePath).add(nodeVersion);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(nodeVersion);
                resource.setProperty(nodePath, list);
            }
            ((RegistrySession)this.session).getUserRegistry().put(confPath, resource);
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
    }

    private List<String> getVersionList(String nodePath) throws RegistryException {
        String confPath = RegistryJCRSpecificStandardLoderUtil.getSystemConfigVersionPath((RegistrySession)this.session);
        return ((RegistrySession)this.session).getUserRegistry().get(confPath).getPropertyValues(nodePath);
    }

    private boolean isNodeTypeVersionable(String s) throws RepositoryException {
        return this.session.getNode(s).isNodeType("mix:versionable") || this.session.getNode(s).isNodeType("mix:simpleVersionable");
    }

    public void checkout(String s) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        if (!this.isNodeTypeVersionable(s)) {
            throw new UnsupportedRepositoryOperationException("Cannot apply checkout for non versionalbe nodes .!!!");
        }
        try {
            Resource resource = ((RegistrySession)this.session).getUserRegistry().get(s);
            resource.setProperty("jcr:checkedOut", "true");
            resource.setProperty("jcr:isCheckedOut", "true");
            ((RegistrySession)this.session).getUserRegistry().put(s, resource);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Exception occurred at Registry level");
        }
    }

    public Version checkpoint(String s) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        this.checkout(s);
        return this.checkin(s);
    }

    public boolean isCheckedOut(String s) throws RepositoryException {
        try {
            String propVal1 = ((RegistrySession)this.session).getUserRegistry().get(s).getProperty("jcr:checkedOut");
            String propVal2 = ((RegistrySession)this.session).getUserRegistry().get(s).getProperty("jcr:isCheckedOut");
            if (propVal1.equals("true") || propVal2.equals("true")) {
                return true;
            }
            if (propVal1.equals("false") || propVal2.equals("false")) {
                return false;
            }
        }
        catch (NullPointerException propVal1) {
        }
        catch (RegistryException e) {
            throw new RepositoryException(e.getMessage());
        }
        return this.nonVersionableNodeChckoutCheck(s);
    }

    private boolean nonVersionableNodeChckoutCheck(String s) throws RepositoryException {
        Node vParent = null;
        try {
            vParent = this.session.getNode(s).getParent();
            while (!vParent.isNodeType("mix:simpleVersionable")) {
                vParent = vParent.getParent();
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (AccessDeniedException e) {
            throw new AccessDeniedException("Access denied on node " + s);
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundException("No such path exists " + s);
        }
        try {
            if (vParent != null && vParent.isNodeType("mix:simpleVersionable")) {
                return vParent.isCheckedOut();
            }
            return true;
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public VersionHistory getVersionHistory(String s) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.versionHistories.get(s) == null) {
            this.versionHistories.put(s, new RegistryVersionHistory(this.session, s));
        }
        return this.versionHistories.get(s);
    }

    public Version getBaseVersion(String s) throws UnsupportedRepositoryOperationException, RepositoryException {
        if ((RegistryVersionHistory)this.versionHistories.get(s) != null && ((RegistryVersionHistory)this.versionHistories.get(s)).getVersionList().size() > 0) {
            List<Version> list = ((RegistryVersionHistory)this.versionHistories.get(s)).getVersionList();
            return list.get(list.size() - 1);
        }
        return null;
    }

    public void restore(Version[] versions, boolean b) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        for (Version version : versions) {
            this.restore(version, b);
        }
    }

    private boolean isVersionInNodeVersionHistory(String nodePth, String vPath) throws RegistryException, VersionException {
        if (this.getVersionList(nodePth).contains(vPath)) {
            return true;
        }
        throw new VersionException("No such version in node's version history" + nodePth);
    }

    private boolean isValidVersionName(String nodePath) throws UnsupportedRepositoryOperationException {
        try {
            this.session.getItem(nodePath);
        }
        catch (PathNotFoundException e) {
            throw new UnsupportedRepositoryOperationException("Unsupported : non versionable node " + nodePath);
        }
        catch (RepositoryException e) {
            throw new UnsupportedRepositoryOperationException("Unsupported : non versionable node " + nodePath);
        }
        return true;
    }

    public void restore(String s, String s1, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        if (s1 == null) {
            throw new VersionException("Cannot do restore opeartion on jcr:rootVersion ..!!!");
        }
        if (!this.isNodeTypeVersionable(s)) {
            throw new UnsupportedRepositoryOperationException("Cannot do restore on non versionable nodes");
        }
        try {
            RegistryJCRItemOperationUtil.validateSessionSaved((RegistrySession)this.session);
            if (this.isNodeTypeVersionable(s) && this.isValidVersionName(s) && this.isVersionInNodeVersionHistory(s, s1)) {
                ((RegistrySession)this.session).getUserRegistry().restoreVersion(s1);
                Resource resource = ((RegistrySession)this.session).getUserRegistry().get(s);
                resource.setProperty("jcr:isCheckedOut", "false");
                resource.setProperty("jcr:checkedOut", "false");
                ((RegistrySession)this.session).getUserRegistry().put(s, resource);
                this.createVersionOnNode(s);
            }
        }
        catch (VersionException e) {
            throw new VersionException("No such version in node's version history" + s);
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new UnsupportedRepositoryOperationException("Node type not Versionable : " + s);
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("Invalid Item state: operations are still unsaved");
        }
        catch (RegistryException e) {
            throw new RepositoryException("Excepion occurred in registry level while restoring");
        }
    }

    public void restore(Version version, boolean b) throws VersionException, ItemExistsException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        if (version != null && version.getName() == null) {
            throw new VersionException("Cannot do restore opeartion on jcr:rootVersion ..!!!");
        }
        if (!this.isNodeTypeVersionable(RegistryJCRItemOperationUtil.getNodePathFromVersionName(version.getName()))) {
            throw new UnsupportedRepositoryOperationException("Cannot do restore on non versionable nodes");
        }
        try {
            RegistryJCRItemOperationUtil.validateSessionSaved((RegistrySession)this.session);
            if (version != null && this.isValidVersionName(RegistryJCRItemOperationUtil.getNodePathFromVersionName(version.getName())) && this.isVersionInNodeVersionHistory(RegistryJCRItemOperationUtil.getNodePathFromVersionName(version.getName()), version.getName())) {
                ((RegistrySession)this.session).getUserRegistry().restoreVersion(version.getName());
                Resource resource = ((RegistrySession)this.session).getUserRegistry().get(RegistryJCRItemOperationUtil.getNodePathFromVersionName(version.getName()));
                resource.setProperty("jcr:isCheckedOut", "false");
                resource.setProperty("jcr:checkedOut", "false");
                ((RegistrySession)this.session).getUserRegistry().put(RegistryJCRItemOperationUtil.getNodePathFromVersionName(version.getName()), resource);
                this.createVersionOnNode(RegistryJCRItemOperationUtil.getNodePathFromVersionName(version.getName()));
            }
        }
        catch (VersionException e) {
            throw new VersionException("No such version in node's version history" + RegistryJCRItemOperationUtil.getNodePathFromVersionName(version.getName()));
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("Invalid Item state: operations are still unsaved");
        }
        catch (RegistryException e) {
            throw new RepositoryException("Excepion occurred in registry level while restoring");
        }
    }

    public void restore(String s, Version version, boolean b) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        if (version != null && version.getName() == null) {
            throw new VersionException("Cannot do restore opeartion on jcr:rootVersion ..!!!");
        }
        if (!this.isNodeTypeVersionable(s)) {
            throw new UnsupportedRepositoryOperationException("Cannot do restore on non versionable nodes");
        }
        try {
            RegistryJCRItemOperationUtil.validateSessionSaved((RegistrySession)this.session);
            Item i = this.session.getItem(s);
            throw new VersionException("There must be no existing node at absPath " + s);
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("Invalid Item state: operations are still unsaved");
        }
        catch (PathNotFoundException e) {
            try {
                if (version != null && this.isNodeTypeVersionable(s) && this.isValidVersionName(s) && this.isVersionInNodeVersionHistory(s, version.getName())) {
                    ((RegistrySession)this.session).getUserRegistry().restoreVersion(version.getName());
                    Resource resource = ((RegistrySession)this.session).getUserRegistry().get(RegistryJCRItemOperationUtil.getNodePathFromVersionName(version.getName()));
                    resource.setProperty("jcr:isCheckedOut", "false");
                    resource.setProperty("jcr:checkedOut", "false");
                    ((RegistrySession)this.session).getUserRegistry().put(RegistryJCRItemOperationUtil.getNodePathFromVersionName(version.getName()), resource);
                    this.createVersionOnNode(RegistryJCRItemOperationUtil.getNodePathFromVersionName(version.getName()));
                }
            }
            catch (VersionException e2) {
                throw new VersionException("No such version in node's version history" + s);
            }
            catch (RegistryException e3) {
                throw new RepositoryException("Excepion occurred in registry level while restoring");
            }
            return;
        }
    }

    public void restoreByLabel(String s, String s1, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        try {
            String verPath = ((RegistrySession)this.session).getUserRegistry().get(RegistryJCRSpecificStandardLoderUtil.getSystemConfigVersionLabelPath((RegistrySession)this.session)).getProperty(s1);
            ((RegistrySession)this.session).getUserRegistry().restoreVersion(verPath);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Excepion occurred in registry level while restoring by label on : " + s);
        }
    }

    public NodeIterator merge(String s, String s1, boolean b) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return null;
    }

    public NodeIterator merge(String s, String s1, boolean b, boolean b1) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return null;
    }

    public void doneMerge(String s, Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
    }

    public void cancelMerge(String s, Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
    }

    public Node createConfiguration(String s) throws UnsupportedRepositoryOperationException, RepositoryException {
        String configNodeName = "jcr:configNode" + this.configNodeCount++;
        ((RegistryNode)this.session.getItem(s)).addNode(configNodeName, "nt:configuration").setProperty("jcr:root", s);
        ((RegistryNode)this.session.getItem(s)).setProperty("jcr:configuration", s + "/" + configNodeName);
        return (RegistryNode)this.session.getItem(s + "/" + configNodeName);
    }

    public Node setActivity(Node node) throws UnsupportedRepositoryOperationException, RepositoryException {
        RegistryNode acNode = null;
        if (node == null) {
            this.currentActivityNodePath = "";
            if (((RegistryNode)this.session.getItem("/jcr:system/jcr:activities")).getNodes().hasNext()) {
                acNode = (RegistryNode)((RegistryNode)this.session.getItem("/jcr:system/jcr:activities")).getNodes().next();
            }
        } else {
            this.currentActivityNodePath = node.getPath();
            acNode = (RegistryNode)this.createActivity(node.getPath());
        }
        return acNode;
    }

    public Node getActivity() throws UnsupportedRepositoryOperationException, RepositoryException {
        return (Node)((RegistrySession)this.session).getItem(this.currentActivityNodePath);
    }

    public Node createActivity(String s) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.currentActivityNodePath = "/jcr:system/jcr:activities" + s;
        return ((RegistryNode)((RegistrySession)this.session).getItem("/jcr:system/jcr:activities")).addNode(s, "nt:activity");
    }

    public void removeActivity(Node node) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        ((RegistrySession)this.session).removeItem(node.getPath());
    }

    public NodeIterator merge(Node node) throws VersionException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return null;
    }
}

