/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;

public class RegistryNamespace
implements NamespaceRegistry {
    List<String> prefix = new ArrayList<String>();
    List<String> uris = new ArrayList<String>();
    Map uri_nameSpace = new HashMap();
    Map prefix_nameSpace = new HashMap();

    public void registerNamespace(String s, String s1) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        if (s == null || s.equals("jcr") || s.equals("nt") || s.contains("xml") || s.equals("mix") || s.equals("sv")) {
            throw new NamespaceException();
        }
        if (s != null) {
            this.prefix.add(s);
            this.uris.add(s1);
            this.uri_nameSpace.put(s1, s);
            this.prefix_nameSpace.put(s, s1);
        }
    }

    public void unregisterNamespace(String s) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        if (s == null || s.equals("jcr") || s.equals("nt") || s.equals("xml") || s.equals("mix") || s.equals("sv")) {
            throw new NamespaceException();
        }
        if (this.uri_nameSpace.containsKey(s)) {
            this.uri_nameSpace.remove(s);
            this.prefix_nameSpace.remove(s);
        } else if (!this.uri_nameSpace.containsKey(s)) {
            throw new NamespaceException("Cannot remove unregistered ");
        }
    }

    public String[] getPrefixes() throws RepositoryException {
        String temp = "";
        for (String s : this.prefix) {
            temp = ":" + s;
        }
        return temp.split(":");
    }

    public String[] getURIs() throws RepositoryException {
        String temp = "";
        for (String s : this.uris) {
            temp = ":" + s;
        }
        return temp.split(":");
    }

    public String getURI(String s) throws NamespaceException, RepositoryException {
        return this.prefix_nameSpace.get(s).toString();
    }

    public String getPrefix(String s) throws NamespaceException, RepositoryException {
        String pref = "";
        if (this.uri_nameSpace == null || this.uri_nameSpace.size() == 0) {
            throw new NamespaceException();
        }
        if (this.uri_nameSpace.get(s) != null) {
            pref = this.uri_nameSpace.get(s).toString();
        }
        return pref;
    }
}

