/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.jcr.RegistryNode;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.RegistrySimpleCredentials;
import org.wso2.carbon.registry.jcr.RegistryValue;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;

public class RegistryRepository
implements Repository {
    static Map keyMap = new HashMap();
    public static final Map credentialConstants = new LinkedHashMap();
    public RegistryService registryService;
    private Set workspaces = new HashSet();
    private Map<String, Workspace> workspaceMap = new HashMap<String, Workspace>();
    private static int versionCounter = 0;
    private static Log log = LogFactory.getLog(RegistryNode.class);
    private static String ADMIN_ROLE_NAME = "admin";
    private static String ANONYMOUS_USER = "anonymous";
    private static String SUPER_USER = "superuser";
    private static final String[] multivaluedKeys = new String[]{"identifier.stability", "node.type.management.inheritance", "query.joins", "level.1.supported", "level.2.supported", "query.languages"};
    private static final String[] discriptorKeys = new String[]{"identifier.stability", "identifier.stability.indefinite.duration", "identifier.stability.method.duration", "identifier.stability.save.duration", "identifier.stability.session.duration", "node.type.management.autocreated.definitions.supported", "node.type.management.inheritance", "node.type.management.inheritance.minimal", "node.type.management.inheritance.multiple", "node.type.management.inheritance.single", "node.type.management.multiple.binary.properties.supported", "node.type.management.multivalued.properties.supported", "node.type.management.orderable.child.nodes.supported", "node.type.management.overrides.supported", "node.type.management.primary.item.name.supported", "node.type.management.property.types", "node.type.management.residual.definitions.supported", "node.type.management.same.name.siblings.supported", "node.type.management.update.in.use.suported", "node.type.management.value.constraints.supported", "option.access.control.supported", "option.activities.supported", "option.baselines.supported", "option.journaled.observation.supported", "option.lifecycle.supported", "option.locking.supported", "option.node.and.property.with.same.name.supported", "option.node.type.management.supported", "option.observation.supported", "option.retention.supported", "option.shareable.nodes.supported", "option.simple.versioning.supported", "option.transactions.supported", "option.unfiled.content.supported", "option.update.mixin.node.types.supported", "option.update.primary.node.type.supported", "option.versioning.supported", "option.workspace.management.supported", "option.xml.export.supported", "option.xml.import.supported", "query.full.text.search.supported", "query.joins.inner", "query.joins.inner.outer", "query.joins.none", "query.languages", "query.stored.queries.supported", "jcr.repository.name", "jcr.repository.vendor", "jcr.repository.vendor.url", "jcr.repository.version", "jcr.specification.name", "jcr.specification.version", "write.supported", "level.2.supported", "level.1.supported", "option.query.sql.supported", "query.xpath.pos.index", "query.xpath.doc.order", "query.joins"};

    public static int getVersionCounter() {
        return versionCounter++;
    }

    public RegistryRepository(RegistryService registryService) throws RegistryException, ConstraintViolationException {
        this.registryService = registryService;
        credentialConstants.put(0, "SYSTEM:LOCAL_REPOSITORY");
        credentialConstants.put(1, "USER:CONFIG_USER_REGISTRY");
        credentialConstants.put(2, "SYSTEM:CONFIG_SYSTEM_REGISTRY");
        credentialConstants.put(3, "SYSTEM:GOVERNANCE_SYSTEM_REGISTRY");
        credentialConstants.put(4, "USER:GOVERNANCE_USER_REGISTRY");
        credentialConstants.put(5, "ALL:ROOT_REGISTRY");
        keyMap.put("identifier.stability", "true");
        keyMap.put("identifier.stability.indefinite.duration", "true");
        keyMap.put("identifier.stability.method.duration", "true");
        keyMap.put("identifier.stability.save.duration", "true");
        keyMap.put("identifier.stability.session.duration", "true");
        keyMap.put("node.type.management.autocreated.definitions.supported", "true");
        keyMap.put("node.type.management.inheritance", "true");
        keyMap.put("node.type.management.inheritance.minimal", "true");
        keyMap.put("node.type.management.inheritance.multiple", "true");
        keyMap.put("node.type.management.inheritance.single", "true");
        keyMap.put("node.type.management.multiple.binary.properties.supported", "true");
        keyMap.put("node.type.management.multivalued.properties.supported", "true");
        keyMap.put("node.type.management.orderable.child.nodes.supported", "true");
        keyMap.put("node.type.management.overrides.supported", "true");
        keyMap.put("node.type.management.primary.item.name.supported", "true");
        keyMap.put("node.type.management.property.types", "true");
        keyMap.put("node.type.management.residual.definitions.supported", "true");
        keyMap.put("node.type.management.same.name.siblings.supported", "true");
        keyMap.put("node.type.management.update.in.use.suported", "true");
        keyMap.put("node.type.management.value.constraints.supported", "true");
        keyMap.put("option.access.control.supported", "true");
        keyMap.put("option.activities.supported", "true");
        keyMap.put("option.baselines.supported", "true");
        keyMap.put("option.journaled.observation.supported", "true");
        keyMap.put("option.lifecycle.supported", "true");
        keyMap.put("option.locking.supported", "true");
        keyMap.put("option.node.and.property.with.same.name.supported", "true");
        keyMap.put("option.node.type.management.supported", "true");
        keyMap.put("option.observation.supported", "true");
        keyMap.put("option.retention.supported", "true");
        keyMap.put("option.shareable.nodes.supported", "true");
        keyMap.put("option.simple.versioning.supported", "true");
        keyMap.put("option.transactions.supported", "true");
        keyMap.put("option.unfiled.content.supported", "true");
        keyMap.put("option.update.mixin.node.types.supported", "true");
        keyMap.put("option.update.primary.node.type.supported", "true");
        keyMap.put("option.versioning.supported", "false");
        keyMap.put("option.workspace.management.supported", "true");
        keyMap.put("option.xml.export.supported", "true");
        keyMap.put("option.xml.import.supported", "true");
        keyMap.put("query.full.text.search.supported", "true");
        keyMap.put("query.joins.inner", "true");
        keyMap.put("query.joins.inner.outer", "true");
        keyMap.put("query.joins.none", "true");
        keyMap.put("query.languages", "true");
        keyMap.put("query.stored.queries.supported", "true");
        keyMap.put("jcr.repository.name", "");
        keyMap.put("jcr.repository.vendor", "");
        keyMap.put("jcr.repository.vendor.url", "");
        keyMap.put("jcr.repository.version", "");
        keyMap.put("jcr.specification.name", "");
        keyMap.put("jcr.specification.version", "");
        keyMap.put("write.supported", "");
        keyMap.put("level.2.supported", "true");
        keyMap.put("level.1.supported", "true");
        keyMap.put("option.query.sql.supported", "true");
        keyMap.put("query.xpath.pos.index", "true");
        keyMap.put("query.xpath.doc.order", "true");
        keyMap.put("query.joins", "true");
        RegistryJCRSpecificStandardLoderUtil.init();
    }

    public Set getWorkspaces() {
        return this.workspaces;
    }

    public Map<String, Workspace> getWorkspaceMap() {
        return this.workspaceMap;
    }

    public String[] getDescriptorKeys() {
        return Arrays.copyOf(discriptorKeys, discriptorKeys.length);
    }

    public boolean isStandardDescriptor(String s) {
        return keyMap.containsKey(s);
    }

    public boolean isSingleValueDescriptor(String s) {
        boolean isSingle = true;
        for (String a : multivaluedKeys) {
            if (!a.equals(s)) continue;
            isSingle = false;
            break;
        }
        return isSingle;
    }

    public Value getDescriptorValue(String s) {
        return new RegistryValue(keyMap.get(s).toString(), 6);
    }

    public Value[] getDescriptorValues(String s) {
        String[] multiValKeys = keyMap.get(s).toString().split("-");
        Value[] values = new RegistryValue[multiValKeys.length];
        for (int i = 0; i < multiValKeys.length; ++i) {
            values[i] = new RegistryValue(multiValKeys[i], 6);
        }
        return values;
    }

    public String getDescriptor(String s) {
        String temp = null;
        if (keyMap.get(s) != null) {
            temp = keyMap.get(s).toString();
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session login(Credentials credentials, String s) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Credentials tmpCredentials = credentials;
        if (credentials instanceof SimpleCredentials) {
            credentials = new RegistrySimpleCredentials();
            ((RegistrySimpleCredentials)credentials).setRegistrySimpleCredentials((SimpleCredentials)tmpCredentials);
        }
        UserRegistry userRegistry = null;
        String userID = "";
        if (credentials == null && s == null) {
            s = RegistryJCRSpecificStandardLoderUtil.getDefaultRegistryWorkspaceName();
            try {
                userRegistry = this.registryService.getRegistry();
            }
            catch (RegistryException e) {
                throw new RepositoryException("Exception occurred when obtaining registry from registry service :" + e.getMessage());
            }
        }
        if (s == null) {
            s = RegistryJCRSpecificStandardLoderUtil.getDefaultRegistryWorkspaceName();
            userID = ((RegistrySimpleCredentials)credentials).getUserID();
            try {
                if (((RegistrySimpleCredentials)credentials).getUserID().equals(SUPER_USER)) {
                    userRegistry = this.registryService.getRegistry(ADMIN_ROLE_NAME, new String(((RegistrySimpleCredentials)credentials).getPassword()));
                }
                if (((RegistrySimpleCredentials)credentials).getUserID().equals(ANONYMOUS_USER)) {
                    userRegistry = this.registryService.getRegistry();
                }
                userRegistry = this.getRegistry(((RegistrySimpleCredentials)credentials).getUserID(), new String(((RegistrySimpleCredentials)credentials).getPassword()));
            }
            catch (RegistryException e) {
                throw new RepositoryException("Exception occurred when obtaining registry from registry service :" + e.getMessage());
            }
        } else {
            if (credentials == null) {
                try {
                    userRegistry = this.registryService.getRegistry();
                }
                catch (RegistryException e) {
                    throw new RepositoryException("Exception occurred when obtaining registry from registry service :" + e.getMessage());
                }
            }
            userID = ((RegistrySimpleCredentials)credentials).getUserID();
            try {
                userRegistry = ((RegistrySimpleCredentials)credentials).getUserID().equals(SUPER_USER) ? this.registryService.getRegistry(ADMIN_ROLE_NAME, new String(((RegistrySimpleCredentials)credentials).getPassword())) : this.getRegistry(((RegistrySimpleCredentials)credentials).getUserID(), new String(((RegistrySimpleCredentials)credentials).getPassword()));
            }
            catch (RegistryException e) {
                throw new RepositoryException("Exception occurred when obtaining registry from registry service :" + e.getMessage());
            }
        }
        RegistrySession registrySession = null;
        RegistryRepository registryRepository = this;
        synchronized (registryRepository) {
            registrySession = new RegistrySession(this, s, (RegistrySimpleCredentials)credentials, userRegistry, userID);
            this.workspaces.add(registrySession);
        }
        return registrySession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session loginOriginal(Credentials credentials, String s) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Credentials tmpCredentials = credentials;
        if (credentials instanceof SimpleCredentials) {
            credentials = new RegistrySimpleCredentials();
            ((RegistrySimpleCredentials)credentials).setRegistrySimpleCredentials((SimpleCredentials)tmpCredentials);
        }
        UserRegistry userRegistry = null;
        String userID = "";
        if (credentials == null && s == null) {
            s = RegistryJCRSpecificStandardLoderUtil.getDefaultRegistryWorkspaceName();
            try {
                userRegistry = this.registryService.getRegistry();
            }
            catch (RegistryException e) {
                throw new RepositoryException("Exception occurred when obtaining registry from registry service :" + e.getMessage());
            }
        }
        if (s == null) {
            s = RegistryJCRSpecificStandardLoderUtil.getDefaultRegistryWorkspaceName();
            userID = ((RegistrySimpleCredentials)credentials).getUserID();
            try {
                userRegistry = this.getRegistry(((RegistrySimpleCredentials)credentials).getUserID(), new String(((RegistrySimpleCredentials)credentials).getPassword()));
            }
            catch (RegistryException e) {
                throw new RepositoryException("Exception occurred when obtaining registry from registry service :" + e.getMessage());
            }
        }
        if (credentials == null) {
            try {
                userRegistry = this.registryService.getRegistry();
            }
            catch (RegistryException e) {
                throw new RepositoryException("Exception occurred when obtaining registry from registry service :" + e.getMessage());
            }
        }
        userID = ((RegistrySimpleCredentials)credentials).getUserID();
        try {
            userRegistry = this.getRegistry(((RegistrySimpleCredentials)credentials).getUserID(), new String(((RegistrySimpleCredentials)credentials).getPassword()));
        }
        catch (RegistryException e) {
            throw new RepositoryException("Exception occurred when obtaining registry from registry service :" + e.getMessage());
        }
        RegistrySession registrySession = null;
        RegistryRepository registryRepository = this;
        synchronized (registryRepository) {
            registrySession = new RegistrySession(this, s, (RegistrySimpleCredentials)credentials, userRegistry, userID);
            this.workspaces.add(registrySession);
        }
        return registrySession;
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(String s) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, s);
    }

    public Session login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    private UserRegistry getRegistry(String username, String password) throws RegistryException {
        if (username == null) {
            return this.registryService.getRegistry();
        }
        String[] nameComponents = username.split("@");
        if (nameComponents.length > 1) {
            return this.registryService.getUserRegistry(username, password);
        }
        return this.registryService.getRegistry(username, password);
    }
}

