/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr;

import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.app.RemoteRegistryService;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistryService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.jcr.RegistryRepository;
import org.wso2.carbon.user.core.common.DefaultRealmService;
import org.wso2.carbon.user.core.service.RealmService;

public class RegistryRepositoryFactory
implements RepositoryFactory {
    private Repository regRepo;
    private RealmService realmService = null;

    public Repository getRepository(Map map) throws RepositoryException {
        Repository repository = null;
        try {
            repository = this.getRemoteRepository(map);
        }
        catch (Exception e) {
            throw new RepositoryException("Unable to create realm service " + e.getMessage());
        }
        return repository;
    }

    private Repository getRemoteRepository(Map map) throws Exception {
        try {
            RemoteRegistryService remoteRegistryService = new RemoteRegistryService((String)map.get("registryURL"), (String)map.get("userName"), (String)map.get("password"));
            if (this.regRepo == null) {
                this.regRepo = new RegistryRepository((RegistryService)remoteRegistryService);
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to create realm service " + e.getMessage());
        }
        return this.regRepo;
    }

    public Repository getLocalRepository(Map map) throws Exception {
        if (map != null && map.get("org.wso2.registry.jcr") != null && map.get("org.wso2.registry.jcr").equals("greg")) {
            Object embeddedRegistryService = null;
            try {
                this.realmService = new DefaultRealmService(null);
            }
            catch (Exception e) {
                throw new Exception("Unable to create realm service " + e.getMessage());
            }
            RegistryCoreServiceComponent registryComponent = new RegistryCoreServiceComponent(){

                public void setRealmService(RealmService realm) {
                    super.setRealmService(RegistryRepositoryFactory.this.realmService);
                }
            };
            RegistryService registryService = null;
            try {
                registryService = registryComponent.buildRegistryService();
                if (this.regRepo == null) {
                    this.regRepo = new RegistryRepository((RegistryService)((EmbeddedRegistryService)registryService));
                }
            }
            catch (RegistryException e) {
                throw new Exception("Unable to build registry service" + e.getMessage());
            }
            return this.regRepo;
        }
        return null;
    }
}

