/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.jcr.RegistryNamespace;
import org.wso2.carbon.registry.jcr.RegistryRepository;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.lock.RegistryLockManager;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeTypeManager;
import org.wso2.carbon.registry.jcr.observation.RegistryObservationManager;
import org.wso2.carbon.registry.jcr.query.RegistryQueryManager;
import org.wso2.carbon.registry.jcr.util.RegistryJCRItemOperationUtil;
import org.wso2.carbon.registry.jcr.version.RegistryVersionManager;
import org.xml.sax.ContentHandler;

public class RegistryWorkspace
implements Workspace {
    private Registry userRegistry;
    private RegistrySession registrySession;
    private String userId = null;
    private static HashMap sessions = new HashMap();
    private RegistryNodeTypeManager regNodeTypeMan = null;
    private ObservationManager observationMngr;
    private VersionManager versionMngr;
    private LockManager lockManager;
    private NamespaceRegistry registryNamespace;

    public RegistryWorkspace(RegistrySession registrySession) throws RepositoryException {
        this.registrySession = registrySession;
        this.userRegistry = this.registrySession.userRegistry;
        this.regNodeTypeMan = new RegistryNodeTypeManager(registrySession);
        this.observationMngr = new RegistryObservationManager();
        this.versionMngr = new RegistryVersionManager(this.registrySession);
        this.lockManager = new RegistryLockManager(this.registrySession);
        this.registryNamespace = new RegistryNamespace();
    }

    public RegistryWorkspace(String userID, RegistrySession registrySession) throws RepositoryException {
        this.registrySession = registrySession;
        this.userRegistry = this.registrySession.userRegistry;
        sessions.put(userID, registrySession);
        this.userId = userID;
        this.regNodeTypeMan = new RegistryNodeTypeManager(registrySession);
        this.observationMngr = new RegistryObservationManager();
        this.versionMngr = new RegistryVersionManager(this.registrySession);
        this.lockManager = new RegistryLockManager(this.registrySession);
        this.registryNamespace = new RegistryNamespace();
    }

    public RegistryWorkspace(String name) {
    }

    public Session getSession() {
        RegistrySession mySes = null;
        if (sessions != null) {
            mySes = (RegistrySession)sessions.get(this.userId);
        }
        return mySes;
    }

    public String getName() {
        String name = null;
        if (this.getSession() != null) {
            name = ((RegistrySession)this.getSession()).getWorkspaceName();
        }
        return name;
    }

    public void copy(String s, String s1) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        RegistryJCRItemOperationUtil.validateReadOnlyItemOpr(this.registrySession);
        try {
            if (this.userRegistry != null) {
                this.userRegistry.copy(s, s1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copy(String s, String s1, String s2) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        RegistryJCRItemOperationUtil.validateReadOnlyItemOpr(this.registrySession);
    }

    public void clone(String s, String s1, String s2, boolean b) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
    }

    public void move(String s, String s1) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        RegistryJCRItemOperationUtil.validateReadOnlyItemOpr(this.registrySession);
        try {
            if (this.userRegistry.resourceExists(s)) {
                this.userRegistry.move(s, s1);
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("RegistryException occurred at Registry level");
        }
    }

    public void restore(Version[] versions, boolean b) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
    }

    public LockManager getLockManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.lockManager;
    }

    public QueryManager getQueryManager() throws RepositoryException {
        return new RegistryQueryManager(this.registrySession);
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        return this.registryNamespace;
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        return this.regNodeTypeMan;
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.observationMngr;
    }

    public VersionManager getVersionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.versionMngr;
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        String temp = "";
        for (int i = 0; i < RegistryRepository.credentialConstants.size(); ++i) {
            String[] constant = RegistryRepository.credentialConstants.get(i).toString().split(":");
            if (constant[0].equals(this.registrySession.getWorkspaceName())) {
                temp = temp + constant[1] + ":";
            }
            if (temp.length() <= 1) continue;
            temp = temp.substring(0, temp.toCharArray().length - 1);
        }
        return temp.split(":");
    }

    public ContentHandler getImportContentHandler(String s, int i) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, AccessDeniedException, RepositoryException {
        return null;
    }

    public void importXML(String s, InputStream inputStream, int i) throws IOException, VersionException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, AccessDeniedException, RepositoryException {
    }

    public void createWorkspace(String s) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        if (RegistryJCRItemOperationUtil.isWorkspaceExists(this.registrySession, s)) {
            throw new RepositoryException("New workspace with the name already exists: " + s);
        }
        RegistryWorkspace workspace = new RegistryWorkspace(s);
        this.registrySession.getRepository().getWorkspaceMap().put(s, workspace);
    }

    public void createWorkspace(String s, String s1) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        try {
            this.registrySession.getRepository().getWorkspaceMap().put(s, (Workspace)((RegistryWorkspace)this.registrySession.getRepository().getWorkspaceMap().get(s1)).clone());
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedRepositoryOperationException("Workspace clone not supported " + e.getMessage());
        }
    }

    public void deleteWorkspace(String s) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        if (!RegistryJCRItemOperationUtil.isWorkspaceExists(this.registrySession, s)) {
            throw new NoSuchWorkspaceException("Cannot remove non existing workspace: " + s);
        }
        this.registrySession.getRepository().getWorkspaceMap().remove(s);
    }
}

