/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.lock;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.wso2.carbon.registry.jcr.RegistryNode;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.lock.RegistryLock;

public class RegistryLockManager
implements LockManager {
    private Map<String, Lock> allLocks = new HashMap<String, Lock>();
    private Set<String> lockTokens = new HashSet<String>();
    private Session session;

    public RegistryLockManager(Session session) {
        this.session = session;
    }

    public void addLockToken(String s) throws LockException, RepositoryException {
        this.lockTokens.add(s);
    }

    public Lock getLock(String s) throws PathNotFoundException, LockException, AccessDeniedException, RepositoryException {
        return this.allLocks.get(s);
    }

    public String[] getLockTokens() throws RepositoryException {
        if (this.lockTokens.size() != 0) {
            int i = 0;
            String[] arr = new String[this.lockTokens.size()];
            for (String temp : this.lockTokens) {
                if (temp == null) continue;
                arr[i] = temp.toString();
                ++i;
            }
            return arr;
        }
        return new String[0];
    }

    public boolean holdsLock(String s) throws PathNotFoundException, RepositoryException {
        return this.getAllLocks().containsKey(s);
    }

    public Lock lock(String s, boolean b, boolean b1, long l, String s1) throws LockException, PathNotFoundException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        RegistryLock lock = null;
        try {
            if (!((Node)((RegistrySession)this.session).getItem(s)).isNodeType("mix:lockable")) {
                throw new LockException();
            }
            lock = new RegistryLock(this.session, s, b, b1, l, s1);
            this.allLocks.put(s, lock);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lock;
    }

    public boolean isLocked(String s) throws PathNotFoundException, RepositoryException {
        boolean islocked = false;
        String parentPath = ((RegistryNode)this.session.getItem(s)).getParent().getPath();
        if (this.allLocks.get(s) != null || this.getLock(parentPath) != null && this.getLock(parentPath).isDeep()) {
            islocked = true;
        }
        return islocked;
    }

    public void removeLockToken(String s) throws LockException, RepositoryException {
        this.lockTokens.remove(s);
    }

    public void unlock(String s) throws PathNotFoundException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.allLocks.remove(s);
    }

    private Map<String, Lock> getAllLocks() {
        return this.allLocks;
    }
}

