/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.nodetype;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.jcr.nodetype.RegistryPropertyDefinitionTemplate;
import org.wso2.carbon.registry.jcr.util.RegistryJCRItemOperationUtil;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;

public class RegistryNodeDefinitionTemplate
implements NodeDefinitionTemplate {
    private String name = null;
    private String[] reqPrimTypeNames = null;
    private String deftPrimTypeName = null;
    private boolean isAutoCreated = false;
    private boolean isMandatory = false;
    private boolean isProtected = false;
    private boolean allowSameNameSib = false;
    private NodeTypeManager nodeTypeManager;
    private int onParVersion = 1;
    private String declaringNT;
    private static Log log = LogFactory.getLog(RegistryPropertyDefinitionTemplate.class);

    public RegistryNodeDefinitionTemplate(NodeTypeManager nodeTypeManager) {
        this.nodeTypeManager = nodeTypeManager;
    }

    public void setName(String s) throws ConstraintViolationException {
        if (s == null || !RegistryJCRSpecificStandardLoderUtil.isValidJCRName(s)) {
            throw new ConstraintViolationException("Not a valid JCR node type name");
        }
        if (s != null && s.contains("{")) {
            s = RegistryJCRItemOperationUtil.replaceNameSpacePrefixURIS(s);
        }
        this.name = s;
    }

    public void setAutoCreated(boolean b) {
        this.isAutoCreated = b;
    }

    public void setMandatory(boolean b) {
        this.isMandatory = b;
    }

    public void setOnParentVersion(int i) {
        this.onParVersion = i;
    }

    public void setProtected(boolean b) {
        this.isProtected = b;
    }

    public void setRequiredPrimaryTypeNames(String[] strings) throws ConstraintViolationException {
        if (strings == null) {
            throw new ConstraintViolationException("Null is not a valid JCR name");
        }
        for (int i = 0; i < strings.length; ++i) {
            if (!RegistryJCRSpecificStandardLoderUtil.isValidJCRName(strings[i])) {
                throw new ConstraintViolationException("Invalid JCR super type type name");
            }
            if (!strings[i].contains("{")) continue;
            strings[i] = RegistryJCRItemOperationUtil.replaceNameSpacePrefixURIS(strings[i]);
        }
        this.reqPrimTypeNames = Arrays.copyOf(strings, strings.length);
    }

    public void setDefaultPrimaryTypeName(String s) throws ConstraintViolationException {
        if (!RegistryJCRSpecificStandardLoderUtil.isValidJCRName(s)) {
            throw new ConstraintViolationException("Invalid node type " + s);
        }
        if (s != null && s.contains("{")) {
            s = RegistryJCRItemOperationUtil.replaceNameSpacePrefixURIS(s);
        }
        this.deftPrimTypeName = s;
    }

    public void setSameNameSiblings(boolean b) {
        this.allowSameNameSib = b;
    }

    public NodeType[] getRequiredPrimaryTypes() {
        if (this.reqPrimTypeNames == null) {
            return null;
        }
        ArrayList<NodeType> nodeTypeList = new ArrayList<NodeType>();
        for (String s : this.getRequiredPrimaryTypeNames()) {
            if (s == null) continue;
            try {
                nodeTypeList.add(this.nodeTypeManager.getNodeType(s));
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return nodeTypeList.toArray(new NodeType[0]);
    }

    public String[] getRequiredPrimaryTypeNames() {
        if (this.reqPrimTypeNames != null) {
            return Arrays.copyOf(this.reqPrimTypeNames, this.reqPrimTypeNames.length);
        }
        return null;
    }

    public NodeType getDefaultPrimaryType() {
        try {
            if (this.deftPrimTypeName != null) {
                return this.nodeTypeManager.getNodeType(this.deftPrimTypeName);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    public String getDefaultPrimaryTypeName() {
        return this.deftPrimTypeName;
    }

    public boolean allowsSameNameSiblings() {
        return this.allowSameNameSib;
    }

    public NodeType getDeclaringNodeType() {
        NodeType nodeType = null;
        try {
            nodeType = this.nodeTypeManager.getNodeType(this.declaringNT);
        }
        catch (RepositoryException e) {
            log.error((Object)("Error occurred while getting declared node type : " + this.declaringNT));
        }
        return nodeType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAutoCreated() {
        return this.isAutoCreated;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public int getOnParentVersion() {
        return this.onParVersion;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setDeclaringNodeTypeName(String nt) {
        this.declaringNT = nt;
    }
}

