/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.nodetype;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeTypeIterator;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeTypeTemplate;
import org.wso2.carbon.registry.jcr.util.RegistryNodeTypeUtil;

public class RegistryNodeType
implements NodeType {
    private NodeTypeTemplate ntd;
    private NodeTypeManager nodeTypeManager;
    private static Log log = LogFactory.getLog(RegistryNodeType.class);
    public static final String UNDEFINED_NODE_NAME = "*";

    public RegistryNodeType(NodeTypeDefinition ntd, NodeTypeManager nodeTypeManager) {
        this.ntd = (RegistryNodeTypeTemplate)ntd;
        this.nodeTypeManager = nodeTypeManager;
    }

    public NodeType[] getSupertypes() {
        HashSet<NodeType> nodeTypeList = new HashSet<NodeType>();
        try {
            for (String ntName : this.ntd.getDeclaredSupertypeNames()) {
                nodeTypeList.add(this.nodeTypeManager.getNodeType(ntName));
            }
            if (nodeTypeList.size() == 0 && !this.ntd.isMixin() && !this.ntd.getName().equals("nt:base")) {
                nodeTypeList.add(this.nodeTypeManager.getNodeType("nt:base"));
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("Registry Error while getting super types " + e.getMessage()));
        }
        return nodeTypeList.toArray(new NodeType[0]);
    }

    public NodeType[] getDeclaredSupertypes() {
        return this.getSupertypes();
    }

    public NodeTypeIterator getSubtypes() {
        HashSet<NodeType> nodeTypeList = new HashSet<NodeType>();
        List nttList = this.ntd.getNodeDefinitionTemplates();
        if (nttList.size() != 0) {
            for (Object ntt : nttList) {
                String ntName = ((NodeDefinition)ntt).getName();
                try {
                    nodeTypeList.add(this.nodeTypeManager.getNodeType(ntName));
                }
                catch (RepositoryException e) {
                    log.error((Object)("Registry Error while getting super types " + e.getMessage()));
                }
            }
        }
        return new RegistryNodeTypeIterator(nodeTypeList);
    }

    public NodeTypeIterator getDeclaredSubtypes() {
        return this.getSubtypes();
    }

    public boolean isNodeType(String s) {
        if ("nt:base".equals(s)) {
            return true;
        }
        boolean isNodetype = this.ntd.getName().equals(s);
        if (!isNodetype) {
            for (String ntsuper : this.ntd.getDeclaredSupertypeNames()) {
                if (!s.equals(ntsuper)) continue;
                isNodetype = true;
                break;
            }
        }
        return isNodetype;
    }

    private void addPrimaryTypePropIfNotExists(PropertyDefinition[] pdfs) throws RepositoryException {
        boolean hasPrimaryTypeProp = false;
        for (PropertyDefinition pd : pdfs) {
            if (!pd.getName().equals("jcr:primaryType")) continue;
            hasPrimaryTypeProp = true;
        }
        if (!hasPrimaryTypeProp) {
            this.ntd.getPropertyDefinitionTemplates().add(RegistryNodeTypeUtil.createJCRPrimaryTypeProperty(this.nodeTypeManager, this.ntd.getName()));
        }
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        Object pdList = null;
        if (this.ntd != null) {
            try {
                PropertyDefinition[] pdfs = this.ntd.getDeclaredPropertyDefinitions();
                this.addPrimaryTypePropIfNotExists(pdfs);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            return this.ntd.getDeclaredPropertyDefinitions();
        }
        return new PropertyDefinition[0];
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        if (this.ntd != null) {
            return this.ntd.getDeclaredChildNodeDefinitions();
        }
        return new NodeDefinition[0];
    }

    public boolean canSetProperty(String s, Value value) {
        if (value == null) {
            return this.canRemoveItem(s);
        }
        PropertyDefinition property = this.getMatchingPropDef(this.ntd.getDeclaredPropertyDefinitions(), value.getType(), s, false);
        int TYPE = property.getRequiredType();
        if (property.isProtected()) {
            return false;
        }
        switch (TYPE) {
            case 2: {
                if (!this.validateBinaryPropertyCanSet(value, property)) break;
                return true;
            }
            case 5: {
                if (!this.validateDatePropertyCanSet(value, property)) break;
                return true;
            }
            case 8: {
                if (!this.validatePathPropertyCanSet(value, property)) break;
                return true;
            }
            case 1: {
                return true;
            }
            case 6: {
                return true;
            }
            case 4: {
                return true;
            }
            case 3: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    private PropertyDefinition getMatchingPropDef(PropertyDefinition[] pdfs, int type, String name, boolean isMultiValued) {
        for (PropertyDefinition pd : pdfs) {
            int reqType = pd.getRequiredType();
            if (!name.equals(pd.getName()) || isMultiValued != pd.isMultiple()) continue;
            return pd;
        }
        return null;
    }

    private boolean validateBinaryPropertyCanSet(Value value, PropertyDefinition pd) {
        return value.getType() == 1 || value.getType() == 2 || value.getType() == 4 || value.getType() == 5 || value.getType() == 3 || value.getType() == 6 || value.getType() == 7 || value.getType() == 8;
    }

    private boolean isPathInFormat(Value value) {
        try {
            String path = value.getString();
            if (!"".equals(path) && (path.contains(":") || path.contains(",") || path.contains("%") || path.contains("^") || path.contains(UNDEFINED_NODE_NAME) || path.contains("(") || path.contains(")"))) {
                return false;
            }
        }
        catch (RepositoryException e) {
            return true;
        }
        return true;
    }

    private boolean isDateInFormat(Value value) {
        try {
            if (value.getString().contains("time=")) {
                return true;
            }
        }
        catch (RepositoryException e) {
            return false;
        }
        return false;
    }

    public boolean isValidDate(String inDate) {
        if (inDate == null) {
            return false;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (inDate.trim().length() != dateFormat.toPattern().length()) {
            return false;
        }
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(inDate.trim());
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    private boolean validatePathPropertyCanSet(Value value, PropertyDefinition pd) {
        if (value.getType() == 7 || value.getType() == 8) {
            return true;
        }
        if (value.getType() == 4 || value.getType() == 6 || value.getType() == 3) {
            return false;
        }
        return value.getType() != 8 && this.isPathInFormat(value);
    }

    private boolean validateDatePropertyCanSet(Value value, PropertyDefinition pd) {
        if (value.getType() == 4 || value.getType() == 5 || value.getType() == 3) {
            return true;
        }
        return value.getType() != 5 && this.isDateInFormat(value);
    }

    private boolean validateBooleanPropertyCanSet(Value value) {
        for (Object o : this.ntd.getPropertyDefinitionTemplates()) {
            PropertyDefinitionTemplate pd = (PropertyDefinitionTemplate)o;
            if (pd.getRequiredType() != 2 || value.getType() != 1 && value.getType() != 4 && value.getType() != 5 && value.getType() != 3 && value.getType() != 6 && value.getType() != 7 && value.getType() != 8) continue;
            return true;
        }
        return false;
    }

    private boolean isPropertyProtected(String propName) {
        for (Object o : this.ntd.getPropertyDefinitionTemplates()) {
            PropertyDefinitionTemplate pd = (PropertyDefinitionTemplate)o;
            if (pd == null || !pd.getName().equals(propName) || !pd.isProtected()) continue;
            return true;
        }
        return false;
    }

    private boolean validatePropertyIsMultiple(String propName) {
        for (Object o : this.ntd.getPropertyDefinitionTemplates()) {
            PropertyDefinitionTemplate pd = (PropertyDefinitionTemplate)o;
            if (pd == null || !pd.getName().equals(propName) || pd.isMultiple()) continue;
            return false;
        }
        return true;
    }

    public boolean canSetProperty(String s, Value[] values) {
        if (!this.validatePropertyIsMultiple(s)) {
            return false;
        }
        if (this.isPropertyProtected(s)) {
            return false;
        }
        for (Value value : values) {
            if (this.canSetProperty(s, value)) continue;
            return false;
        }
        return true;
    }

    public boolean canAddChildNode(String s) {
        for (NodeDefinition nd : this.getChildNodeDefinitions()) {
            if (!s.equals(nd.getName()) || nd.getDefaultPrimaryTypeName() == null) continue;
            return true;
        }
        if (!this.isChildNameInDefList(s)) {
            for (NodeDefinition nd : this.getChildNodeDefinitions()) {
                if (nd.getDefaultPrimaryTypeName() == null) continue;
                return true;
            }
        }
        if (!this.isChildNameInDefList(s)) {
            return false;
        }
        return false;
    }

    public boolean canAddChildNode(String s, String s1) {
        if (s1.startsWith("mix")) {
            return false;
        }
        if (this.checkOnlyNodeNameUndefinedRule(s1)) {
            return true;
        }
        if (!this.isChildNameInDefList(s)) {
            return false;
        }
        for (NodeDefinition nd : this.getChildNodeDefinitions()) {
            if (!nd.getName().equals(s) || !this.isReqTypesContainsNodeType(nd, s1)) continue;
            return true;
        }
        return false;
    }

    private boolean checkOnlyNodeNameUndefinedRule(String s1) {
        for (NodeDefinition nd : this.getChildNodeDefinitions()) {
            if (!this.isReqTypesContainsNodeType(nd, s1)) continue;
            return true;
        }
        return false;
    }

    private boolean isReqTypesContainsNodeType(NodeDefinition nd, String s1) {
        for (String name : nd.getRequiredPrimaryTypeNames()) {
            if ("nt:base".equals(s1) || !"nt:unstructured".equals(s1) && !name.equals(s1)) continue;
            return true;
        }
        return false;
    }

    private boolean checkNTBaseCannotAdded(String ntUnstr, String name) {
        return ntUnstr.equals("nt:unstructured") && "nt:base".equals(name);
    }

    private boolean isChildNameInDefList(String name) {
        for (NodeDefinition nd : this.getChildNodeDefinitions()) {
            if (!name.equals(nd.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean canRemoveItem(String s) {
        boolean canRemove = true;
        for (Object pdt : this.ntd.getPropertyDefinitionTemplates()) {
            if (!((PropertyDefinition)pdt).getName().equals(s) || !((PropertyDefinition)pdt).isMandatory() && !((PropertyDefinition)pdt).isProtected()) continue;
            canRemove = false;
            return canRemove;
        }
        for (NodeDefinition nd : this.ntd.getDeclaredChildNodeDefinitions()) {
            if (!nd.getName().equals(s) || !nd.isMandatory() && !nd.isProtected()) continue;
            canRemove = false;
            return canRemove;
        }
        return canRemove;
    }

    public boolean canRemoveNode(String s) {
        boolean canRemoveNd = true;
        Iterator it = this.ntd.getNodeDefinitionTemplates().iterator();
        NodeDefinitionTemplate nd = null;
        while (it.hasNext()) {
            nd = (NodeDefinitionTemplate)it.next();
            if (nd == null || !nd.getName().equals(s) || !nd.isProtected() && !nd.isMandatory()) continue;
            canRemoveNd = false;
            return canRemoveNd;
        }
        return canRemoveNd;
    }

    public boolean canRemoveProperty(String s) {
        boolean canRemovePrp = true;
        Iterator it = this.ntd.getPropertyDefinitionTemplates().iterator();
        PropertyDefinitionTemplate pd = null;
        while (it.hasNext()) {
            pd = (PropertyDefinitionTemplate)it.next();
            if (pd == null || !pd.getName().equals(s) || !pd.isProtected() && !pd.isMandatory()) continue;
            canRemovePrp = false;
            return canRemovePrp;
        }
        return canRemovePrp;
    }

    public String getName() {
        return this.ntd.getName();
    }

    public String[] getDeclaredSupertypeNames() {
        return this.ntd.getDeclaredSupertypeNames();
    }

    public boolean isAbstract() {
        return this.ntd.isAbstract();
    }

    public boolean isMixin() {
        return this.ntd.isMixin();
    }

    public boolean hasOrderableChildNodes() {
        return this.ntd.hasOrderableChildNodes();
    }

    public boolean isQueryable() {
        return this.ntd.isQueryable();
    }

    public String getPrimaryItemName() {
        return this.ntd.getPrimaryItemName();
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        return this.ntd.getDeclaredPropertyDefinitions();
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        return this.ntd.getDeclaredChildNodeDefinitions();
    }

    public NodeTypeTemplate getDefinition() {
        return this.ntd;
    }
}

