/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.nodetype;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeDefinitionTemplate;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeType;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeTypeIterator;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeTypeTemplate;
import org.wso2.carbon.registry.jcr.nodetype.RegistryPropertyDefinitionTemplate;
import org.wso2.carbon.registry.jcr.util.RegistryNodeTypeUtil;

public class RegistryNodeTypeManager
implements NodeTypeManager {
    private RegistrySession registrySession = null;
    private Set<NodeType> nodeTypesList = new HashSet<NodeType>();
    private Set<NodeType> primaryNodetypes = new HashSet<NodeType>();
    private Set<NodeType> mixinNodetypes = new HashSet<NodeType>();
    private static Log log = LogFactory.getLog(RegistryNodeTypeManager.class);
    private static final String pathToNodeTypes = "";

    public RegistryNodeTypeManager(RegistrySession registrySession) throws RepositoryException {
        this.registrySession = registrySession;
        RegistryNodeTypeUtil.locadJCRBuiltInNodeTypesToSystemFromXML(this);
        RegistryNodeTypeUtil.loadNodeTypesFromRegistry(this, registrySession);
    }

    public Set<NodeType> getNodeTypesList() {
        return this.nodeTypesList;
    }

    public NodeType getNodeType(String s) throws NoSuchNodeTypeException, RepositoryException {
        NodeType matchNt = null;
        NodeType nt = null;
        boolean matchNTFound = false;
        if (s != null && s.equals(pathToNodeTypes)) {
            return this.getNodeType("default");
        }
        NodeTypeIterator it = this.getAllNodeTypes();
        while (it.hasNext()) {
            nt = (NodeType)it.next();
            if (nt == null || nt.getName() == null || !nt.getName().equals(s)) continue;
            matchNt = nt;
            matchNTFound = true;
            break;
        }
        if (!matchNTFound) {
            throw new NoSuchNodeTypeException("Invalid suffix for a Node Type :" + s);
        }
        return matchNt;
    }

    public boolean hasNodeType(String s) {
        boolean hasNtype = true;
        try {
            this.getNodeType(s);
        }
        catch (NoSuchNodeTypeException e) {
            hasNtype = false;
        }
        catch (RepositoryException e) {
            log.error((Object)("Error while registering node type " + e.getMessage()));
        }
        return hasNtype;
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        return new RegistryNodeTypeIterator(this.nodeTypesList);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        return new RegistryNodeTypeIterator(this.primaryNodetypes);
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        return new RegistryNodeTypeIterator(this.mixinNodetypes);
    }

    public NodeTypeTemplate createNodeTypeTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        RegistryNodeTypeTemplate ntTmpl = new RegistryNodeTypeTemplate();
        return ntTmpl;
    }

    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition nodeTypeDefinition) throws UnsupportedRepositoryOperationException, RepositoryException {
        return new RegistryNodeTypeTemplate(nodeTypeDefinition);
    }

    public NodeDefinitionTemplate createNodeDefinitionTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new RegistryNodeDefinitionTemplate(this);
    }

    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new RegistryPropertyDefinitionTemplate(this);
    }

    public Set<NodeType> getMixinNodetypes() {
        return this.mixinNodetypes;
    }

    public Set<NodeType> getPrimaryNodetypes() {
        return this.primaryNodetypes;
    }

    public NodeType registerNodeType(NodeTypeDefinition nodeTypeDefinition, boolean b) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        if (this.hasNodeType(nodeTypeDefinition.getName())) {
            throw new NodeTypeExistsException("Node type already exists :" + nodeTypeDefinition.getName());
        }
        RegistryNodeType nt = null;
        boolean proceed = false;
        if (!this.hasNodeType(nodeTypeDefinition.getName())) {
            proceed = true;
        } else if (b && this.hasNodeType(nodeTypeDefinition.getName())) {
            proceed = true;
        }
        if (proceed) {
            nt = new RegistryNodeType(nodeTypeDefinition, this);
        }
        if (nodeTypeDefinition.getName().startsWith("mix")) {
            this.mixinNodetypes.add(nt);
        } else {
            this.primaryNodetypes.add(nt);
        }
        this.nodeTypesList.add(nt);
        this.persistNodeTypeToRegistry((NodeTypeDefinition)nt);
        return nt;
    }

    public NodeType registerNodeTypeFromXML(NodeTypeDefinition nodeTypeDefinition, boolean b) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        if (this.hasNodeType(nodeTypeDefinition.getName())) {
            throw new NodeTypeExistsException("Node type already exists :" + nodeTypeDefinition.getName());
        }
        RegistryNodeType nt = null;
        boolean proceed = false;
        if (!this.hasNodeType(nodeTypeDefinition.getName())) {
            proceed = true;
        } else if (b && this.hasNodeType(nodeTypeDefinition.getName())) {
            proceed = true;
        }
        if (proceed) {
            nt = new RegistryNodeType(nodeTypeDefinition, this);
        }
        if (nodeTypeDefinition.getName().startsWith("mix")) {
            this.mixinNodetypes.add(nt);
        } else {
            this.primaryNodetypes.add(nt);
        }
        this.nodeTypesList.add(nt);
        return nt;
    }

    private void persistNodeTypeToRegistry(NodeTypeDefinition nodeTypeDefinition) {
        RegistryNodeTypeUtil.persistNodeTypeToRegistry(nodeTypeDefinition, this.registrySession);
    }

    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] nodeTypeDefinitions, boolean b) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        HashSet<NodeType> ntlist = new HashSet<NodeType>();
        RegistryNodeTypeIterator nti = null;
        for (NodeTypeDefinition ntd : nodeTypeDefinitions) {
            ntlist.add(this.registerNodeType(ntd, b));
        }
        nti = new RegistryNodeTypeIterator(ntlist);
        return nti;
    }

    public void unregisterNodeType(String s) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        if (!this.hasNodeType(s)) {
            throw new NoSuchNodeTypeException("No such node type exists to un register : " + s);
        }
        if (s != null && "nt:base".equals(s)) {
            throw new RepositoryException("Cannot remove the base node type");
        }
        this.unRegisterNodeTypeAt(s);
    }

    public void unregisterNodeTypes(String[] strings) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        for (String s : strings) {
            this.unregisterNodeType(s);
        }
    }

    private void unRegisterNodeTypeAt(String nodeType) throws RepositoryException {
        NodeType tempNT = this.getNodeType(nodeType);
        if (tempNT.isMixin()) {
            this.mixinNodetypes.remove(tempNT);
        } else {
            this.primaryNodetypes.remove(tempNT);
        }
        this.nodeTypesList.remove(tempNT);
        RegistryNodeTypeUtil.unregisterNodeTypeFromRegistry(this.registrySession, this, nodeType);
    }
}

