/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.query;

import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.jcr.RegistryNode;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeType;
import org.wso2.carbon.registry.jcr.query.RegistryQueryResult;

public class RegistryQuery
implements Query {
    private String statement = "";
    private String language = "";
    private RegistrySession session;

    public RegistryQuery(String statement, String language, RegistrySession session) {
        this.statement = statement;
        this.language = language;
        this.session = session;
    }

    public QueryResult execute() throws InvalidQueryException, RepositoryException {
        RegistryQueryResult jcr_result = null;
        String sql1 = "";
        UserRegistry registry = this.session.getUserRegistry();
        sql1 = this.statement.startsWith("org.wso2.registry.direct.query") ? this.statement.split(";;")[1] : this.getConvertedRegQuery(this.statement);
        Object q1 = null;
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            String[] paths;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("query", sql1);
            Collection result = registry.executeQuery(null, parameters);
            for (String path : paths = (String[])result.getContent()) {
                nodes.add(this.session.getNode(path));
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        jcr_result = new RegistryQueryResult(nodes, this.session);
        return jcr_result;
    }

    public void setLimit(long l) {
    }

    public void setOffset(long l) {
    }

    public String getStatement() {
        return this.statement;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        return "/_system/config/repository/components/org.wso2.carbon.registry/queries/custom-queries";
    }

    public Node storeAsNode(String s) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        RegistryNode node = new RegistryNode(s, this.session);
        CollectionImpl subCollection = null;
        try {
            subCollection = (CollectionImpl)this.session.getUserRegistry().newCollection();
            subCollection.setDescription("nt:query");
            this.session.getUserRegistry().put(s, (Resource)subCollection);
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        node.nodeType = (RegistryNodeType)node.getParent().getPrimaryNodeType();
        node.setPrimaryType("nt:query");
        return node;
    }

    public void bindValue(String s, Value value) throws IllegalArgumentException, RepositoryException {
    }

    public String[] getBindVariableNames() throws RepositoryException {
        return new String[0];
    }

    private String getConvertedRegQuery(String s) {
        String nodetype = "";
        String reg_sql = "";
        String secndPart = "";
        String firstPart = "";
        if (s.contains("WHERE")) {
            String[] tt;
            String[] temp = s.split("WHERE");
            firstPart = temp[0];
            secndPart = temp[1];
            if (secndPart.startsWith(" ")) {
                secndPart = secndPart.substring(1, secndPart.length());
            }
            if (secndPart.endsWith(" ")) {
                secndPart = secndPart.substring(0, secndPart.length() - 1);
            }
            for (String tc : tt = firstPart.split(" ")) {
                if (!tc.contains(":")) continue;
                nodetype = tc;
                break;
            }
            String[] secndPArr = secndPart.split(" ");
            String new_secndPart = "";
            for (int i = 0; i < secndPArr.length; ++i) {
                String tmpp = secndPArr[i].trim();
                if (tmpp.contains(":") && i < secndPArr.length - 2 && !tmpp.contains("CONTAINS")) {
                    if (secndPArr[i + 1].equals("=")) {
                        tmpp = "PP.REG_NAME='" + tmpp + "'AND PP.REG_VALUE = " + secndPArr[i + 2];
                        i += 2;
                    } else if (secndPArr[i + 1].equals(">")) {
                        tmpp = "PP.REG_NAME='" + tmpp + "'AND PP.REG_VALUE > " + secndPArr[i + 2];
                        i += 2;
                    } else if (secndPArr[i + 1].equals("<")) {
                        tmpp = "PP.REG_NAME='" + tmpp + "'AND PP.REG_VALUE < " + secndPArr[i + 2];
                        i += 2;
                    } else if (secndPArr[i + 1].equals("!=")) {
                        tmpp = "PP.REG_NAME='" + tmpp + "'AND PP.REG_VALUE != " + secndPArr[i + 2];
                        i += 2;
                    } else if (secndPArr[i + 1].equals(">=")) {
                        tmpp = "PP.REG_NAME='" + tmpp + "'AND PP.REG_VALUE >= " + secndPArr[i + 2];
                        i += 2;
                    } else if (secndPArr[i + 1].equals("<=")) {
                        tmpp = "PP.REG_NAME='" + tmpp + "'AND PP.REG_VALUE <= " + secndPArr[i + 2];
                        i += 2;
                    } else {
                        tmpp = "PP.REG_NAME = '" + tmpp + "'";
                    }
                }
                new_secndPart = new_secndPart.concat(tmpp + " ");
            }
            reg_sql = "SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R, REG_PROPERTY PP, REG_RESOURCE_PROPERTY RP WHERE R.REG_PATH_ID=RP.REG_PATH_ID AND R.REG_NAME IS NULL AND RP.REG_RESOURCE_NAME IS NULL AND RP.REG_PROPERTY_ID=PP.REG_ID AND REG_DESCRIPTION = '" + nodetype + "'";
            reg_sql = reg_sql.concat(" AND(" + new_secndPart + ")");
        } else {
            String[] tt;
            firstPart = s;
            for (String tc : tt = firstPart.split(" ")) {
                if (!tc.contains(":")) continue;
                nodetype = tc;
                break;
            }
            reg_sql = "SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R, REG_PROPERTY PP, REG_RESOURCE_PROPERTY RP WHERE R.REG_PATH_ID=RP.REG_PATH_ID AND R.REG_NAME IS NULL AND RP.REG_RESOURCE_NAME IS NULL AND RP.REG_PROPERTY_ID=PP.REG_ID AND REG_DESCRIPTION = '" + nodetype + "'";
        }
        return reg_sql;
    }
}

