/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.query.qom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.BindVariableValue;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.SameNode;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.version.VersionException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.jcr.RegistryNode;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.query.RegistryQueryResult;
import org.wso2.carbon.registry.jcr.query.qom.RegistryAnd;
import org.wso2.carbon.registry.jcr.query.qom.RegistryChildNode;
import org.wso2.carbon.registry.jcr.query.qom.RegistryComparison;
import org.wso2.carbon.registry.jcr.query.qom.RegistryDescendantNode;
import org.wso2.carbon.registry.jcr.query.qom.RegistryOr;
import org.wso2.carbon.registry.jcr.query.qom.RegistryPropertyExistence;
import org.wso2.carbon.registry.jcr.query.qom.RegistrySameNode;
import org.wso2.carbon.registry.jcr.query.qom.RegistrySelector;
import org.wso2.carbon.registry.jcr.util.query.qom.QOMUtil;

public class RegistryQueryObjectModel
implements QueryObjectModel {
    private Source source = null;
    private Constraint constraint = null;
    private Ordering[] orderings = null;
    private Column[] columns = null;
    private RegistrySession session = null;
    private String statement = "";
    private List sourceSet = new ArrayList();

    public RegistryQueryObjectModel(Source source, Constraint constraint, Ordering[] orderings, Column[] columns, Session session) {
        this.source = source;
        this.constraint = constraint;
        if (orderings != null) {
            this.orderings = Arrays.copyOf(orderings, orderings.length);
        }
        if (columns != null) {
            this.columns = Arrays.copyOf(columns, columns.length);
        }
        this.session = (RegistrySession)session;
    }

    public Source getSource() {
        return this.source;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public Ordering[] getOrderings() {
        if (this.orderings != null) {
            return Arrays.copyOf(this.orderings, this.orderings.length);
        }
        return new Ordering[0];
    }

    public Column[] getColumns() {
        if (this.columns != null) {
            return Arrays.copyOf(this.columns, this.columns.length);
        }
        return new Column[0];
    }

    public List evaluateAnd(List set, Constraint andConstraint) throws RepositoryException {
        ArrayList<RegistryNode> andResult = new ArrayList<RegistryNode>();
        Constraint constraint1 = ((RegistryAnd)andConstraint).getConstraint1();
        Constraint constraint2 = ((RegistryAnd)andConstraint).getConstraint2();
        List result1 = constraint1 instanceof And ? this.evaluateAnd(set, constraint1) : this.executeQuery(set, constraint1);
        List result2 = constraint2 instanceof And ? this.evaluateAnd(set, constraint2) : this.executeQuery(set, constraint2);
        for (RegistryNode temp : result1) {
            Iterator it2 = result2.iterator();
            while (it2.hasNext()) {
                if (!temp.getPath().equals(((RegistryNode)it2.next()).getPath())) continue;
                andResult.add(temp);
            }
        }
        return this.getfilteredFinalResult(set, andResult);
    }

    public List evaluateNot(List source_set, Constraint andConstraint) throws RepositoryException {
        Constraint constraint1 = ((RegistryAnd)andConstraint).getConstraint1();
        List result1 = constraint1 instanceof Not ? this.evaluateNot(source_set, constraint1) : this.executeQuery(source_set, constraint1);
        Iterator it1 = result1.iterator();
        ArrayList<RegistryNode> tempSet = new ArrayList<RegistryNode>();
        while (it1.hasNext()) {
            RegistryNode temp = (RegistryNode)it1.next();
            Iterator it2 = source_set.iterator();
            while (it2.hasNext()) {
                if (!temp.getPath().equals(((RegistryNode)it2.next()).getPath())) continue;
                tempSet.add(temp);
            }
        }
        source_set.removeAll(tempSet);
        return source_set;
    }

    public List evaluateComparison(List set, Constraint constraint) throws RepositoryException {
        DynamicOperand operand1 = ((RegistryComparison)constraint).getOperand1();
        StaticOperand operand2 = ((RegistryComparison)constraint).getOperand2();
        Value scalarOperandValue = null;
        Value[] dynamicOperandValues = null;
        ArrayList<Node> resultSet = new ArrayList<Node>();
        String operator = ((RegistryComparison)constraint).getOperator();
        try {
            ValueFactory valueFactory = this.session.getValueFactory();
            for (Object obj : set) {
                String propName;
                Node node = (Node)obj;
                if (operand1 instanceof PropertyValue) {
                    propName = ((PropertyValue)operand1).getPropertyName();
                    dynamicOperandValues = QOMUtil.getPropertyValueFromName(propName, node);
                    if (dynamicOperandValues == null) {
                        continue;
                    }
                } else if (operand1 instanceof Literal) {
                    dynamicOperandValues[0] = ((Literal)operand1).getLiteralValue();
                } else if (operand1 instanceof BindVariableValue) {
                    dynamicOperandValues[0] = valueFactory.createValue(((BindVariableValue)operand1).getBindVariableName());
                }
                if (operand2 instanceof Literal) {
                    scalarOperandValue = ((Literal)operand2).getLiteralValue();
                } else if (operand2 instanceof BindVariableValue) {
                    scalarOperandValue = valueFactory.createValue(((BindVariableValue)operand2).getBindVariableName());
                } else if (operand2 instanceof PropertyValue) {
                    propName = ((PropertyValue)operand2).getPropertyName();
                    scalarOperandValue = QOMUtil.getPropertyValueFromName(propName, node)[0];
                }
                for (Value value : dynamicOperandValues) {
                    boolean comparison = QOMUtil.evalComparison(value, scalarOperandValue, operator);
                    if (!comparison) continue;
                    resultSet.add(node);
                }
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Error while executing query comparison " + e.getMessage());
        }
        return resultSet;
    }

    public List evaluateChildNode(List set, Constraint constraint) throws RepositoryException {
        ArrayList<RegistryNode> result = new ArrayList<RegistryNode>();
        String path = ((RegistryChildNode)constraint).getParentPath();
        try {
            Iterator it = set.iterator();
            RegistryNode node = null;
            while (it.hasNext()) {
                node = (RegistryNode)it.next();
                if (!node.getPath().contains(path)) continue;
                result.add(node);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return this.getfilteredFinalResult(set, result);
    }

    public List evaluateDescendantNode(List set, Constraint constraint) throws RepositoryException {
        ArrayList<RegistryNode> result = new ArrayList<RegistryNode>();
        String path = ((RegistryDescendantNode)constraint).getAncestorPath();
        try {
            RegistryNode node2 = null;
            for (RegistryNode node2 : set) {
                if (!node2.getPath().contains(path)) continue;
                result.add(node2);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return this.getfilteredFinalResult(set, result);
    }

    public List evaluateFullTextSearch(List set, Constraint constraint) {
        return null;
    }

    public List evaluateOr(List set, Constraint constraint) throws RepositoryException {
        Constraint constraint1 = ((RegistryOr)constraint).getConstraint1();
        Constraint constraint2 = ((RegistryOr)constraint).getConstraint2();
        List result1 = constraint1 instanceof Or ? this.evaluateOr(set, constraint1) : this.executeQuery(set, constraint1);
        List result2 = constraint2 instanceof Or ? this.evaluateOr(set, constraint2) : this.executeQuery(set, constraint2);
        Iterator it1 = result1.iterator();
        Iterator it2 = result2.iterator();
        while (it1.hasNext()) {
            RegistryNode node1 = (RegistryNode)it1.next();
            while (it2.hasNext()) {
                RegistryNode node2 = (RegistryNode)it2.next();
                if (!node1.getPath().equals(node2.getPath())) continue;
                result2.remove(node2);
                it2 = result2.iterator();
            }
        }
        result1.addAll(result2);
        List orResult = result1;
        return this.getfilteredFinalResult(set, orResult);
    }

    public List evaluatePropertyExistence(List set, Constraint constraint) throws RepositoryException {
        ArrayList<RegistryNode> result = new ArrayList<RegistryNode>();
        String propName = ((RegistryPropertyExistence)constraint).getPropertyName();
        String query = "SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R, REG_PROPERTY PP, REG_RESOURCE_PROPERTY RP WHERE R.REG_PATH_ID=RP.REG_PATH_IDAND R.REG_NAME IS NULL AND RP.REG_RESOURCE_NAME IS NULL AND RP.REG_PROPERTY_ID=PP.REG_ID AND PP.REG_NAME=" + propName;
        this.statement = "org.wso2.registry.direct.query;;" + query;
        Iterator it = set.iterator();
        RegistryNode node = null;
        while (it.hasNext()) {
            node = (RegistryNode)it.next();
            if (!node.hasProperty(propName)) continue;
            result.add(node);
        }
        return this.getfilteredFinalResult(set, result);
    }

    public List evaluateSameNode(List set, Constraint constraint) throws RepositoryException {
        RegistryNode node = null;
        ArrayList<RegistryNode> result = new ArrayList<RegistryNode>();
        String path = ((RegistrySameNode)constraint).getPath();
        try {
            node = (RegistryNode)this.session.getNode(path);
            result.add(node);
            this.statement = "org.wso2.registry.direct.query;;SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R, REG_PATH PT WHERE PT.REG_PATH_VALUE ='" + path + "' AND R.REG_PATH_ID=PT.REG_PATH_ID AND R.REG_NAME IS NULL";
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return this.getfilteredFinalResult(set, result);
    }

    private List getfilteredFinalResult(List source, List result) throws RepositoryException {
        ArrayList<RegistryNode> finalResult = new ArrayList<RegistryNode>();
        for (RegistryNode temp1 : source) {
            for (RegistryNode temp2 : result) {
                if (!temp1.getPath().equals(temp2.getPath())) continue;
                finalResult.add(temp1);
            }
        }
        return finalResult;
    }

    private List executeLocalQuery(String sql) throws RepositoryException {
        UserRegistry registry = this.session.getUserRegistry();
        Object q1 = null;
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            String[] paths;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("query", sql);
            Collection result = registry.executeQuery(null, parameters);
            for (String path : paths = (String[])result.getContent()) {
                nodes.add(this.session.getNode(path));
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        return nodes;
    }

    private List getSourceSet(String ntName) {
        UserRegistry registry = this.session.getUserRegistry();
        Object q1 = null;
        String sql1 = "SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_DESCRIPTION ='" + ntName + "'";
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            String[] paths;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("query", sql1);
            Collection result = registry.executeQuery(null, parameters);
            for (String path : paths = (String[])result.getContent()) {
                nodes.add(this.session.getNode(path));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodes;
    }

    public QueryResult execute() throws InvalidQueryException, RepositoryException {
        RegistryQueryResult queryResult = null;
        if (this.source instanceof Selector) {
            this.sourceSet = this.sourceSelector(this.source);
        } else if (this.source instanceof Join) {
            this.sourceSet = this.sourceJoin(this.source);
        }
        List result = this.executeQuery(this.sourceSet, this.getConstraint());
        queryResult = new RegistryQueryResult(result, this.session);
        return queryResult;
    }

    private List sourceSelector(Source source) {
        String ntName = ((RegistrySelector)source).getNodeTypeName();
        return this.getSourceSet(ntName);
    }

    private List sourceJoin(Source source) {
        ArrayList joinSourceSet = new ArrayList();
        return joinSourceSet;
    }

    public List executeQuery(List sourceSet, Constraint constraint) throws RepositoryException {
        List set = null;
        if (constraint instanceof And) {
            set = this.evaluateAnd(sourceSet, constraint);
        } else if (constraint instanceof Not) {
            set = this.evaluateNot(sourceSet, constraint);
        } else if (constraint instanceof Comparison) {
            set = this.evaluateComparison(sourceSet, constraint);
        } else if (constraint instanceof ChildNode) {
            set = this.evaluateChildNode(sourceSet, constraint);
        } else if (constraint instanceof DescendantNode) {
            set = this.evaluateDescendantNode(sourceSet, constraint);
        } else if (constraint instanceof FullTextSearch) {
            set = this.evaluateFullTextSearch(sourceSet, constraint);
        } else if (constraint instanceof Or) {
            set = this.evaluateOr(sourceSet, constraint);
        } else if (constraint instanceof PropertyExistence) {
            set = this.evaluatePropertyExistence(sourceSet, constraint);
        } else if (constraint instanceof SameNode) {
            set = this.evaluateSameNode(sourceSet, constraint);
        }
        return set;
    }

    public void setLimit(long l) {
    }

    public void setOffset(long l) {
    }

    public String getStatement() {
        return this.statement;
    }

    public String getLanguage() {
        return null;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        return null;
    }

    public Node storeAsNode(String s) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        return null;
    }

    public void bindValue(String s, Value value) throws IllegalArgumentException, RepositoryException {
    }

    public String[] getBindVariableNames() throws RepositoryException {
        return new String[0];
    }
}

