/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.Privilege;
import org.wso2.carbon.registry.jcr.security.RegistryAccessControlEntry;
import org.wso2.carbon.registry.jcr.security.RegistryPrivilege;

public class RegistryAccessControlList
implements AccessControlList {
    private Set<AccessControlEntry> accessCtrList = new HashSet<AccessControlEntry>();

    public AccessControlEntry[] getAccessControlEntries() throws RepositoryException {
        return this.accessCtrList.toArray(new AccessControlEntry[this.accessCtrList.size()]);
    }

    public boolean addAccessControlEntry(Principal principal, Privilege[] privileges) throws AccessControlException, RepositoryException {
        boolean duplicatePrincilple = false;
        Iterator<AccessControlEntry> it = this.accessCtrList.iterator();
        while (it.hasNext()) {
            int i;
            RegistryAccessControlEntry tempRegAccEntry = (RegistryAccessControlEntry)it.next();
            this.accessCtrList.remove(tempRegAccEntry);
            if (it.next() == null || !tempRegAccEntry.getPrincipal().equals(principal)) continue;
            Privilege[] tempPrev = new RegistryPrivilege[tempRegAccEntry.getPrivileges().length + privileges.length];
            int j = 0;
            for (i = 0; i < tempRegAccEntry.getPrivileges().length; ++i) {
                tempPrev[i] = tempRegAccEntry.getPrivileges()[i];
            }
            for (i = tempRegAccEntry.getPrivileges().length; i < tempPrev.length; ++i) {
                tempPrev[i] = privileges[j];
                ++j;
            }
            RegistryAccessControlEntry accEntry = new RegistryAccessControlEntry(principal, tempPrev);
            this.accessCtrList.add(accEntry);
            duplicatePrincilple = true;
            break;
        }
        if (!duplicatePrincilple) {
            RegistryAccessControlEntry accEntry = new RegistryAccessControlEntry(principal, privileges);
            this.accessCtrList.add(accEntry);
        }
        return duplicatePrincilple;
    }

    public void removeAccessControlEntry(AccessControlEntry accessControlEntry) throws AccessControlException, RepositoryException {
        this.accessCtrList.remove(accessControlEntry);
    }
}

