/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.util.query.qom;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;

public class QOMUtil {
    public static boolean evalComparison(Value value1, Value value2, String operator) throws RepositoryException {
        int c = QOMUtil.compareValues(value1, value2);
        if (operator.equals("jcr.operator.equal.to")) {
            return c == 0;
        }
        if (operator == "jcr.operator.not.equal.to") {
            return c != 0;
        }
        if (operator == "jcr.operator.less.than") {
            return c < 0;
        }
        if (operator == "jcr.operator.greater.than") {
            return c > 0;
        }
        if (operator == "jcr.operator.greater.than.or.equal.to") {
            return c >= 0;
        }
        if (operator == "jcr.operator.less.than.or.equal.to") {
            return c <= 0;
        }
        throw new UnsupportedOperationException("Unsupported comparison operator: " + operator);
    }

    public static int compareValues(Value v1, Value v2) throws ValueFormatException, RepositoryException {
        Object c2;
        Comparable c1 = QOMUtil.getComparableValue(v1);
        switch (v1.getType()) {
            case 1: {
                c2 = v2.getString();
                break;
            }
            case 4: {
                c2 = v2.getDouble();
                break;
            }
            case 3: {
                c2 = v2.getLong();
                break;
            }
            case 6: {
                c2 = v2.getBoolean();
                break;
            }
            case 5: {
                c2 = v2.getDate() != null ? Long.valueOf(v2.getDate().getTimeInMillis()) : null;
                break;
            }
            case 12: {
                c2 = v2.getDecimal();
                break;
            }
            case 8: 
            case 11: {
                c2 = v2.getString();
                break;
            }
            default: {
                throw new RepositoryException("Property type not supported" + PropertyType.nameFromValue((int)v2.getType()));
            }
        }
        return QOMUtil.comparisonEval(c1, (Comparable)c2);
    }

    public static int comparisonEval(Comparable c1, Comparable c2) {
        if (c1 == null) {
            return -5;
        }
        if (c2 == null) {
            return 1;
        }
        try {
            return c1.compareTo(c2);
        }
        catch (ClassCastException e) {
            return -5;
        }
    }

    public static Comparable getComparableValue(Value val) throws ValueFormatException, RepositoryException {
        switch (val.getType()) {
            case 1: {
                return val.getString();
            }
            case 4: {
                return Double.valueOf(val.getDouble());
            }
            case 3: {
                return Long.valueOf(val.getLong());
            }
            case 6: {
                return Boolean.valueOf(val.getBoolean());
            }
            case 5: {
                return Long.valueOf(val.getDate().getTimeInMillis());
            }
            case 12: {
                return val.getDecimal();
            }
            case 8: 
            case 11: {
                return val.toString();
            }
        }
        throw new RepositoryException("Unsupported type: " + PropertyType.nameFromValue((int)val.getType()));
    }

    public static Value[] getPropertyValueFromName(String propName, Node n) {
        Value[] value = new Value[1];
        try {
            Property p = n.getProperty(propName);
            if (p != null && p.getValue() != null) {
                value[0] = p.getValue();
            } else if (p != null && p.isMultiple()) {
                Value[] valueArray = p.getValues();
            }
        }
        catch (Exception e) {
            value = null;
            Object var3_6 = null;
        }
        return value;
    }
}

