/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.util.retention;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.retention.Hold;
import javax.jcr.retention.RetentionPolicy;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.retention.RegistryHold;
import org.wso2.carbon.registry.jcr.retention.RegistryRetentionPolicy;

public class EffectiveRetentionUtil {
    public static final String WRITE_LOCKED = "writeLocked";
    public static final String DELETE_LOCKED = "deleteLocked";
    public static final String JCR_FULL_LOCKED = "fullLocked";
    public static final String JCR_FULL_HOLD = "fullHold";

    public static boolean checkEffectiveRetentionPolicyFullLocked(RegistrySession session, String path) throws RegistryException {
        try {
            Resource resource = session.getUserRegistry().get(path);
            String retention = resource.getProperty("org.wso2.carbon.registry.jcr.retention.policy");
            if (retention == null) {
                return false;
            }
            return retention.equalsIgnoreCase(JCR_FULL_LOCKED);
        }
        catch (RegistryException e) {
            throw new RegistryException("Registry level exception occurred while acquiring a retention lock on " + path);
        }
    }

    public static boolean checkEffectiveRetentionHoldFullLocked(RegistrySession session, String path) throws RegistryException, RepositoryException {
        for (Hold h : EffectiveRetentionUtil.getHoldsFromRegistry(session, path)) {
            if (!h.getName().equals(JCR_FULL_HOLD)) continue;
            return true;
        }
        return EffectiveRetentionUtil.hasDeepHoldParent(session, path);
    }

    private static boolean hasDeepHoldParent(RegistrySession session, String path) throws RepositoryException {
        try {
            String tmp = session.getUserRegistry().get(path).getParentPath();
            if (!tmp.endsWith("/")) {
                tmp = tmp + "/";
            }
            while (tmp.contains(session.getWorkspaceRootPath()) && !tmp.equals(session.getWorkspaceRootPath())) {
                for (Hold hold : EffectiveRetentionUtil.getHoldsFromRegistry(session, tmp)) {
                    if (!hold.isDeep()) continue;
                    return true;
                }
                tmp = session.getUserRegistry().get(tmp).getParentPath();
                if (tmp.endsWith("/")) continue;
                tmp = tmp + "/";
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception occurred while acquiring prent retention holds " + path);
        }
        return false;
    }

    public static boolean checkEffectiveWriteLocked(RegistrySession session, String path) throws RegistryException {
        try {
            Resource resource = session.getUserRegistry().get(path);
            String retention = resource.getProperty("org.wso2.carbon.registry.jcr.retention.policy");
            if (retention == null) {
                return false;
            }
            return retention.equalsIgnoreCase(WRITE_LOCKED);
        }
        catch (RegistryException e) {
            throw new RegistryException("Registry level exception occurred while acquiring a retention lock on " + path);
        }
    }

    public static boolean checkEffectiveDeleteLocked(RegistrySession session, String path) throws RegistryException {
        try {
            Resource resource = session.getUserRegistry().get(path);
            String retention = resource.getProperty("org.wso2.carbon.registry.jcr.retention.policy");
            if (retention == null) {
                return false;
            }
            return retention.equalsIgnoreCase(DELETE_LOCKED);
        }
        catch (RegistryException e) {
            throw new RegistryException("Registry level exception occurred while acquiring a retention lock on " + path);
        }
    }

    public static void setRetentionPolicyToRegistry(RegistrySession session, String s, RetentionPolicy retentionPolicy) throws RepositoryException {
        Resource resource = null;
        try {
            resource = session.getUserRegistry().get(s);
            resource.setProperty("org.wso2.carbon.registry.jcr.retention.policy", retentionPolicy.getName());
            session.getUserRegistry().put(s, resource);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception when setting retention policy at " + s);
        }
    }

    public static void removeRetentionPolicyFromRegistry(RegistrySession session, String s) throws RepositoryException {
        Resource resource = null;
        try {
            resource = session.getUserRegistry().get(s);
            resource.removeProperty("org.wso2.carbon.registry.jcr.retention.policy");
            session.getUserRegistry().put(s, resource);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception when setting retention policy at " + s);
        }
    }

    public static RetentionPolicy getRetentionPolicyFromRegistry(RegistrySession session, String s) throws RepositoryException {
        Resource resource = null;
        try {
            resource = session.getUserRegistry().get(s);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception when setting retention policy at " + s);
        }
        String name = resource.getProperty("org.wso2.carbon.registry.jcr.retention.policy");
        if (name != null) {
            return new RegistryRetentionPolicy(name);
        }
        return null;
    }

    public static Hold addHoldsToRegistry(RegistrySession session, String s, String s1, boolean b) throws RepositoryException {
        Resource resource = null;
        try {
            resource = session.getUserRegistry().get(s);
            if (resource.getPropertyValues("org.wso2.carbon.registry.jcr.retention.holds") == null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(s1 + ";" + String.valueOf(b));
                resource.setProperty("org.wso2.carbon.registry.jcr.retention.holds", list);
            } else {
                resource.getPropertyValues("org.wso2.carbon.registry.jcr.retention.holds").add(s1 + ";" + String.valueOf(b));
            }
            session.getUserRegistry().put(s, resource);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception when setting retention policy at " + s);
        }
        return new RegistryHold(s1, b);
    }

    public static Hold[] getHoldsFromRegistry(RegistrySession session, String s) throws RepositoryException {
        Resource resource = null;
        ArrayList<RegistryHold> holdList = new ArrayList<RegistryHold>();
        try {
            resource = session.getUserRegistry().get(s);
            List holds = resource.getPropertyValues("org.wso2.carbon.registry.jcr.retention.holds");
            if (holds != null) {
                for (Object hold : holds) {
                    String[] vals = hold.toString().split(";");
                    holdList.add(new RegistryHold(vals[0], Boolean.valueOf(vals[1])));
                }
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception when setting retention policy at " + s);
        }
        return holdList.toArray(new RegistryHold[0]);
    }

    public static void removeHoldFromRegistry(RegistrySession session, String s, Hold hold) throws RepositoryException {
        Resource resource = null;
        try {
            resource = session.getUserRegistry().get(s);
            List holds = resource.getPropertyValues("org.wso2.carbon.registry.jcr.retention.holds");
            ArrayList holdList = new ArrayList();
            String refHold = hold.getName() + ";" + hold.isDeep();
            if (holds != null) {
                for (Object _hold : holds) {
                    if (!_hold.equals(refHold)) continue;
                    resource.getPropertyValues("org.wso2.carbon.registry.jcr.retention.holds").remove(_hold);
                }
            }
            session.getUserRegistry().put(s, resource);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception when setting retention policy at " + s);
        }
    }
}

