/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.task.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.task.internal.RegistryTaskDataHolder;
import org.wso2.carbon.utils.CarbonUtils;

@Component(name="org.wso2.carbon.registry.task", immediate=true)
public class RegistryTaskServiceComponent {
    private static Log log = LogFactory.getLog(RegistryTaskServiceComponent.class);
    private RegistryTaskDataHolder dataHolder = RegistryTaskDataHolder.getInstance();
    private static final String REGISTRY_TASK_MANAGER = "registryTasks";

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"Registry Tasks bundle is activated ");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Registry Tasks bundle is deactivated ");
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(null);
    }

    @Reference(name="ntask.component", service=TaskService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTaskService")
    protected void setTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Task Service");
        }
        try {
            TaskManager taskManager = null;
            PrivilegedCarbonContext.startTenantFlow();
            try {
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
                taskManager = taskService.getTaskManager(REGISTRY_TASK_MANAGER);
                taskService.registerTaskType(REGISTRY_TASK_MANAGER);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
            if (taskManager != null) {
                this.registerTasks(taskManager);
                List allTasks = taskManager.getAllTasks();
                for (TaskInfo task : allTasks) {
                    taskManager.rescheduleTask(task.getName());
                }
            } else {
                log.warn((Object)"Unable to obtain an instance of a task manager");
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Unable to schedule tasks", e);
        }
    }

    private void registerTasks(TaskManager taskManager) throws TaskException {
        File registryXML;
        String configPath;
        try {
            for (TaskInfo taskInfo : taskManager.getAllTasks()) {
                taskManager.deleteTask(taskInfo.getName());
            }
        }
        catch (TaskException taskException) {
            // empty catch block
        }
        if ((configPath = CarbonUtils.getRegistryXMLPath()) != null && (registryXML = new File(configPath)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(registryXML);
                StAXOMBuilder builder = new StAXOMBuilder(CarbonUtils.replaceSystemVariablesInXml((InputStream)fileInputStream));
                OMElement configElement = builder.getDocumentElement();
                OMElement taskElement = configElement.getFirstChildWithName(new QName("tasks"));
                if (taskElement != null) {
                    Iterator tasks = taskElement.getChildrenWithName(new QName("task"));
                    while (tasks.hasNext()) {
                        OMElement task = (OMElement)tasks.next();
                        String cronExpression = task.getFirstChildWithName(new QName("trigger")).getAttributeValue(new QName("cron"));
                        if (cronExpression == null) {
                            log.warn((Object)"Only Cron-based triggers are supported right now");
                            continue;
                        }
                        TaskInfo.TriggerInfo trigger = new TaskInfo.TriggerInfo(cronExpression);
                        String name = task.getAttributeValue(new QName("name"));
                        String clazz = task.getAttributeValue(new QName("class"));
                        if (name == null) {
                            name = clazz.substring(clazz.lastIndexOf(".") + 1);
                        }
                        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
                        Iterator properties = task.getChildrenWithName(new QName("property"));
                        while (properties.hasNext()) {
                            OMElement property = (OMElement)properties.next();
                            propertyMap.put(property.getAttributeValue(new QName("key")), property.getAttributeValue(new QName("value")));
                        }
                        taskManager.registerTask(new TaskInfo(name, clazz, propertyMap, trigger));
                    }
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Unable to parse registry.xml", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Unable to read registry.xml", (Throwable)e);
            }
            catch (CarbonException e) {
                log.error((Object)"An error occurred during system variable replacement", (Throwable)e);
            }
        }
    }

    protected void unsetTaskService(TaskService taskService) {
        block8: {
            try {
                TaskManager taskManager = null;
                PrivilegedCarbonContext.startTenantFlow();
                try {
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
                    taskManager = taskService.getTaskManager(REGISTRY_TASK_MANAGER);
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                if (taskManager != null) {
                    for (TaskInfo taskInfo : taskManager.getAllTasks()) {
                        taskManager.deleteTask(taskInfo.getName());
                    }
                }
            }
            catch (TaskException e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)"TaskException: Unable to clean-up scheduled tasks ", (Throwable)e);
            }
        }
    }
}

