/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.uddi.uddiversionmodule;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UddiVersionHandler
extends AbstractHandler
implements Handler {
    private static final Log log = LogFactory.getLog(UddiVersionHandler.class);
    private static final String ENABLE = "enable";
    private static final String UDDI_SYSTEM_PROPERTY = "uddi";
    private static final String UDDI_V2 = "urn:uddi-org:api_v2";
    private static final String UDDI_V3 = "urn:uddi-org:api_v3";

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        try {
            SOAPEnvelope envelope;
            OMNamespace namespace;
            String nameSpace;
            if (ENABLE.equals(System.getProperty(UDDI_SYSTEM_PROPERTY)) && (nameSpace = (namespace = (envelope = msgContext.getEnvelope()).getNamespace()).getNamespaceURI()) != null) {
                log.info((Object)("first " + envelope.getBody().getFirstElementNS().getNamespaceURI()));
                log.info((Object)envelope.toString());
                if (envelope.getBody().getFirstElementNS().getNamespaceURI().equals(UDDI_V2)) {
                    OMFactory omFactory = envelope.getOMFactory();
                    OMElement firstElement = envelope.getBody().getFirstElement();
                    this.setNamespace(firstElement, omFactory.createOMNamespace(UDDI_V3, firstElement.getNamespace().getPrefix()));
                }
                log.info((Object)("second " + envelope.getBody().getFirstElementNS().getNamespaceURI()));
                log.info((Object)envelope.toString());
            }
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while processing SOAP message.", (Throwable)e);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void setNamespace(OMElement element, OMNamespace omNamespace) {
        element.setNamespace(omNamespace);
        Iterator childElements = element.getChildElements();
        while (childElements.hasNext()) {
            OMElement child = (OMElement)childElements.next();
            child.setNamespace(omNamespace);
            this.setNamespace(child, omNamespace);
        }
    }
}

