/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.ws.api.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.ws.api.internal.WSDataHolder;
import org.wso2.carbon.registry.ws.api.utils.WSDeploymentInterceptor;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="registry.ws.api.component", immediate=true)
public class WSRegistryServiceComponent {
    private static Log log = LogFactory.getLog(WSRegistryServiceComponent.class);
    private WSDataHolder dataHolder = WSDataHolder.getInstance();
    private ConfigurationContext configContext;

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Registry WS API bundle is activated");
        }
        try {
            AxisConfiguration config = this.configContext.getAxisConfiguration();
            WSDeploymentInterceptor interceptor = new WSDeploymentInterceptor();
            interceptor.init(config);
            config.addObservers((AxisObserver)interceptor);
        }
        catch (Throwable e) {
            log.error((Object)"Error occured while updating Registry WS API service", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity RP bundle is deactivated");
        }
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ConfigurationContextService set in Registry WS API bundle");
        }
        this.configContext = contextService.getServerConfigContext();
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ConfigurationContextService unset in Registry WS API bundle");
        }
        this.configContext = null;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(null);
    }
}

