/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.ws.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.LogEntryCollection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.ws.api.WSAssociation;
import org.wso2.carbon.registry.ws.api.WSCollection;
import org.wso2.carbon.registry.ws.api.WSComment;
import org.wso2.carbon.registry.ws.api.WSLogEntry;
import org.wso2.carbon.registry.ws.api.WSResource;
import org.wso2.carbon.registry.ws.api.WSResourceData;
import org.wso2.carbon.registry.ws.api.WSTag;
import org.wso2.carbon.registry.ws.api.WSTaggedResourcePath;
import org.wso2.carbon.registry.ws.api.internal.WSDataHolder;
import org.wso2.carbon.registry.ws.api.utils.CommonUtil;

public class WSRegistry
extends RegistryAbstractAdmin
implements Registry {
    private Log log = LogFactory.getLog(WSRegistry.class);
    private static final String REGISTRY_WS_API_TENANT = "registry.ws.api.tenant";
    private String workingDir = System.getProperty("WORK_DIR");
    private File tempFile;

    public WSRegistry() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.tempFile = File.createTempFile("wsresource", ".tmp");
            this.tempFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Not able to create temp files. Check permissions", (Throwable)e);
        }
    }

    private Registry getRegistryForTenant() {
        Registry registry = this.getRootRegistry();
        HttpSession httpSession = ((HttpServletRequest)MessageContext.getCurrentMessageContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)).getSession();
        RegistryService registryService = WSDataHolder.getInstance().getRegistryService();
        if (httpSession != null && registryService != null && PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId() == -1234) {
            try {
                Object tenantId = httpSession.getAttribute(REGISTRY_WS_API_TENANT);
                if (tenantId != null) {
                    return registryService.getRegistry("wso2.system.user", ((Integer)tenantId).intValue());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return registry;
    }

    public Resource newResource() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().newResource();
    }

    public Collection newCollection() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().newCollection();
    }

    public WSResource WSnewResource() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Resource resource = this.getRegistryForTenant().newResource();
        return CommonUtil.newResourcetoWSResource(resource);
    }

    public WSCollection WSnewCollection() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Collection collection = this.getRegistryForTenant().newCollection();
        return CommonUtil.newCollectiontoWSCollection(collection);
    }

    public Resource get(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().get(path);
    }

    public WSResource WSget(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Resource resource = this.getRegistryForTenant().get(path);
        DataHandler dataHandler = null;
        if (resource instanceof Collection) {
            return CommonUtil.transformCollectiontoWSCollection((Collection)resource, dataHandler);
        }
        return CommonUtil.transformResourceToWSResource(resource, dataHandler);
    }

    public Resource getMetaData(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getMetaData(path);
    }

    public String importResource(String s, String s1, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.importResource(s, s1, (Resource)resource);
    }

    public WSResource WSgetMetaData(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Resource resource = this.getRegistryForTenant().getMetaData(path);
        DataHandler dataHandler = null;
        try {
            dataHandler = CommonUtil.makeDataHandler(resource, this.tempFile);
        }
        catch (IOException e) {
            this.log.error((Object)"WSGet failed - Unable to generate temp file", (Throwable)e);
        }
        return CommonUtil.transformResourceToWSResource(resource, dataHandler);
    }

    public Collection get(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().get(path, start, pageSize);
    }

    public Collection getChildCollection(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().get(path, start, pageSize);
    }

    public WSCollection WSgetWithPageSize(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Collection collection = this.getRegistryForTenant().get(path, start, pageSize);
        DataHandler dataHandler = null;
        return CommonUtil.transformCollectiontoWSCollection(collection, dataHandler);
    }

    public WSCollection WSgetChildCollection(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Collection collection = this.getRegistryForTenant().get(path, start, pageSize);
        DataHandler dataHandler = null;
        return CommonUtil.transformCollectiontoWSCollection(collection, dataHandler);
    }

    public boolean resourceExists(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().resourceExists(path);
    }

    public String put(String s, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.put(s, (Resource)resource);
    }

    public String put(String suggestedPath, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().put(suggestedPath, resource);
    }

    public String WSput(String suggestedPath, WSResource wsResource) throws org.wso2.carbon.registry.core.exceptions.RegistryException, IOException {
        byte[] content = CommonUtil.makeBytesFromDataHandler(wsResource);
        Object resource = wsResource.isCollection() ? CommonUtil.transformWSCollectiontoCollection(wsResource, content) : CommonUtil.transformWSResourcetoResource(wsResource, content);
        return this.getRegistryForTenant().put(suggestedPath, (Resource)resource);
    }

    public void delete(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().delete(path);
    }

    public String importResource(String suggestedPath, String sourceURL, Resource metadata) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().importResource(suggestedPath, sourceURL, metadata);
    }

    public String WSimportResource(String suggestedPath, String sourceURL, WSResource metadata) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().importResource(suggestedPath, sourceURL, CommonUtil.transformWSResourcetoResource(metadata, null));
    }

    public String rename(String currentPath, String newName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().rename(currentPath, newName);
    }

    public String move(String currentPath, String newPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().move(currentPath, newPath);
    }

    public String copy(String sourcePath, String targetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().copy(sourcePath, targetPath);
    }

    public void createVersion(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().createVersion(path);
    }

    public String[] getVersions(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getVersions(path);
    }

    public void restoreVersion(String versionPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().restoreVersion(versionPath);
    }

    public void addAssociation(String sourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().addAssociation(sourcePath, targetPath, associationType);
    }

    public void removeAssociation(String sourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().removeAssociation(sourcePath, targetPath, associationType);
    }

    public Association[] getAllAssociations(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getAllAssociations(resourcePath);
    }

    public WSAssociation[] WSgetAllAssociations(String resoucePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Association[] associations = this.getRegistryForTenant().getAllAssociations(resoucePath);
        WSAssociation[] wsAssociations = new WSAssociation[associations.length];
        for (int i = 0; i < wsAssociations.length; ++i) {
            wsAssociations[i] = CommonUtil.transformAssociationToWSAssociation(associations[i]);
        }
        return wsAssociations;
    }

    public Association[] getAssociations(String resourcePath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getAssociations(resourcePath, associationType);
    }

    public WSAssociation[] WSgetAssociations(String resourcePath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Association[] associations = this.getRegistryForTenant().getAssociations(resourcePath, associationType);
        WSAssociation[] wsAssociations = new WSAssociation[associations.length];
        for (int i = 0; i < wsAssociations.length; ++i) {
            wsAssociations[i] = CommonUtil.transformAssociationToWSAssociation(associations[i]);
        }
        return wsAssociations;
    }

    public void applyTag(String resourcePath, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().applyTag(resourcePath, tag);
    }

    public TaggedResourcePath[] getResourcePathsWithTag(String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getResourcePathsWithTag(tag);
    }

    public WSTaggedResourcePath[] WSgetResourcePathsWithTag(String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return CommonUtil.exchangeTaggedResourcepath(this.getRegistryForTenant().getResourcePathsWithTag(tag));
    }

    public Tag[] getTags(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getTags(resourcePath);
    }

    public WSTag[] WSgetTags(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Tag[] tags = this.getRegistryForTenant().getTags(resourcePath);
        WSTag[] wsTags = new WSTag[tags.length];
        for (int i = 0; i < wsTags.length; ++i) {
            wsTags[i] = CommonUtil.transformTagToWSTag(tags[i]);
        }
        return wsTags;
    }

    public void removeTag(String path, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().removeTag(path, tag);
    }

    public String addComment(String s, org.wso2.carbon.registry.api.Comment comment) throws RegistryException {
        return this.addComment(s, (Comment)comment);
    }

    public String addComment(String resourcePath, Comment comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().addComment(resourcePath, comment);
    }

    public String WSaddComment(String resourcePath, WSComment comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().addComment(resourcePath, CommonUtil.WSCommenttoRegistryComment(comment));
    }

    public void editComment(String commentPath, String text) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().editComment(commentPath, text);
    }

    public Comment[] getComments(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getComments(resourcePath);
    }

    public WSComment[] WSgetComments(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Comment[] rcomment = this.getRegistryForTenant().getComments(resourcePath);
        WSComment[] wscomment = new WSComment[rcomment.length];
        for (int i = 0; i < rcomment.length; ++i) {
            wscomment[i] = new WSComment();
            wscomment[i] = CommonUtil.RegistryCommenttoWSComment(rcomment[i]);
        }
        return wscomment;
    }

    public WSComment WSgetSingleComment(String commentPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Comment comment = (Comment)this.getRegistryForTenant().get(commentPath);
        return CommonUtil.RegistryCommenttoWSComment(comment);
    }

    public void rateResource(String resourcePath, int rating) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().rateResource(resourcePath, rating);
    }

    public float getAverageRating(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getAverageRating(resourcePath);
    }

    public int getRating(String path, String userName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getRating(path, userName);
    }

    public Collection executeQuery(String path, Map parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().executeQuery(path, parameters);
    }

    public WSCollection WSexecuteQuery(String path, String[] key, String[] value) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Collection collection = this.getRegistryForTenant().executeQuery(path, CommonUtil.createMap(key, value));
        DataHandler dataHandler = null;
        WSCollection wsCollection = CommonUtil.transformCollectiontoWSCollection(collection, dataHandler);
        wsCollection.setChildCount(collection.getChildCount());
        wsCollection.setChildren(collection.getChildren());
        return wsCollection;
    }

    public LogEntry[] getLogs(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getLogs(resourcePath, action, userName, from, to, recentFirst);
    }

    public WSLogEntry[] WSgetLogs(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        LogEntry[] entries = this.getRegistryForTenant().getLogs(resourcePath, action, userName, from, to, recentFirst);
        WSLogEntry[] wsEntries = new WSLogEntry[entries.length];
        for (int i = 0; i < wsEntries.length; ++i) {
            wsEntries[i] = CommonUtil.transformLogEntryToWSLogEntry(entries[i]);
        }
        return wsEntries;
    }

    public LogEntryCollection getLogCollection(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getLogCollection(resourcePath, action, userName, from, to, recentFirst);
    }

    public String[] getAvailableAspects() {
        return this.getRegistryForTenant().getAvailableAspects();
    }

    public void associateAspect(String resourcePath, String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().associateAspect(resourcePath, aspect);
    }

    public void invokeAspectNoParam(String resourcePath, String aspectName, String action) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.invokeAspect(resourcePath, aspectName, action);
    }

    public void invokeAspect(String resourcePath, String aspectName, String action) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().invokeAspect(resourcePath, aspectName, action);
    }

    public void invokeAspectWithParam(String resourcePath, String aspectName, String action, String[] keys, String[] values) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < keys.length; ++i) {
            parameters.put(keys[i], values[i]);
        }
        this.invokeAspect(resourcePath, aspectName, action, parameters);
    }

    public void invokeAspect(String resourcePath, String aspectName, String action, Map<String, String> parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().invokeAspect(resourcePath, aspectName, action, parameters);
    }

    public String[] getAspectActions(String resourcePath, String aspectName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getAspectActions(resourcePath, aspectName);
    }

    public void beginTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().beginTransaction();
    }

    public void commitTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().commitTransaction();
    }

    public void rollbackTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().rollbackTransaction();
    }

    public RegistryContext getRegistryContext() {
        return this.getRegistryForTenant().getRegistryContext();
    }

    public Collection searchContent(String keywords) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException("Content search operation not supported");
    }

    public WSCollection WSsearchContent(String keywords) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Collection collection = this.getRegistryForTenant().searchContent(keywords);
        DataHandler dataHandler = null;
        WSCollection wsCollection = CommonUtil.transformCollectiontoWSCollection(collection, dataHandler);
        wsCollection.setChildCount(collection.getChildCount());
        wsCollection.setChildren(collection.getChildren());
        return wsCollection;
    }

    public void createLink(String path, String target) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().createLink(path, target);
    }

    public void createLink(String path, String target, String subTargetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().createLink(path, target, subTargetPath);
    }

    public void createLinkWithSubTarget(String path, String target, String subTargetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        if (subTargetPath == null) {
            this.getRegistryForTenant().createLink(path, target);
        }
        this.getRegistryForTenant().createLink(path, target, subTargetPath);
    }

    public void removeLink(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().removeLink(path);
    }

    public void restore(String path, Reader reader) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().restore(path, reader);
    }

    public void wsRestore(String path, DataHandler dataHandler) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            dataHandler.writeTo((OutputStream)output);
        }
        catch (IOException e) {
            String msg = "Failed to read the input";
            this.log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(output.toByteArray());
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        this.restore(path, reader);
    }

    public void dump(String path, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().dump(path, writer);
    }

    public DataHandler wsDump(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Object dataHandler = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile);
            OutputStreamWriter writer = new OutputStreamWriter(fileOutputStream);
            this.dump(path, writer);
            ((Writer)writer).flush();
            fileOutputStream.close();
            return new DataHandler((DataSource)new FileDataSource(this.tempFile));
        }
        catch (IOException e) {
            String msg = "get Content failed - Unable to generate temp file";
            this.log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String getEventingServiceURL(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().getEventingServiceURL(path);
    }

    public void setEventingServiceURL(String path, String eventingServiceURL) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().setEventingServiceURL(path, eventingServiceURL);
    }

    public boolean removeAspect(String name) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().removeAspect(name);
    }

    public boolean addAspect(String name, Aspect aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().removeAspect(name);
    }

    public void removeComment(String commentPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.getRegistryForTenant().removeComment(commentPath);
    }

    public DataHandler getContent(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            String[] subParts;
            String[] parts = path.split("[;]start[=]");
            if (parts.length == 2 && (subParts = parts[1].split("[;]pageSize[=]")).length == 2) {
                return CommonUtil.makeDataHandler((Resource)this.getRegistryForTenant().get(parts[0], Integer.parseInt(subParts[0]), Integer.parseInt(subParts[1])), this.tempFile);
            }
            return CommonUtil.makeDataHandler(this.getRegistryForTenant().get(path), this.tempFile);
        }
        catch (IOException e) {
            this.log.error((Object)"get Content failed - Unable to generate temp file", (Throwable)e);
            return null;
        }
    }

    public String[] getCollectionContent(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Object collectionContent = this.getRegistryForTenant().get(path).getContent();
        if (!(collectionContent instanceof String[])) {
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException("This method only provides content for a Collection. It has been accessed by a Resource");
        }
        return (String[])collectionContent;
    }

    public int getChildCount(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        int count = 0;
        Collection collection = (Collection)this.getRegistryForTenant().get(path);
        if (collection != null) {
            count = collection.getChildCount();
        }
        return count;
    }

    public WSResourceData getAll(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        WSResourceData resourceData = new WSResourceData();
        resourceData.setResource(this.WSget(path));
        UserRegistry configUserRegistry = (UserRegistry)this.getConfigUserRegistry();
        if (configUserRegistry != null) {
            resourceData.setRating(this.getRating(path, configUserRegistry.getUserName()));
        } else {
            resourceData.setRating(-1);
        }
        resourceData.setAverageRating(this.getAverageRating(path));
        resourceData.setTags(this.WSgetTags(path));
        resourceData.setComments(this.WSgetComments(path));
        resourceData.setAssociations(this.WSgetAllAssociations(path));
        return resourceData;
    }

    public boolean removeVersionHistory(String path, long snapshotId) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.getRegistryForTenant().removeVersionHistory(path, snapshotId);
    }

    public void dumpLite(String s, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
    }
}

