/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.ws.api.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.wso2.carbon.registry.ws.api.utils.SecurityUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class WSDeploymentInterceptor
implements AxisObserver {
    private static final String WS_REGISTRY_SERVICE_NAME = "WSRegistryService";
    private static final Log log = LogFactory.getLog(WSDeploymentInterceptor.class);
    private static final String WS_API_SEC_POLICY_FILE = "ws-api-sec-policy.xml";

    public void init(AxisConfiguration axisConfiguration) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing Registry WS-API Component");
        }
        try {
            AxisService service = axisConfiguration.getService(WS_REGISTRY_SERVICE_NAME);
            if (service != null) {
                this.engageSecurity(service);
            }
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public void moduleUpdate(AxisEvent arg0, AxisModule arg1) {
    }

    public void serviceGroupUpdate(AxisEvent arg0, AxisServiceGroup arg1) {
    }

    public void serviceUpdate(AxisEvent event, AxisService service) {
        if (event.getEventType() == 1 && WS_REGISTRY_SERVICE_NAME.equals(service.getName())) {
            try {
                this.engageSecurity(service);
            }
            catch (Exception e) {
                log.error((Object)"Error while updating WSRegistryService in WSDeploymentInterceptor", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void engageSecurity(AxisService service) {
        String path = CarbonUtils.getCarbonConfigDirPath() + File.separator + WS_API_SEC_POLICY_FILE;
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            AxisModule module = service.getAxisConfiguration().getModule("rampart");
            if (module == null) {
                log.error((Object)"Rampart module is not available in the system. Unable to engage security on the Registry WS-API Component");
                return;
            }
            log.info((Object)("Loading security policy for the Registry WS-API Component from " + path));
            Policy policy = PolicyEngine.getPolicy((InputStream)in);
            SecurityUtil.addUser();
            service.getPolicySubject().attachPolicy(policy);
            service.engageModule(module);
        }
        catch (FileNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No security policies specified for the Registry WS-API Component");
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error while engaging security on the Registry WS-API Component", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void addParameter(Parameter arg0) throws AxisFault {
    }

    public void deserializeParameters(OMElement arg0) throws AxisFault {
    }

    public Parameter getParameter(String arg0) {
        return null;
    }

    public ArrayList<Parameter> getParameters() {
        return null;
    }

    public boolean isParameterLocked(String arg0) {
        return false;
    }

    public void removeParameter(Parameter arg0) throws AxisFault {
    }
}

