/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.framework.server.polling;

import java.util.Properties;
import java.util.Random;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.connector.framework.server.polling.PollingJob;
import org.wso2.carbon.connector.framework.server.polling.PollingServerConnector;

public class PollingTaskRunner {
    private static final Logger log = LoggerFactory.getLogger(PollingTaskRunner.class);
    private static final Random RANDOM = new Random();
    private final PollingServerConnector connector;
    private Scheduler scheduler;

    public PollingTaskRunner(PollingServerConnector connector) {
        this.connector = connector;
    }

    public void start() {
        String group = "carbon.connector.quartz";
        JobDetail job = JobBuilder.newJob(PollingJob.class).withIdentity("Job - " + RANDOM.nextLong(), group).build();
        Trigger trigger = this.connector.cronExpression != null ? TriggerBuilder.newTrigger().withIdentity("Trigger - " + RANDOM.nextLong(), group).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.connector.cronExpression)).build() : TriggerBuilder.newTrigger().withIdentity("scheduledPoll", "group1").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.connector.interval).repeatForever()).build();
        try {
            this.scheduler = new StdSchedulerFactory(this.getSchedulerProperties("polling-task-runner")).getScheduler();
            this.scheduler.getContext().put("connector", (Object)this.connector);
            this.scheduler.start();
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            log.error("Exception occurred while scheduling job", (Throwable)e);
        }
    }

    protected void terminate() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            log.error("Exception occurred when shutting down scheduler", (Throwable)e);
        }
    }

    private Properties getSchedulerProperties(String name) {
        Properties config = new Properties();
        config.put("org.quartz.scheduler.instanceName", name);
        config.put("org.quartz.scheduler.rmi.export", "false");
        config.put("org.quartz.scheduler.rmi.proxy", "false");
        config.put("org.quartz.scheduler.wrapJobExecutionInUserTransaction", "false");
        config.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        config.put("org.quartz.threadPool.threadCount", "1");
        config.put("org.quartz.threadPool.threadPriority", "5");
        config.put("org.quartz.jobStore.misfireThreshold", "60000");
        config.put("org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread", "true");
        config.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        return config;
    }
}

