/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.framework.server.internal;

import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.connector.framework.ConnectorManager;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.messaging.ServerConnectorProvider;
import org.wso2.carbon.messaging.exceptions.ServerConnectorException;

@Component(name="org.wso2.carbon.serverconnector.framework.internal.ServerConnectorSC", immediate=true, property={"componentName=wso2-server-connector-sc"})
public class ServerConnectorSC
implements RequiredCapabilityListener {
    private static final Logger log = LoggerFactory.getLogger(ServerConnectorSC.class);
    private ConnectorManager connectorManager = new ConnectorManager();

    @Reference(name="server.connector.providers", service=ServerConnectorProvider.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterServerConnectorProvider")
    protected void registerServerConnectorProvider(ServerConnectorProvider serverConnectorProvider, Map properties) {
        this.connectorManager.registerServerConnectorProvider(serverConnectorProvider);
    }

    protected void unregisterServerConnectorProvider(ServerConnectorProvider serverConnectorProvider, Map properties) {
    }

    @Reference(name="carbonRuntime", service=CarbonRuntime.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterCarbonRuntime")
    protected void registerCarbonRuntime(CarbonRuntime carbonRuntime, Map properties) {
    }

    protected void unregisterCarbonRuntime(CarbonRuntime carbonRuntime, Map properties) {
    }

    public void onAllRequiredCapabilitiesAvailable() {
        try {
            this.connectorManager.startConnectors();
        }
        catch (ServerConnectorException e) {
            log.error("Error while starting connectors. " + e.getMessage(), (Throwable)e);
        }
    }
}

