/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.connector.framework;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.wso2.carbon.connector.framework.server.internal.DataHolder;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ClientConnector;
import org.wso2.carbon.messaging.ServerConnector;
import org.wso2.carbon.messaging.ServerConnectorErrorHandler;
import org.wso2.carbon.messaging.ServerConnectorProvider;
import org.wso2.carbon.messaging.exceptions.ServerConnectorException;

public class ConnectorManager {
    private Map<String, ServerConnector> serverConnectors = new HashMap<String, ServerConnector>();
    private Map<String, ClientConnector> clientConnectors = new HashMap<String, ClientConnector>();
    private Map<String, ServerConnectorProvider> serverConnectorProviders = new HashMap<String, ServerConnectorProvider>();
    private Map<String, ServerConnectorErrorHandler> serverConnectorErrorHandlers = new HashMap<String, ServerConnectorErrorHandler>();
    private CarbonMessageProcessor messageProcessor;

    private void registerServerConnector(ServerConnector serverConnector) {
        this.serverConnectors.put(serverConnector.getId(), serverConnector);
        if (DataHolder.getInstance().getBundleContext() != null) {
            DataHolder.getInstance().getBundleContext().registerService(ServerConnector.class, (Object)serverConnector, null);
        }
    }

    public void registerClientConnector(ClientConnector clientConnector) {
        this.clientConnectors.put(clientConnector.getProtocol(), clientConnector);
    }

    private void initializeServerConnectors() throws ServerConnectorException {
        for (ServerConnector connector : this.serverConnectors.values()) {
            connector.initConnector();
        }
    }

    public ServerConnector getServerConnector(String id) {
        return this.serverConnectors.get(id);
    }

    public ServerConnector createServerConnector(String protocol, String id, Map<String, String> properties) throws ServerConnectorException {
        Optional<ServerConnectorProvider> serverConnectorProviderOptional = this.getServerConnectorProvider(protocol);
        if (!serverConnectorProviderOptional.isPresent()) {
            throw new ServerConnectorException("Cannot create a new server connector as there are no connector provider available for protocol : " + protocol);
        }
        ServerConnector serverConnector = serverConnectorProviderOptional.get().createConnector(id, properties);
        serverConnector.setMessageProcessor(this.messageProcessor);
        this.registerServerConnector(serverConnector);
        return serverConnector;
    }

    public ClientConnector getClientConnector(String protocol) {
        return this.clientConnectors.get(protocol);
    }

    public void registerServerConnectorProvider(ServerConnectorProvider serverConnectorProvider) {
        List serverConnectors;
        this.serverConnectorProviders.put(serverConnectorProvider.getProtocol(), serverConnectorProvider);
        if (DataHolder.getInstance().getBundleContext() != null && (serverConnectors = serverConnectorProvider.initializeConnectors()) != null) {
            serverConnectors.forEach(this::registerServerConnector);
        }
    }

    private Optional<ServerConnectorProvider> getServerConnectorProvider(String protocol) {
        return Optional.ofNullable(this.serverConnectorProviders.get(protocol));
    }

    public void registerServerConnectorErrorHandler(ServerConnectorErrorHandler serverConnectorErrorHandler) {
        this.serverConnectorErrorHandlers.put(serverConnectorErrorHandler.getProtocol(), serverConnectorErrorHandler);
    }

    public Optional<ServerConnectorErrorHandler> getServerConnectorErrorHandler(String protocol) {
        return Optional.ofNullable(this.serverConnectorErrorHandlers.get(protocol));
    }

    public void initializeServerConnectors(CarbonMessageProcessor messageProcessor) throws ServerConnectorException {
        this.messageProcessor = messageProcessor;
        ServiceLoader<ServerConnectorProvider> serverConnectorProviderLoader = ServiceLoader.load(ServerConnectorProvider.class);
        serverConnectorProviderLoader.forEach(serverConnectorProvider -> {
            this.registerServerConnectorProvider((ServerConnectorProvider)serverConnectorProvider);
            List serverConnectors = serverConnectorProvider.initializeConnectors();
            if (serverConnectors == null || serverConnectors.isEmpty()) {
                return;
            }
            serverConnectors.forEach(serverConnector -> {
                serverConnector.setMessageProcessor(messageProcessor);
                this.registerServerConnector((ServerConnector)serverConnector);
            });
        });
        ServiceLoader<ServerConnectorErrorHandler> errorHandlerLoader = ServiceLoader.load(ServerConnectorErrorHandler.class);
        errorHandlerLoader.forEach(this::registerServerConnectorErrorHandler);
        this.initializeServerConnectors();
    }

    public void startConnectors() throws ServerConnectorException {
        for (ServerConnector serverConnector : this.serverConnectors.values()) {
            serverConnector.start();
        }
    }

    public void initializeClientConnectors(CarbonMessageProcessor carbonMessageProcessor) {
        ServiceLoader<ClientConnector> clientConnectorLoader = ServiceLoader.load(ClientConnector.class);
        clientConnectorLoader.forEach(clientConnector -> {
            clientConnector.setMessageProcessor(carbonMessageProcessor);
            this.registerClientConnector((ClientConnector)clientConnector);
        });
    }
}

