/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.callback;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.transport.jms.callback.JMSCallback;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;

public class AcknowledgementCallback
extends JMSCallback {
    private Message message;

    public AcknowledgementCallback(Session session, Object caller, Message message) {
        super(session, caller);
        this.message = message;
    }

    public void done(CarbonMessage carbonMessage) {
        try {
            if (carbonMessage.getProperty("JMS_MESSAGE_DELIVERY_STATUS").toString().equalsIgnoreCase("SUCCESS")) {
                this.message.acknowledge();
            } else {
                this.recoverSession();
            }
        }
        catch (JMSException | JMSConnectorException e) {
            throw new RuntimeException("Error completing the acknowledgement callback", (Throwable)e);
        }
        finally {
            this.markAsComplete();
        }
    }
}

