/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.receiver;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.transport.jms.callback.AcknowledgementCallback;
import org.wso2.carbon.transport.jms.callback.TransactedSessionCallback;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.utils.JMSUtils;

class JMSMessageHandler {
    private CarbonMessageProcessor carbonMessageProcessor;
    private String serviceId;
    private int acknowledgementMode;
    private Session session;

    JMSMessageHandler(CarbonMessageProcessor carbonMessageProcessor, String serviceId, Session session) throws JMSConnectorException {
        this.carbonMessageProcessor = carbonMessageProcessor;
        this.serviceId = serviceId;
        this.session = session;
        try {
            this.acknowledgementMode = session.getAcknowledgeMode();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error retrieving acknowledgement mode", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handle(Message message) throws JMSConnectorException {
        try {
            CarbonMessage jmsCarbonMessage = JMSUtils.createJMSCarbonMessage(message);
            jmsCarbonMessage.setProperty("PROTOCOL", (Object)"jms");
            jmsCarbonMessage.setProperty("JMS_SERVICE_ID", (Object)this.serviceId);
            jmsCarbonMessage.setProperty("JMS_SESSION_ACKNOWLEDGEMENT_MODE", (Object)this.acknowledgementMode);
            switch (this.acknowledgementMode) {
                case 2: {
                    AcknowledgementCallback acknowledgementCallback = new AcknowledgementCallback(this.session, this, message);
                    this.carbonMessageProcessor.receive(jmsCarbonMessage, (CarbonCallback)acknowledgementCallback);
                    JMSMessageHandler jMSMessageHandler = this;
                    synchronized (jMSMessageHandler) {
                        while (!acknowledgementCallback.isOperationComplete()) {
                            this.wait();
                        }
                        break;
                    }
                }
                case 0: {
                    TransactedSessionCallback transactedSessionCallback = new TransactedSessionCallback(this.session, this);
                    this.carbonMessageProcessor.receive(jmsCarbonMessage, (CarbonCallback)transactedSessionCallback);
                    JMSMessageHandler jMSMessageHandler = this;
                    synchronized (jMSMessageHandler) {
                        while (!transactedSessionCallback.isOperationComplete()) {
                            this.wait();
                        }
                        break;
                    }
                }
                default: {
                    this.carbonMessageProcessor.receive(jmsCarbonMessage, null);
                }
            }
        }
        catch (InterruptedException e) {
            throw new JMSConnectorException("Error waiting for the operation to complete", e);
        }
        catch (Exception e) {
            throw new JMSConnectorException("Error while getting the message from jms provider.", e);
        }
    }
}

