/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.receiver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ServerConnector;
import org.wso2.carbon.messaging.exceptions.ServerConnectorException;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.CachedJMSConnectionFactory;
import org.wso2.carbon.transport.jms.factory.JMSConnectionFactory;
import org.wso2.carbon.transport.jms.factory.PooledJMSConnectionFactory;
import org.wso2.carbon.transport.jms.receiver.JMSMessageConsumer;
import org.wso2.carbon.transport.jms.receiver.JMSMessageConsumerBuilder;
import org.wso2.carbon.utils.StringUtils;

public class JMSServerConnector
extends ServerConnector {
    private static final Logger logger = LoggerFactory.getLogger(JMSServerConnector.class);
    private CarbonMessageProcessor carbonMessageProcessor;
    private JMSConnectionFactory jmsConnectionFactory = null;
    private int numOfConcurrentConsumers = 1;
    private List<JMSMessageConsumer> messageConsumers;
    private String userName;
    private String password;
    private Properties properties;
    private long retryInterval = 10000L;
    private int maxRetryCount = 5;
    private boolean useReceiver = false;
    private String connectionFactoryNature = "default";

    public JMSServerConnector(String id, Map<String, String> properties) {
        super(id, properties);
    }

    public JMSServerConnector(Map<String, String> properties) {
        super("jms", properties);
    }

    void closeAll() throws JMSConnectorException {
        JMSConnectorException exception = null;
        for (JMSMessageConsumer messageConsumer : this.messageConsumers) {
            try {
                messageConsumer.closeAll();
            }
            catch (JMSConnectorException e) {
                if (exception == null) {
                    exception = new JMSConnectorException("Error closing the consumers for service " + this.id, (Throwable)((Object)e));
                    continue;
                }
                exception.addSuppressed((Throwable)((Object)e));
            }
        }
        this.messageConsumers = null;
        if (exception != null) {
            throw exception;
        }
    }

    public void setMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
        this.carbonMessageProcessor = carbonMessageProcessor;
    }

    public void init() throws ServerConnectorException {
    }

    public void destroy() throws JMSConnectorException {
        this.closeAll();
    }

    public void stop() throws JMSConnectorException {
        this.closeAll();
    }

    protected void beginMaintenance() throws JMSConnectorException {
        for (JMSMessageConsumer messageConsumer : this.messageConsumers) {
            messageConsumer.stop();
        }
    }

    protected void endMaintenance() throws JMSConnectorException {
        for (JMSMessageConsumer messageConsumer : this.messageConsumers) {
            messageConsumer.start();
        }
    }

    public void start() throws ServerConnectorException {
        String connectionFacNatureParam;
        String connectionFactoryType;
        String concurrentConsumers;
        String useReceiverParam;
        String maxRetryCountParam;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)this.getProperties());
        this.userName = (String)this.getProperties().get("connectionUsername");
        this.password = (String)this.getProperties().get("connectionPassword");
        String retryIntervalParam = (String)((ServerConnector)this).properties.get("retryInterval");
        if (retryIntervalParam != null) {
            try {
                this.retryInterval = Long.parseLong(retryIntervalParam);
            }
            catch (NumberFormatException ex) {
                logger.error("Provided value for retry interval is invalid, using the default retry interval value " + this.retryInterval);
            }
        }
        if ((maxRetryCountParam = (String)((ServerConnector)this).properties.get("maxRetryCount")) != null) {
            try {
                this.maxRetryCount = Integer.parseInt(maxRetryCountParam);
            }
            catch (NumberFormatException ex) {
                logger.error("Provided value for max retry count is invalid, using the default max retry count " + this.maxRetryCount);
            }
        }
        if ((useReceiverParam = (String)((ServerConnector)this).properties.get("useReceiver")) != null) {
            this.useReceiver = Boolean.parseBoolean(useReceiverParam);
        }
        if ((concurrentConsumers = (String)((ServerConnector)this).properties.get("concurrentConsumers")) != null) {
            try {
                this.numOfConcurrentConsumers = Integer.parseInt(concurrentConsumers);
            }
            catch (NumberFormatException e) {
                logger.error("Provided value for concurrentConsumers is invalid. Using the default value of " + this.numOfConcurrentConsumers);
            }
        }
        if ((connectionFactoryType = this.properties.getProperty("transport.jms.ConnectionFactoryType")) != null && "topic".equalsIgnoreCase(connectionFactoryType)) {
            boolean isDurable;
            boolean bl = isDurable = !StringUtils.isNullOrEmptyAfterTrim((String)this.properties.getProperty("transport.jms.SubscriptionDurable"));
            if (isDurable && this.numOfConcurrentConsumers > 1) {
                throw new JMSConnectorException("Concurrent consumers are not allowed for non-durable topic connections");
            }
        }
        if ((connectionFacNatureParam = (String)((ServerConnector)this).properties.get("connectionFactoryNature")) != null) {
            this.connectionFactoryNature = connectionFacNatureParam;
        }
        this.startConsuming();
    }

    void startConsuming() throws JMSConnectorException {
        try {
            if (this.jmsConnectionFactory == null) {
                switch (this.connectionFactoryNature) {
                    case "cached": {
                        this.jmsConnectionFactory = new CachedJMSConnectionFactory(this.properties);
                        break;
                    }
                    case "pooled": {
                        this.jmsConnectionFactory = new PooledJMSConnectionFactory(this.properties);
                        break;
                    }
                    default: {
                        this.jmsConnectionFactory = new JMSConnectionFactory(this.properties);
                    }
                }
            }
            this.messageConsumers = new ArrayList<JMSMessageConsumer>();
            for (int i = 0; i < this.numOfConcurrentConsumers; ++i) {
                JMSMessageConsumerBuilder consumerBuilder = new JMSMessageConsumerBuilder(this.jmsConnectionFactory, this.carbonMessageProcessor, this.id);
                consumerBuilder.setUseReceiver(this.useReceiver).setUsername(this.userName).setPassword(this.password).setRetryInterval(this.retryInterval).setMaxRetryCount(this.maxRetryCount);
                this.messageConsumers.add(consumerBuilder.build());
            }
        }
        catch (JMSConnectorException e) {
            if (null == this.jmsConnectionFactory) {
                throw new JMSConnectorException("Cannot create the jms connection factory. please check the connection properties and re-deploy the jms service.", (Throwable)((Object)e));
            }
            throw e;
        }
    }
}

