/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.factory;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.JMSConnectionFactory;

public class CachedJMSConnectionFactory
extends JMSConnectionFactory {
    public static final String PARAM_CACHE_LEVEL = "transport.jms.CacheLevel";
    public static final int CACHE_NONE = 0;
    public static final int CACHE_CONNECTION = 1;
    public static final int CACHE_SESSION = 2;
    public static final int CACHE_CONSUMER = 3;
    public static final int CACHE_PRODUCER = 4;
    private int cacheLevel = 0;
    private Connection cachedConnection = null;
    private Session cachedSession = null;
    private MessageConsumer cachedMessageConsumer = null;
    private MessageProducer cachedMessageProducer = null;

    public CachedJMSConnectionFactory(Properties properties) throws JMSConnectorException {
        super(properties);
        this.setValues(properties);
    }

    private void setValues(Properties properties) {
        String cacheLevel = properties.getProperty(PARAM_CACHE_LEVEL);
        this.cacheLevel = null != cacheLevel && !cacheLevel.isEmpty() ? Integer.parseInt(cacheLevel) : 0;
    }

    @Override
    public ConnectionFactory getConnectionFactory() throws JMSConnectorException {
        return super.getConnectionFactory();
    }

    @Override
    public Connection createConnection() throws JMSException {
        Connection connection;
        if (this.cacheLevel >= 1) {
            if (this.cachedConnection == null) {
                this.cachedConnection = connection = super.createConnection();
            } else {
                connection = this.cachedConnection;
            }
        } else {
            connection = super.createConnection();
        }
        return connection;
    }

    @Override
    public Connection createConnection(String userName, String password) throws JMSException {
        Connection connection;
        if (userName == null && password == null) {
            connection = this.createConnection();
        } else {
            if (this.cachedConnection == null) {
                this.cachedConnection = connection = super.createConnection(userName, password);
            } else {
                connection = this.cachedConnection;
            }
            try {
                connection.start();
            }
            catch (JMSException e) {
                if (this.cachedConnection != null) {
                    this.resetCache();
                    connection = this.createConnection(userName, password);
                }
                throw e;
            }
        }
        return connection;
    }

    @Override
    public Session getSession(Connection connection) throws JMSConnectorException {
        if (this.cachedSession == null) {
            return this.createSession(connection);
        }
        return this.cachedSession;
    }

    @Override
    public Session createSession(Connection connection) throws JMSConnectorException {
        Session session;
        if (this.cacheLevel >= 2) {
            if (this.cachedSession == null) {
                this.cachedSession = session = super.createSession(connection);
            } else {
                session = this.cachedSession;
            }
        } else {
            session = super.createSession(connection);
        }
        return session;
    }

    @Override
    public MessageConsumer getMessageConsumer(Session session, Destination destination) throws JMSConnectorException {
        MessageConsumer messageConsumer = this.cachedMessageConsumer == null ? this.createMessageConsumer(session, destination) : this.cachedMessageConsumer;
        return messageConsumer;
    }

    @Override
    public MessageConsumer createMessageConsumer(Session session, Destination destination) throws JMSConnectorException {
        MessageConsumer messageConsumer;
        if (this.cacheLevel >= 3) {
            if (this.cachedMessageConsumer == null) {
                this.cachedMessageConsumer = messageConsumer = super.createMessageConsumer(session, destination);
            } else {
                messageConsumer = this.cachedMessageConsumer;
            }
        } else {
            messageConsumer = super.createMessageConsumer(session, destination);
        }
        return messageConsumer;
    }

    @Override
    public MessageProducer getMessageProducer(Session session, Destination destination) throws JMSConnectorException {
        MessageProducer messageProducer = this.cachedMessageProducer == null ? this.createMessageProducer(session, destination) : this.cachedMessageProducer;
        return messageProducer;
    }

    @Override
    public MessageProducer createMessageProducer(Session session, Destination destination) throws JMSConnectorException {
        MessageProducer messageProducer;
        if (this.cacheLevel >= 4) {
            if (this.cachedMessageProducer == null) {
                this.cachedMessageProducer = messageProducer = super.createMessageProducer(session, destination);
            } else {
                messageProducer = this.cachedMessageProducer;
            }
        } else {
            messageProducer = super.createMessageProducer(session, destination);
        }
        return messageProducer;
    }

    public void closeConnection() throws JMSException {
        if (this.cachedConnection != null) {
            this.cachedConnection.close();
        }
    }

    @Override
    public void closeConnection(Connection connection) throws JMSConnectorException {
        try {
            connection.close();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while closing the connection.", e);
        }
        finally {
            if (this.cacheLevel >= 1 && this.cachedConnection != null && this.cachedConnection.equals(connection)) {
                this.cachedConnection = null;
            }
        }
    }

    @Override
    public void closeMessageConsumer(MessageConsumer messageConsumer) throws JMSConnectorException {
        try {
            messageConsumer.close();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while closing the consumer.", e);
        }
        finally {
            if (this.cacheLevel >= 3 && this.cachedMessageConsumer != null && this.cachedMessageConsumer.equals(messageConsumer)) {
                this.cachedMessageConsumer = null;
            }
        }
    }

    @Override
    public void closeMessageProducer(MessageProducer messageProducer) throws JMSConnectorException {
        try {
            messageProducer.close();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while closing the producer.", e);
        }
        finally {
            if (this.cacheLevel >= 4 && this.cachedMessageProducer != null && this.cachedMessageProducer.equals(messageProducer)) {
                this.cachedMessageProducer = null;
            }
        }
    }

    @Override
    public void closeSession(Session session) throws JMSConnectorException {
        try {
            session.close();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while closing the session.", e);
        }
        finally {
            if (this.cacheLevel >= 2 && this.cachedSession != null && this.cachedSession.equals(session)) {
                this.cachedSession = null;
            }
        }
    }

    private void resetCache() throws JMSException {
        if (this.cachedMessageConsumer != null) {
            this.cachedMessageConsumer.close();
            this.cachedMessageConsumer = null;
        }
        if (this.cachedMessageProducer != null) {
            this.cachedMessageProducer.close();
            this.cachedMessageProducer = null;
        }
        if (this.cachedSession != null) {
            this.cachedSession.close();
            this.cachedSession = null;
        }
        if (this.cachedConnection != null) {
            this.cachedConnection.close();
            this.cachedConnection = null;
        }
    }
}

