/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.factory;

public class PooledConnectionKey {
    private final String username;
    private final String password;
    private int hashCode;

    public PooledConnectionKey(String username, String password) {
        this.username = username;
        this.password = password;
        this.generateHashCode();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    private void generateHashCode() {
        int usernameHash = 0;
        int passwordHash = 0;
        if (this.username != null) {
            usernameHash = this.username.hashCode();
        }
        if (this.password != null) {
            passwordHash = 31 * this.password.hashCode();
        }
        this.hashCode = usernameHash + passwordHash;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PooledConnectionKey that = (PooledConnectionKey)object;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        if (this.username != null) {
            if (that.username == null) {
                return false;
            }
            if (!this.username.equals(that.username)) {
                return false;
            }
        }
        if (this.password != null) {
            if (that.password == null) {
                return false;
            }
            if (this.password.equals(that.password)) {
                return false;
            }
        }
        return true;
    }
}

