/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.receiver;

import org.wso2.carbon.transport.jms.contract.JMSServerConnectorFuture;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.JMSConnectionFactory;
import org.wso2.carbon.transport.jms.receiver.JMSMessageConsumer;

public class JMSMessageConsumerBuilder {
    private JMSConnectionFactory connectionFactory = null;
    private boolean useReceiver = false;
    private String serviceId;
    private JMSServerConnectorFuture jmsServerConnectorFuture;
    private String username;
    private String password;
    private long retryInterval = 10000L;
    private int maxRetryCount = 5;

    public JMSMessageConsumerBuilder(JMSConnectionFactory connectionFactory, JMSServerConnectorFuture jmsServerConnectorFuture, String serviceId) {
        this.connectionFactory = connectionFactory;
        this.jmsServerConnectorFuture = jmsServerConnectorFuture;
        this.serviceId = serviceId;
    }

    public JMSMessageConsumerBuilder setUseReceiver(boolean useReceiver) {
        this.useReceiver = useReceiver;
        return this;
    }

    public JMSMessageConsumerBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public JMSMessageConsumerBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public JMSMessageConsumerBuilder setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public JMSMessageConsumerBuilder setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
        return this;
    }

    public JMSMessageConsumer build() throws JMSConnectorException {
        return new JMSMessageConsumer(this.connectionFactory, this.useReceiver, this.jmsServerConnectorFuture, this.serviceId, this.username, this.password, this.retryInterval, this.maxRetryCount);
    }
}

