/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.receiver;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.jms.contract.JMSServerConnectorFuture;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.receiver.JMSMessageHandler;

public class JMSMessageReceiver
implements Runnable,
Thread.UncaughtExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(JMSMessageReceiver.class);
    private MessageConsumer messageConsumer;
    private JMSMessageHandler messageHandler;
    private boolean running = true;
    private long timeout = -1L;

    JMSMessageReceiver(JMSServerConnectorFuture jmsServerConnectorFuture, String serviceId, Session session, MessageConsumer messageConsumer) throws JMSConnectorException {
        this.messageConsumer = messageConsumer;
        this.messageHandler = new JMSMessageHandler(jmsServerConnectorFuture, serviceId, session);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Message message = this.timeout < 0L ? this.messageConsumer.receive() : this.messageConsumer.receive(this.timeout);
                if (message != null) {
                    this.messageHandler.handle(message);
                    continue;
                }
                logger.warn("Timeout expired or message consumer is concurrently closed");
            }
            catch (JMSException e) {
                throw new RuntimeException("Error receiving messages", e);
            }
            catch (JMSConnectorException e) {
                logger.error("Error handling the received message", (Throwable)e);
            }
        }
    }

    public void receive() {
        this.startReceiverThread();
    }

    public void receive(long timeout) {
        this.timeout = timeout;
        this.startReceiverThread();
    }

    private void startReceiverThread() {
        Thread thread = new Thread((Runnable)this, "JMSMessageReceiverThread");
        thread.setUncaughtExceptionHandler(this);
        thread.start();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable error) {
        this.running = false;
        logger.error("Unexpected error occurred while receiving messages", error);
    }
}

