/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.sender;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.messaging.MapCarbonMessage;
import org.wso2.carbon.messaging.SerializableCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.transport.jms.contract.JMSClientConnector;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.CachedJMSConnectionFactory;
import org.wso2.carbon.transport.jms.factory.JMSConnectionFactory;
import org.wso2.carbon.transport.jms.factory.PooledJMSConnectionFactory;

public class JMSClientConnectorImpl
implements JMSClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(JMSClientConnectorImpl.class);
    private MessageProducer messageProducer;
    private Session session;
    private Connection connection;
    private JMSConnectionFactory jmsConnectionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(CarbonMessage message, Map<String, String> propertyMap) throws JMSConnectorException {
        try {
            this.setupMessageProducer(propertyMap);
            Message jmsMessage = this.createJmsMessage(message, propertyMap);
            this.sendMessage(message, jmsMessage);
        }
        finally {
            if (this.jmsConnectionFactory != null) {
                try {
                    this.jmsConnectionFactory.closeMessageProducer(this.messageProducer);
                    this.jmsConnectionFactory.closeSession(this.session);
                    this.jmsConnectionFactory.closeConnection(this.connection);
                }
                catch (JMSConnectorException e) {
                    logger.error("Exception occurred when closing connection. Error: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    private void sendMessage(CarbonMessage carbonMessage, Message jmsMessage) throws JMSConnectorException {
        int deliveryMode = 2;
        if (this.getHeader(carbonMessage, "JMS_DELIVERY_MODE").equalsIgnoreCase("2")) {
            deliveryMode = 1;
        }
        int priority = 4;
        String value = carbonMessage.getHeader("JMS_PRIORITY");
        if (value != null) {
            priority = Integer.parseInt(value);
        }
        long timeToLive = 0L;
        value = carbonMessage.getHeader("JMS_EXPIRATION");
        if (value != null) {
            timeToLive = Long.parseLong(value);
        }
        try {
            this.messageProducer.send(jmsMessage, deliveryMode, priority, timeToLive);
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Send Failed with priority " + priority + " , delivery mode " + deliveryMode + " [ " + e.getMessage() + " ]", e);
        }
    }

    private Message createJmsMessage(CarbonMessage carbonMessage, Map<String, String> propertyMap) throws JMSConnectorException {
        String messageType = propertyMap.get("JMS_MESSAGE_TYPE");
        try {
            TextMessage jmsMessage;
            if (carbonMessage instanceof TextCarbonMessage) {
                String textData = ((TextCarbonMessage)carbonMessage).getText();
                jmsMessage = this.session.createTextMessage(textData);
            } else if (carbonMessage instanceof SerializableCarbonMessage) {
                jmsMessage = this.session.createObjectMessage((Serializable)((SerializableCarbonMessage)carbonMessage));
            } else if (carbonMessage instanceof MapCarbonMessage) {
                MapMessage jmsMapMessage = this.session.createMapMessage();
                MapCarbonMessage mapCarbonMessage = (MapCarbonMessage)carbonMessage;
                Enumeration mapNames = mapCarbonMessage.getMapNames();
                while (mapNames.hasMoreElements()) {
                    String key = (String)mapNames.nextElement();
                    jmsMapMessage.setString(key, mapCarbonMessage.getValue(key));
                }
                jmsMessage = jmsMapMessage;
            } else if (carbonMessage instanceof DefaultCarbonMessage) {
                jmsMessage = this.session.createMessage();
            } else {
                throw new JMSConnectorException("Unknown carbon message instance provided. Message type: " + messageType);
            }
            this.setJmsProperties(carbonMessage, (Message)jmsMessage);
            this.setJmsHeaders(carbonMessage, (Message)jmsMessage);
            return jmsMessage;
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error occurred while preparing the JMS message. " + e.getMessage(), e);
        }
    }

    private void setJmsHeaders(CarbonMessage carbonMessage, Message jmsMessage) throws JMSConnectorException {
        try {
            String value = this.getHeader(carbonMessage, "JMS_CORRELATION_ID");
            if (!value.isEmpty()) {
                jmsMessage.setJMSCorrelationID(value);
            }
            if (!(value = this.getHeader(carbonMessage, "JMS_MESSAGE_TYPE")).isEmpty()) {
                jmsMessage.setJMSType(value);
            }
            if (!(value = this.getHeader(carbonMessage, "JMS_REPLY_TO")).isEmpty()) {
                Destination destination = this.jmsConnectionFactory.getDestination(value);
                jmsMessage.setJMSReplyTo(destination);
            }
        }
        catch (NamingException e) {
            throw new JMSConnectorException("Error occurred while setting JMS_REPLY_TO JMS message header." + e.getMessage(), e);
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error occurred while setting JMS message headers. " + e.getMessage(), e);
        }
    }

    private String getHeader(CarbonMessage carbonMessage, String headerName) {
        String value = carbonMessage.getHeader(headerName);
        if (value == null) {
            return "";
        }
        return value;
    }

    private void setJmsProperties(CarbonMessage carbonMessage, Message message) throws JMSException {
        for (Map.Entry entry : carbonMessage.getProperties().entrySet()) {
            message.setStringProperty((String)entry.getKey(), entry.getValue().toString());
        }
    }

    private void setupMessageProducer(Map<String, String> propertyMap) throws JMSConnectorException {
        try {
            Session session;
            Properties properties = new Properties();
            properties.putAll(propertyMap);
            String connectionFactoryNature = properties.getProperty("connectionFactoryNature");
            if (connectionFactoryNature != null) {
                switch (connectionFactoryNature) {
                    case "cached": {
                        this.jmsConnectionFactory = new CachedJMSConnectionFactory(properties);
                        break;
                    }
                    case "pooled": {
                        this.jmsConnectionFactory = new PooledJMSConnectionFactory(properties);
                        break;
                    }
                    default: {
                        this.jmsConnectionFactory = new JMSConnectionFactory(properties);
                        break;
                    }
                }
            } else {
                this.jmsConnectionFactory = new JMSConnectionFactory(properties);
            }
            String conUsername = properties.getProperty("connectionUsername");
            String conPassword = properties.getProperty("connectionPassword");
            Connection connection = conUsername != null && conPassword != null ? this.jmsConnectionFactory.createConnection(conUsername, conPassword) : this.jmsConnectionFactory.createConnection();
            this.connection = connection;
            this.session = session = this.jmsConnectionFactory.getSession(connection);
            Destination destination = this.jmsConnectionFactory.getDestination(session);
            this.messageProducer = this.jmsConnectionFactory.getMessageProducer(session, destination);
        }
        catch (JMSException | JMSConnectorException e) {
            throw new JMSConnectorException("Error connecting to JMS provider. " + e.getMessage(), e);
        }
    }
}

