/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.receiver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.utils.StringUtils;
import org.wso2.carbon.transport.jms.contract.JMSServerConnector;
import org.wso2.carbon.transport.jms.contract.JMSServerConnectorFuture;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.JMSServerConnectionFactory;
import org.wso2.carbon.transport.jms.receiver.JMSMessageConsumer;
import org.wso2.carbon.transport.jms.receiver.JMSMessageConsumerBuilder;

public class JMSServerConnectorImpl
implements JMSServerConnector {
    private static final Logger logger = LoggerFactory.getLogger(JMSServerConnectorImpl.class);
    private String serviceId;
    private JMSServerConnectorFuture jmsServerConnectorFuture;
    private JMSServerConnectionFactory jmsConnectionFactory = null;
    private int numOfConcurrentConsumers = 1;
    private List<JMSMessageConsumer> messageConsumers;
    private Properties properties;
    private long retryInterval = 10000L;
    private int maxRetryCount = 5;
    private boolean useReceiver = false;
    private String connectionFactoryNature = "default";

    public JMSServerConnectorImpl(String serviceId, Map<String, String> connectorConfig, JMSServerConnectorFuture jmsServerConnectorFuture) throws JMSConnectorException {
        this.jmsServerConnectorFuture = jmsServerConnectorFuture;
        this.serviceId = serviceId;
        this.init(connectorConfig);
    }

    private void init(Map<String, String> connectorConfig) throws JMSConnectorException {
        String connectionFacNatureParam;
        String connectionFactoryType;
        String concurrentConsumers;
        String useReceiverParam;
        String maxRetryCountParam;
        this.properties = new Properties();
        this.properties.putAll(connectorConfig);
        String retryIntervalParam = connectorConfig.get("retryInterval");
        if (retryIntervalParam != null) {
            try {
                this.retryInterval = Long.parseLong(retryIntervalParam);
            }
            catch (NumberFormatException ex) {
                logger.error("Provided value for retry interval is invalid, using the default retry interval value " + this.retryInterval);
            }
        }
        if ((maxRetryCountParam = connectorConfig.get("maxRetryCount")) != null) {
            try {
                this.maxRetryCount = Integer.parseInt(maxRetryCountParam);
            }
            catch (NumberFormatException ex) {
                logger.error("Provided value for max retry count is invalid, using the default max retry count " + this.maxRetryCount);
            }
        }
        if ((useReceiverParam = connectorConfig.get("synchronousConsume")) != null) {
            this.useReceiver = Boolean.parseBoolean(useReceiverParam);
        }
        if ((concurrentConsumers = connectorConfig.get("concurrentConsumers")) != null) {
            try {
                this.numOfConcurrentConsumers = Integer.parseInt(concurrentConsumers);
            }
            catch (NumberFormatException e) {
                logger.error("Provided value for concurrentConsumers is invalid. Using the default value of " + this.numOfConcurrentConsumers);
            }
        }
        if ((connectionFactoryType = connectorConfig.get("transport.jms.ConnectionFactoryType")) != null && "topic".equalsIgnoreCase(connectionFactoryType)) {
            boolean isDurable;
            boolean bl = isDurable = !StringUtils.isNullOrEmptyAfterTrim((String)connectorConfig.get("transport.jms.SubscriptionDurable"));
            if (isDurable && this.numOfConcurrentConsumers > 1) {
                throw new JMSConnectorException("Concurrent consumers are not allowed for non-durable topic connections");
            }
        }
        if ((connectionFacNatureParam = connectorConfig.get("connectionFactoryNature")) != null) {
            this.connectionFactoryNature = connectionFacNatureParam;
        }
    }

    @Override
    public void start() throws JMSConnectorException {
        this.startConsuming();
    }

    @Override
    public boolean stop() throws JMSConnectorException {
        this.closeAll();
        return true;
    }

    void closeAll() throws JMSConnectorException {
        Throwable exception = null;
        for (JMSMessageConsumer messageConsumer : this.messageConsumers) {
            try {
                messageConsumer.closeAll();
            }
            catch (JMSConnectorException e) {
                if (exception == null) {
                    exception = new JMSConnectorException("Error closing the consumers for service ", e);
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        this.messageConsumers = null;
        if (exception != null) {
            throw exception;
        }
    }

    void startConsuming() throws JMSConnectorException {
        try {
            if (this.jmsConnectionFactory == null) {
                this.jmsConnectionFactory = new JMSServerConnectionFactory(this.properties);
            }
            this.messageConsumers = new ArrayList<JMSMessageConsumer>();
            JMSMessageConsumerBuilder consumerBuilder = new JMSMessageConsumerBuilder(this.jmsConnectionFactory, this.jmsServerConnectorFuture, this.serviceId);
            consumerBuilder.setUseReceiver(this.useReceiver).setRetryInterval(this.retryInterval).setMaxRetryCount(this.maxRetryCount);
            for (int i = 0; i < this.numOfConcurrentConsumers; ++i) {
                this.messageConsumers.add(consumerBuilder.build());
            }
        }
        catch (JMSConnectorException e) {
            if (null == this.jmsConnectionFactory) {
                throw new JMSConnectorException("Cannot create the jms connection factory. please check the connection properties and re-deploy the jms service.", e);
            }
            throw e;
        }
    }
}

