/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.JMSConnectionResourceFactory;
import org.wso2.carbon.transport.jms.sender.sessionpool.SessionPoolFactory;
import org.wso2.carbon.transport.jms.sender.wrappers.ConnectionWrapper;
import org.wso2.carbon.transport.jms.sender.wrappers.SessionWrapper;

public class JMSClientConnectionFactory
extends JMSConnectionResourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(JMSClientConnectionFactory.class);
    private static final int poolWaitTimeout = 30000;
    private int maxNumberOfConnections = 5;
    private int maxSessionsPerConnection = 10;
    private boolean clientCaching = true;
    private List<ConnectionWrapper> connections = null;
    private GenericObjectPool<SessionWrapper> sessionPool = null;

    public JMSClientConnectionFactory(Properties properties, boolean isCached) throws JMSConnectorException {
        super(properties);
        this.clientCaching = isCached;
        if (properties.getProperty("connectionCount") != null) {
            try {
                this.maxNumberOfConnections = Integer.parseInt(properties.getProperty("connectionCount"));
            }
            catch (NumberFormatException ex) {
                logger.error("Non-integer value configured for JMS Client Connection count", (Throwable)ex);
            }
        }
        if (properties.getProperty("sessionCount") != null) {
            try {
                this.maxSessionsPerConnection = Integer.parseInt(properties.getProperty("sessionCount"));
            }
            catch (NumberFormatException ex) {
                logger.error("Non-integer value configured for JMS Client Sessions count", (Throwable)ex);
            }
        }
        if (this.clientCaching) {
            this.connections = new ArrayList<ConnectionWrapper>();
            this.initSessionPool();
        }
    }

    public int getMaxNumberOfConnections() {
        return this.maxNumberOfConnections;
    }

    public int getMaxSessionsPerConnection() {
        return this.maxSessionsPerConnection;
    }

    private void initSessionPool() {
        SessionPoolFactory sessionPoolFactory = new SessionPoolFactory(this);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(this.maxNumberOfConnections * this.maxSessionsPerConnection);
        config.setMaxIdle(this.maxNumberOfConnections * this.maxSessionsPerConnection);
        config.setBlockWhenExhausted(true);
        config.setMaxWaitMillis(30000L);
        this.sessionPool = new GenericObjectPool((PooledObjectFactory)sessionPoolFactory, config);
    }

    @Override
    public synchronized void notifyError(JMSException ex) {
        logger.error("Error occurred in JMS Client Connections. Re-initializing the resources. ", (Throwable)ex);
        try {
            this.closeJMSResources();
        }
        catch (JMSConnectorException e) {
            logger.error("Error closing connection after exception", (Throwable)e);
        }
        finally {
            this.connections.clear();
        }
        this.initSessionPool();
    }

    public List<ConnectionWrapper> getConnections() {
        return this.connections;
    }

    public SessionWrapper getSessionWrapper() throws Exception {
        return (SessionWrapper)this.sessionPool.borrowObject();
    }

    public void returnSessionWrapper(SessionWrapper sessionWrapper) {
        this.sessionPool.returnObject((Object)sessionWrapper);
    }

    public void closeJMSResources() throws JMSConnectorException {
        if (this.clientCaching) {
            this.sessionPool.clear();
            this.sessionPool.close();
            for (int i = 0; i < this.connections.size(); ++i) {
                try {
                    this.closeConnection(this.connections.get(i).getConnection());
                    continue;
                }
                catch (JMSException e) {
                    throw new JMSConnectorException("Error closing the connection.", e);
                }
            }
        }
    }

    public boolean isClientCaching() {
        return this.clientCaching;
    }

    @Override
    public Connection createConnection() throws JMSException {
        Connection connection = super.createConnection();
        connection.setExceptionListener((ExceptionListener)new JMSErrorListener());
        return connection;
    }

    @Override
    public XAConnection createXAConnection() throws JMSException {
        XAConnection xaConnection = super.createXAConnection();
        xaConnection.setExceptionListener((ExceptionListener)new JMSErrorListener());
        return xaConnection;
    }

    private class JMSErrorListener
    implements ExceptionListener {
        private JMSErrorListener() {
        }

        public void onException(JMSException e) {
            JMSClientConnectionFactory.this.notifyError(e);
        }
    }
}

