/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.sender;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.JMSClientConnectionFactory;

public class JMSConnectionFactoryManager {
    private static final Logger logger = LoggerFactory.getLogger(JMSConnectionFactoryManager.class);
    private static JMSConnectionFactoryManager jmsConnectionFactoryManager = new JMSConnectionFactoryManager();
    private Map<String, JMSClientConnectionFactory> connectionFactoryMap = new HashMap<String, JMSClientConnectionFactory>();

    private JMSConnectionFactoryManager() {
    }

    private static boolean equals(Object s1, Object s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    public static JMSConnectionFactoryManager getInstance() {
        return jmsConnectionFactoryManager;
    }

    public synchronized JMSClientConnectionFactory getJMSConnectionFactory(Properties properties) throws JMSConnectorException {
        JMSClientConnectionFactory jmsConnectionFactory;
        Iterator<String> it = this.connectionFactoryMap.keySet().iterator();
        if (!this.isCached(properties)) {
            return new JMSClientConnectionFactory(properties, Boolean.FALSE);
        }
        while (it.hasNext()) {
            jmsConnectionFactory = this.connectionFactoryMap.get(it.next());
            Properties facProperties = jmsConnectionFactory.getProperties();
            if (!JMSConnectionFactoryManager.equals(facProperties.getProperty("java.naming.factory.initial"), properties.get("java.naming.factory.initial")) || !JMSConnectionFactoryManager.equals(facProperties.getProperty("java.naming.provider.url"), properties.get("java.naming.provider.url")) || !JMSConnectionFactoryManager.equals(facProperties.getProperty("java.naming.security.principal"), properties.get("java.naming.security.principal")) || !JMSConnectionFactoryManager.equals(facProperties.getProperty("java.naming.security.credentials"), properties.get("java.naming.security.credentials")) || !JMSConnectionFactoryManager.equals(facProperties.getProperty("transport.jms.SessionAcknowledgement"), properties.get("transport.jms.SessionAcknowledgement")) || !JMSConnectionFactoryManager.equals(facProperties.getProperty("transport.jms.ConnectionFactoryType"), properties.get("transport.jms.ConnectionFactoryType"))) continue;
            return jmsConnectionFactory;
        }
        jmsConnectionFactory = new JMSClientConnectionFactory(properties, Boolean.TRUE);
        if (jmsConnectionFactory.isClientCaching()) {
            this.connectionFactoryMap.put(UUID.randomUUID().toString(), jmsConnectionFactory);
        }
        return jmsConnectionFactory;
    }

    private boolean isCached(Properties properties) {
        String cacheLevel = properties.getProperty("transport.jms.caching");
        if (null != cacheLevel && !cacheLevel.isEmpty()) {
            return Boolean.parseBoolean(cacheLevel);
        }
        return Boolean.TRUE;
    }
}

