/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.sender.sessionpool;

import java.util.List;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.JMSClientConnectionFactory;
import org.wso2.carbon.transport.jms.factory.JMSConnectionResourceFactory;
import org.wso2.carbon.transport.jms.sender.wrappers.ConnectionWrapper;
import org.wso2.carbon.transport.jms.sender.wrappers.SessionWrapper;
import org.wso2.carbon.transport.jms.sender.wrappers.XASessionWrapper;

public class SessionPoolFactory
extends BasePooledObjectFactory<SessionWrapper> {
    private static final Logger logger = LoggerFactory.getLogger(SessionPoolFactory.class);
    private JMSConnectionResourceFactory jmsConnectionFactory;

    public SessionPoolFactory(JMSConnectionResourceFactory jmsConnectionFactory) {
        this.jmsConnectionFactory = jmsConnectionFactory;
    }

    public synchronized SessionWrapper create() throws Exception {
        ConnectionWrapper connectionWrapper = null;
        SessionWrapper sessionWrapper = null;
        if (this.jmsConnectionFactory instanceof JMSClientConnectionFactory) {
            List<ConnectionWrapper> connectionWrappers = ((JMSClientConnectionFactory)this.jmsConnectionFactory).getConnections();
            if (!connectionWrappers.isEmpty() && connectionWrappers.get(connectionWrappers.size() - 1).getSessionCount().get() < ((JMSClientConnectionFactory)this.jmsConnectionFactory).getMaxSessionsPerConnection()) {
                connectionWrapper = connectionWrappers.get(connectionWrappers.size() - 1);
            }
            if (connectionWrapper == null) {
                connectionWrapper = this.jmsConnectionFactory.isxATransacted() ? new ConnectionWrapper((Connection)this.jmsConnectionFactory.createXAConnection()) : new ConnectionWrapper(this.jmsConnectionFactory.createConnection());
                connectionWrappers.add(connectionWrapper);
            }
            if (this.jmsConnectionFactory.isxATransacted()) {
                XASession xASession = this.jmsConnectionFactory.createXASession((XAConnection)connectionWrapper.getConnection());
                sessionWrapper = new XASessionWrapper(xASession, xASession.getSession(), this.jmsConnectionFactory.createMessageProducer(xASession.getSession()));
            } else {
                Session session = this.jmsConnectionFactory.createSession(connectionWrapper.getConnection());
                sessionWrapper = new SessionWrapper(session, this.jmsConnectionFactory.createMessageProducer(session));
            }
            connectionWrapper.incrementSessionCount();
        }
        return sessionWrapper;
    }

    public PooledObject<SessionWrapper> wrap(SessionWrapper sessionWrapper) {
        return new DefaultPooledObject((Object)sessionWrapper);
    }

    public void destroyObject(PooledObject<SessionWrapper> sessionWrapper) throws Exception {
        try {
            ((SessionWrapper)sessionWrapper.getObject()).getMessageProducer().close();
            ((SessionWrapper)sessionWrapper.getObject()).getSession().close();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error when closing the JMS session/producer", e);
        }
    }
}

