/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.callback;

import java.util.concurrent.CountDownLatch;
import javax.jms.JMSException;
import javax.jms.Session;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;

public abstract class JMSCallback {
    private Session session;
    private boolean operationComplete = false;
    private boolean success;
    private CountDownLatch countDownLatch = new CountDownLatch(1);

    public JMSCallback(Session session) {
        this.session = session;
    }

    public boolean isOperationComplete() {
        return this.operationComplete;
    }

    protected void commitSession() throws JMSConnectorException {
        try {
            this.session.commit();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error while committing the session.");
        }
    }

    protected void rollbackSession() throws JMSConnectorException {
        try {
            this.session.rollback();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error while rolling back the session.", e);
        }
    }

    protected void recoverSession() throws JMSConnectorException {
        try {
            this.session.recover();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error while recovering the JMS session", e);
        }
    }

    public void done(boolean success) {
        this.success = success;
        this.countDownLatch.countDown();
    }

    public abstract int getAcknowledgementMode();

    protected boolean isSuccess() {
        return this.success;
    }

    public void waitForProcessing() throws InterruptedException {
        this.countDownLatch.await();
    }
}

