/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.factory;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.utils.StringUtils;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.JMSConnectionResourceFactory;
import org.wso2.carbon.transport.jms.utils.JMSConstants;

public class JMSServerConnectionFactory
extends JMSConnectionResourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(JMSServerConnectionFactory.class);
    private String destinationName;
    private Destination destination;
    private boolean isDurable;
    private boolean noPubSubLocal;
    private String subscriptionName;
    private String messageSelector;
    private boolean isSharedSubscription;

    public JMSServerConnectionFactory(Properties properties) throws JMSConnectorException {
        super(properties);
        this.isSharedSubscription = Boolean.parseBoolean(properties.getProperty("transport.jms.SharedSubscription"));
        this.noPubSubLocal = Boolean.valueOf(properties.getProperty("transport.jms.PubSubNoLocal"));
        this.subscriptionName = properties.getProperty("transport.jms.DurableSubscriberName");
        if (this.isSharedSubscription && this.subscriptionName == null) {
            logger.warn("Subscription name is not given. Therefore declaring a non-shared subscription");
            this.isSharedSubscription = false;
        }
        this.isDurable = !StringUtils.isNullOrEmptyAfterTrim((String)properties.getProperty("transport.jms.DurableSubscriberName"));
        String msgSelector = properties.getProperty("transport.jms.MessageSelector");
        if (null != msgSelector) {
            this.messageSelector = msgSelector;
        }
        this.destinationName = properties.getProperty("transport.jms.Destination");
    }

    @Override
    public Connection createConnection() throws JMSException {
        Connection connection = null;
        try {
            connection = super.createConnection();
            if (this.isDurable && !this.isSharedSubscription) {
                connection.setClientID(this.clientId);
            }
            return connection;
        }
        catch (JMSException e) {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (JMSException ex) {
                    logger.error("Error while closing the connection. ", (Throwable)ex);
                }
            }
            throw e;
        }
    }

    public MessageConsumer createMessageConsumer(Session session, Destination destination) throws JMSConnectorException {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating a JMS Message Consumer on: " + this.getConnectionFactoryString());
        }
        try {
            if ("2.0".equals(this.jmsSpec) && this.isSharedSubscription) {
                if (this.isDurable) {
                    return session.createSharedDurableConsumer((Topic)destination, this.subscriptionName, this.messageSelector);
                }
                return session.createSharedConsumer((Topic)destination, this.subscriptionName, this.messageSelector);
            }
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec) && !this.isSharedSubscription) {
                if (this.isDurable) {
                    return session.createDurableSubscriber((Topic)destination, this.subscriptionName, this.messageSelector, this.noPubSubLocal);
                }
                return session.createConsumer(destination, this.messageSelector);
            }
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                return ((QueueSession)session).createReceiver((Queue)destination, this.messageSelector);
            }
            if (this.isDurable) {
                return session.createDurableSubscriber((Topic)destination, this.subscriptionName, this.messageSelector, this.noPubSubLocal);
            }
            return ((TopicSession)session).createSubscriber((Topic)destination, this.messageSelector, false);
        }
        catch (Exception e) {
            throw new JMSConnectorException("JMS Exception while creating consumer for the destination " + this.destinationName, e);
        }
    }

    public Destination getDestination(Session session) throws JMSConnectorException {
        if (null != this.destination) {
            return this.destination;
        }
        return this.createDestination(session, this.destinationName);
    }
}

