/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.receiver;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.wso2.carbon.transport.jms.callback.AcknowledgementCallback;
import org.wso2.carbon.transport.jms.callback.TransactedSessionCallback;
import org.wso2.carbon.transport.jms.contract.JMSListener;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;

class JMSMessageHandler {
    private JMSListener jmsListener;
    private int acknowledgementMode;
    private Session session;

    JMSMessageHandler(JMSListener jmsListener, String serviceId, Session session) throws JMSConnectorException {
        this.jmsListener = jmsListener;
        this.session = session;
        try {
            this.acknowledgementMode = session.getAcknowledgeMode();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error retrieving acknowledgement mode", e);
        }
    }

    void handle(Message message) throws JMSConnectorException {
        try {
            switch (this.acknowledgementMode) {
                case 2: {
                    AcknowledgementCallback acknowledgementCallback = new AcknowledgementCallback(this.session, message);
                    this.jmsListener.onMessage(message, acknowledgementCallback);
                    acknowledgementCallback.waitForProcessing();
                    acknowledgementCallback.updateAcknowledgementStatus();
                    break;
                }
                case 0: {
                    TransactedSessionCallback transactedSessionCallback = new TransactedSessionCallback(this.session);
                    this.jmsListener.onMessage(message, transactedSessionCallback);
                    transactedSessionCallback.waitForProcessing();
                    transactedSessionCallback.updateTransactionStatus();
                    break;
                }
                default: {
                    this.jmsListener.onMessage(message, null);
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            throw new JMSConnectorException("Error waiting for the operation to complete", e);
        }
        catch (Exception e) {
            throw new JMSConnectorException("Error while getting the message from jms provider.", e);
        }
    }
}

