/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.ServerSideValidator;
import org.wso2.charon3.core.utils.CopyUtil;

public class ResourceTypeResourceManager
extends AbstractResourceManager {
    @Override
    public SCIMResponse get(String id, UserManager userManager, String attributes, String excludeAttributes) {
        return this.getResourceType();
    }

    private SCIMResponse getResourceType() {
        JSONEncoder encoder = null;
        try {
            encoder = ResourceTypeResourceManager.getEncoder();
            JSONDecoder decoder = ResourceTypeResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getResourceTypeResourceSchema();
            String scimUserObjectString = encoder.buildUserResourceTypeJsonBody();
            String scimGroupObjectString = encoder.buildGroupResourceTypeJsonBody();
            AbstractSCIMObject userResourceTypeObject = (AbstractSCIMObject)decoder.decodeResource(scimUserObjectString, schema, new AbstractSCIMObject());
            userResourceTypeObject = ServerSideValidator.validateResourceTypeSCIMObject(userResourceTypeObject);
            AbstractSCIMObject groupResourceTypeObject = (AbstractSCIMObject)decoder.decodeResource(scimGroupObjectString, schema, new AbstractSCIMObject());
            groupResourceTypeObject = ServerSideValidator.validateResourceTypeSCIMObject(groupResourceTypeObject);
            AbstractSCIMObject resourceTypeObject = this.buildCombinedResourceType(userResourceTypeObject, groupResourceTypeObject);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            if (resourceTypeObject == null) {
                String error = "Newly created User resource is null.";
                throw new InternalErrorException(error);
            }
            AbstractSCIMObject copiedObject = (AbstractSCIMObject)CopyUtil.deepCopy(resourceTypeObject);
            String encodedObject = encoder.encodeSCIMObject(copiedObject);
            responseHeaders.put("Location", ResourceTypeResourceManager.getResourceEndpointURL("/RESOURCE_TYPE"));
            responseHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedObject, responseHeaders);
        }
        catch (CharonException e) {
            return ResourceTypeResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return ResourceTypeResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return ResourceTypeResourceManager.encodeSCIMException(e);
        }
        catch (NotFoundException e) {
            return ResourceTypeResourceManager.encodeSCIMException(e);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public SCIMResponse create(String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ResourceTypeResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse delete(String id, UserManager userManager) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ResourceTypeResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, int startIndex, int count, String sortBy, String sortOrder, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ResourceTypeResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse listWithPOST(String resourceString, UserManager userManager) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ResourceTypeResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse updateWithPUT(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ResourceTypeResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ResourceTypeResourceManager.encodeSCIMException(badRequestException);
    }

    private AbstractSCIMObject buildCombinedResourceType(AbstractSCIMObject userObject, AbstractSCIMObject groupObject) throws CharonException {
        Map<String, Attribute> userObjectAttributeList = userObject.getAttributeList();
        Map<String, Attribute> groupObjectAttributeList = groupObject.getAttributeList();
        AbstractSCIMObject rootObject = new AbstractSCIMObject();
        MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute("resourceType");
        ComplexAttribute userComplexAttribute = new ComplexAttribute();
        for (Attribute attribute : userObjectAttributeList.values()) {
            userComplexAttribute.setSubAttribute(attribute);
        }
        multiValuedAttribute.setAttributeValue(userComplexAttribute);
        ComplexAttribute groupComplexAttribute = new ComplexAttribute();
        for (Attribute attribute : groupObjectAttributeList.values()) {
            groupComplexAttribute.setSubAttribute(attribute);
        }
        multiValuedAttribute.setAttributeValue(groupComplexAttribute);
        rootObject.setAttribute(multiValuedAttribute);
        rootObject.setSchema("urn:ietf:params:scim:schemas:core:2.0:ResourceType");
        return rootObject;
    }
}

