/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.util.HashMap;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.config.CharonConfiguration;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.utils.CopyUtil;

public class ServiceProviderConfigResourceManager
extends AbstractResourceManager {
    private static final Logger log = LoggerFactory.getLogger(ServiceProviderConfigResourceManager.class);

    @Override
    public SCIMResponse get(String id, UserManager userManager, String attributes, String excludeAttributes) {
        return this.getServiceProviderConfig();
    }

    private SCIMResponse getServiceProviderConfig() {
        JSONEncoder encoder = null;
        try {
            encoder = ServiceProviderConfigResourceManager.getEncoder();
            JSONDecoder decoder = ServiceProviderConfigResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getServiceProviderConfigResourceSchema();
            String scimObjectString = encoder.buildServiceProviderConfigJsonBody(CharonConfiguration.getInstance().getConfig());
            AbstractSCIMObject serviceProviderConfigObject = (AbstractSCIMObject)decoder.decodeResource(scimObjectString, schema, new AbstractSCIMObject());
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            if (serviceProviderConfigObject == null) {
                String error = "Newly created User resource is null.";
                throw new InternalErrorException(error);
            }
            AbstractSCIMObject copiedObject = (AbstractSCIMObject)CopyUtil.deepCopy(serviceProviderConfigObject);
            String encodedObject = encoder.encodeSCIMObject(copiedObject);
            responseHeaders.put("Location", ServiceProviderConfigResourceManager.getResourceEndpointURL("/ServiceProviderConfig"));
            responseHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedObject, responseHeaders);
        }
        catch (CharonException e) {
            return ServiceProviderConfigResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return ServiceProviderConfigResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return ServiceProviderConfigResourceManager.encodeSCIMException(e);
        }
        catch (NotFoundException e) {
            return ServiceProviderConfigResourceManager.encodeSCIMException(e);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public SCIMResponse create(String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ServiceProviderConfigResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse delete(String id, UserManager userManager) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ServiceProviderConfigResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, int startIndex, int count, String sortBy, String sortOrder, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ServiceProviderConfigResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse listWithPOST(String resourceString, UserManager userManager) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ServiceProviderConfigResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse updateWithPUT(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ServiceProviderConfigResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return ServiceProviderConfigResourceManager.encodeSCIMException(badRequestException);
    }
}

