/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.schema;

import java.util.Date;
import java.util.UUID;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.objects.User;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.schema.AbstractValidator;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.utils.AttributeUtil;

public class ServerSideValidator
extends AbstractValidator {
    public static void validateCreatedSCIMObject(AbstractSCIMObject scimObject, SCIMResourceTypeSchema resourceSchema) throws CharonException, BadRequestException, NotFoundException {
        if (scimObject instanceof User) {
            ServerSideValidator.setDisplayNameInComplexMultiValuedAttributes(scimObject, resourceSchema);
        }
        ServerSideValidator.removeAnyReadOnlyAttributes(scimObject, resourceSchema);
        String id = UUID.randomUUID().toString();
        scimObject.setId(id);
        Date date = new Date();
        scimObject.setCreatedDate(AttributeUtil.parseDateTime(AttributeUtil.formatDateTime(date)));
        scimObject.setLastModified(AttributeUtil.parseDateTime(AttributeUtil.formatDateTime(date)));
        if (resourceSchema.isSchemaAvailable("urn:ietf:params:scim:schemas:core:2.0:User").booleanValue()) {
            String location = ServerSideValidator.createLocationHeader(AbstractResourceManager.getResourceEndpointURL("/Users"), scimObject.getId());
            scimObject.setLocation(location);
            scimObject.setResourceType("User");
        } else if (resourceSchema.isSchemaAvailable("urn:ietf:params:scim:schemas:core:2.0:Group").booleanValue()) {
            String location = ServerSideValidator.createLocationHeader(AbstractResourceManager.getResourceEndpointURL("/Groups"), scimObject.getId());
            scimObject.setLocation(location);
            scimObject.setResourceType("Group");
        }
        ServerSideValidator.validateSCIMObjectForRequiredAttributes(scimObject, resourceSchema);
        ServerSideValidator.validateSchemaList(scimObject, resourceSchema);
    }

    private static String createLocationHeader(String location, String resourceID) {
        String locationString = location + "/" + resourceID;
        return locationString;
    }

    public static void validateRetrievedSCIMObjectInList(AbstractSCIMObject scimObject, SCIMResourceTypeSchema resourceSchema, String reuqestedAttributes, String requestedExcludingAttributes) throws BadRequestException, CharonException {
        ServerSideValidator.validateSCIMObjectForRequiredAttributes(scimObject, resourceSchema);
        ServerSideValidator.validateReturnedAttributes(scimObject, reuqestedAttributes, requestedExcludingAttributes);
    }

    public static void validateRetrievedSCIMObject(AbstractSCIMObject scimObject, SCIMResourceTypeSchema resourceSchema, String reuqestedAttributes, String requestedExcludingAttributes) throws BadRequestException, CharonException {
        ServerSideValidator.validateSCIMObjectForRequiredAttributes(scimObject, resourceSchema);
        ServerSideValidator.validateReturnedAttributes(scimObject, reuqestedAttributes, requestedExcludingAttributes);
        ServerSideValidator.validateSchemaList(scimObject, resourceSchema);
    }

    public static AbstractSCIMObject validateUpdatedSCIMObject(AbstractSCIMObject oldObject, AbstractSCIMObject newObject, SCIMResourceTypeSchema resourceSchema) throws CharonException, BadRequestException {
        AbstractSCIMObject validatedObject = null;
        if (newObject instanceof User) {
            ServerSideValidator.setDisplayNameInComplexMultiValuedAttributes(newObject, resourceSchema);
        }
        validatedObject = ServerSideValidator.checkIfReadOnlyAndImmutableAttributesModified(oldObject, newObject, resourceSchema);
        validatedObject.setAttribute(oldObject.getAttribute("meta"));
        validatedObject.setAttribute(oldObject.getAttribute("id"));
        Date date = new Date();
        validatedObject.setLastModified(date);
        ServerSideValidator.validateSCIMObjectForRequiredAttributes(newObject, resourceSchema);
        ServerSideValidator.validateSchemaList(validatedObject, resourceSchema);
        return validatedObject;
    }

    public static AbstractSCIMObject validateResourceTypeSCIMObject(AbstractSCIMObject scimObject) throws NotFoundException, BadRequestException, CharonException {
        String endpoint = (String)((SimpleAttribute)scimObject.getAttribute("name")).getValue();
        String location = ServerSideValidator.createLocationHeader(AbstractResourceManager.getResourceEndpointURL("/RESOURCE_TYPE"), endpoint);
        scimObject.setLocation(location);
        scimObject.setResourceType("ResourceType");
        return scimObject;
    }
}

