/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMAttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;

public class AttributeUtil {
    public static Object getAttributeValueFromString(Object attributeValue, SCIMDefinitions.DataType dataType) throws CharonException, BadRequestException {
        if (attributeValue == null) {
            return attributeValue;
        }
        String attributeStringValue = null;
        if (!(attributeValue instanceof Boolean)) {
            attributeStringValue = attributeValue instanceof Integer ? String.valueOf(attributeValue) : (attributeValue instanceof Double ? String.valueOf(attributeValue) : (String)attributeValue);
        }
        switch (dataType) {
            case STRING: {
                return attributeStringValue.trim();
            }
            case BOOLEAN: {
                return AttributeUtil.parseBoolean(attributeValue);
            }
            case DECIMAL: {
                return Double.parseDouble(attributeStringValue);
            }
            case INTEGER: {
                return Integer.parseInt(attributeStringValue);
            }
            case DATE_TIME: {
                return AttributeUtil.parseDateTime(attributeStringValue);
            }
            case BINARY: {
                return Byte.valueOf(attributeStringValue);
            }
            case REFERENCE: {
                return AttributeUtil.parseReference(attributeStringValue);
            }
            case COMPLEX: {
                return AttributeUtil.parseComplex(attributeStringValue);
            }
        }
        return null;
    }

    public static String getStringValueOfAttribute(Object attributeValue, SCIMDefinitions.DataType dataType) throws CharonException {
        switch (dataType) {
            case STRING: {
                return String.valueOf(attributeValue);
            }
            case BOOLEAN: {
                return String.valueOf(attributeValue);
            }
            case DECIMAL: {
                return String.valueOf(attributeValue);
            }
            case INTEGER: {
                return String.valueOf(attributeValue);
            }
            case DATE_TIME: {
                return AttributeUtil.formatDateTime((Date)attributeValue);
            }
            case BINARY: {
                return String.valueOf(attributeValue);
            }
            case REFERENCE: {
                return String.valueOf(attributeValue);
            }
            case COMPLEX: {
                return String.valueOf(attributeValue);
            }
        }
        throw new CharonException("Error in converting attribute value of type: " + (Object)((Object)dataType) + " to string.");
    }

    public static Date parseDateTime(String dateTimeString) throws CharonException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            return sdf.parse(dateTimeString);
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                return sdf.parse(dateTimeString);
            }
            catch (ParseException e1) {
                throw new CharonException("Error in parsing date time. Date time should adhere to the format: yyyy-MM-dd'T'HH:mm:ss'Z'", e1);
            }
        }
    }

    public static String parseReference(String referenceString) throws CharonException {
        return referenceString;
    }

    public static String parseComplex(String complexString) {
        return complexString;
    }

    public static String formatDateTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String formattedDate = sdf.format(date);
        return formattedDate;
    }

    public static Boolean parseBoolean(Object booleanValue) throws BadRequestException {
        try {
            return (Boolean)booleanValue;
        }
        catch (Exception e) {
            return Boolean.parseBoolean((String)booleanValue);
        }
    }

    public static String getAttributeURI(String attributeName, SCIMResourceTypeSchema schema) throws BadRequestException {
        for (AttributeSchema attributeSchema : schema.getAttributesList()) {
            if (attributeSchema.getName().equalsIgnoreCase(attributeName) || attributeSchema.getURI().equals(attributeName)) {
                return attributeSchema.getURI();
            }
            String subAttributeURI = AttributeUtil.checkSCIMSubAttributeURIs(((SCIMAttributeSchema)attributeSchema).getSubAttributeSchemas(), attributeSchema, attributeName);
            if (subAttributeURI != null) {
                return subAttributeURI;
            }
            if (!attributeName.contains(attributeSchema.getName()) || !attributeSchema.getMultiValued()) continue;
            String subAttribute = null;
            if (attributeName.contains(".")) {
                String[] splittedString = attributeName.split("\\.", 2);
                subAttribute = splittedString[1];
            }
            subAttributeURI = attributeSchema.getURI();
            if (subAttribute == null) continue;
            subAttributeURI = subAttributeURI + "." + subAttribute;
            return subAttributeURI;
        }
        String error = "Not a valid attribute name/uri";
        throw new BadRequestException(error, "invalidValue");
    }

    private static String checkSCIMSubAttributeURIs(List<SCIMAttributeSchema> subAttributes, AttributeSchema attributeSchema, String attributeName) {
        if (subAttributes != null) {
            for (SCIMAttributeSchema subAttributeSchema : subAttributes) {
                List<SCIMAttributeSchema> subSubAttributeSchemas;
                if ((attributeSchema.getName() + "." + subAttributeSchema.getName()).equalsIgnoreCase(attributeName) || subAttributeSchema.getURI().equals(attributeName)) {
                    return subAttributeSchema.getURI();
                }
                if (!subAttributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX) || (subSubAttributeSchemas = subAttributeSchema.getSubAttributeSchemas()) == null) continue;
                for (SCIMAttributeSchema subSubAttributeSchema : subSubAttributeSchemas) {
                    if (!(attributeSchema.getName() + "." + subAttributeSchema.getName() + "." + subSubAttributeSchema.getName()).equalsIgnoreCase(attributeName) && !subAttributeSchema.getURI().equals(attributeName)) continue;
                    return subSubAttributeSchema.getURI();
                }
            }
        }
        return null;
    }
}

