/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.attributes.AbstractAttribute;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.ResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMAttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.utils.CopyUtil;

public abstract class AbstractValidator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractValidator.class);

    public static void validateSCIMObjectForRequiredAttributes(AbstractSCIMObject scimObject, ResourceTypeSchema resourceSchema) throws BadRequestException, CharonException {
        ArrayList<AttributeSchema> attributeSchemaList = resourceSchema.getAttributesList();
        Map<String, Attribute> attributeList = scimObject.getAttributeList();
        for (AttributeSchema attributeSchema : attributeSchemaList) {
            if (attributeSchema.getRequired() && !attributeList.containsKey(attributeSchema.getName())) {
                String error = "Required attribute " + attributeSchema.getName() + " is missing in the SCIM " + "Object.";
                throw new BadRequestException(error, "invalidValue");
            }
            AbstractAttribute attribute = (AbstractAttribute)attributeList.get(attributeSchema.getName());
            AbstractValidator.validateSCIMObjectForRequiredSubAttributes(attribute, attributeSchema);
        }
    }

    private static void validateSCIMObjectForRequiredSubAttributes(AbstractAttribute attribute, AttributeSchema attributeSchema) throws CharonException, BadRequestException {
        List<SCIMAttributeSchema> subAttributesSchemaList;
        if (attribute != null && (subAttributesSchemaList = ((SCIMAttributeSchema)attributeSchema).getSubAttributeSchemas()) != null) {
            for (SCIMAttributeSchema subAttributeSchema : subAttributesSchemaList) {
                List<SCIMAttributeSchema> subSubAttributesSchemaList;
                if (subAttributeSchema.getRequired()) {
                    if (attribute instanceof ComplexAttribute) {
                        if (attribute.getSubAttribute(subAttributeSchema.getName()) == null) {
                            String error = "Required sub attribute: " + subAttributeSchema.getName() + " is missing in the SCIM Attribute: " + attribute.getName();
                            throw new BadRequestException(error, "invalidValue");
                        }
                    } else if (attribute instanceof MultiValuedAttribute) {
                        List<Attribute> values = ((MultiValuedAttribute)attribute).getAttributeValues();
                        for (Attribute value : values) {
                            if (!(value instanceof ComplexAttribute) || value.getSubAttribute(subAttributeSchema.getName()) != null) continue;
                            String error = "Required sub attribute: " + subAttributeSchema.getName() + ", is missing in the SCIM Attribute: " + attribute.getName();
                            throw new BadRequestException(error, "invalidValue");
                        }
                    }
                }
                AbstractAttribute subAttribute = null;
                if (attribute instanceof ComplexAttribute) {
                    subAttribute = (AbstractAttribute)((ComplexAttribute)attribute).getSubAttribute(subAttributeSchema.getName());
                } else if (attribute instanceof MultiValuedAttribute) {
                    List<Attribute> subAttributeList = ((MultiValuedAttribute)attribute).getAttributeValues();
                    for (Attribute subAttrbte : subAttributeList) {
                        if (!subAttrbte.getName().equals(subAttributeSchema.getName())) continue;
                        subAttribute = (AbstractAttribute)subAttrbte;
                    }
                }
                if ((subSubAttributesSchemaList = subAttributeSchema.getSubAttributeSchemas()) == null) continue;
                AbstractValidator.validateSCIMObjectForRequiredSubAttributes(subAttribute, subAttributeSchema);
            }
        }
    }

    public static void validateSchemaList(AbstractSCIMObject scimObject, SCIMResourceTypeSchema resourceSchema) throws CharonException {
        List<String> resourceSchemaList = resourceSchema.getSchemasList();
        List<String> objectSchemaList = scimObject.getSchemaList();
        for (String schema : resourceSchemaList) {
            if (objectSchemaList.contains(schema)) continue;
            throw new CharonException("Not all schemas are set");
        }
    }

    public static void removeAnyReadOnlyAttributes(AbstractSCIMObject scimObject, SCIMResourceTypeSchema resourceSchema) throws CharonException {
        ArrayList<AttributeSchema> attributeSchemaList = resourceSchema.getAttributesList();
        Map<String, Attribute> attributeList = scimObject.getAttributeList();
        for (AttributeSchema attributeSchema : attributeSchemaList) {
            if (attributeSchema.getMutability() == SCIMDefinitions.Mutability.READ_ONLY && attributeList.containsKey(attributeSchema.getName())) {
                String error = "Read only attribute: " + attributeSchema.getName() + " is set from consumer in the SCIM Object. " + "Removing it.";
                logger.debug(error);
                scimObject.deleteAttribute(attributeSchema.getName());
            }
            AbstractAttribute attribute = (AbstractAttribute)attributeList.get(attributeSchema.getName());
            AbstractValidator.removeAnyReadOnlySubAttributes(attribute, attributeSchema);
        }
    }

    private static void removeAnyReadOnlySubAttributes(Attribute attribute, AttributeSchema attributeSchema) throws CharonException {
        List<SCIMAttributeSchema> subAttributesSchemaList;
        if (attribute != null && (subAttributesSchemaList = ((SCIMAttributeSchema)attributeSchema).getSubAttributeSchemas()) != null && !subAttributesSchemaList.isEmpty()) {
            for (SCIMAttributeSchema subAttributeSchema : subAttributesSchemaList) {
                if (subAttributeSchema.getMutability() == SCIMDefinitions.Mutability.READ_ONLY) {
                    if (attribute instanceof ComplexAttribute) {
                        if (attribute.getSubAttribute(subAttributeSchema.getName()) != null) {
                            String error = "Readonly sub attribute: " + subAttributeSchema.getName() + " is set in the SCIM Attribute: " + attribute.getName() + ". Removing it.";
                            logger.debug(error);
                            ((ComplexAttribute)attribute).removeSubAttribute(subAttributeSchema.getName());
                        }
                    } else if (attribute instanceof MultiValuedAttribute) {
                        List<Attribute> values = ((MultiValuedAttribute)attribute).getAttributeValues();
                        for (Attribute value : values) {
                            if (!(value instanceof ComplexAttribute) || value.getSubAttribute(subAttributeSchema.getName()) == null) continue;
                            String error = "Readonly sub attribute: " + subAttributeSchema.getName() + " is set in the SCIM Attribute: " + attribute.getName() + ". Removing it.";
                            logger.debug(error);
                            ((ComplexAttribute)value).removeSubAttribute(subAttributeSchema.getName());
                        }
                    }
                }
                if (!subAttributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) continue;
                Map<String, Attribute> subAttributeList = ((ComplexAttribute)attribute).getSubAttributesList();
                for (Attribute subSubAttribute : subAttributeList.values()) {
                    AbstractValidator.removeAnyReadOnlySubAttributes(subSubAttribute, subAttributeSchema);
                }
            }
        }
    }

    public static void validateReturnedAttributes(AbstractSCIMObject scimObject, String requestedAttributes, String requestedExcludingAttributes) throws CharonException {
        List<String> requestedAttributesList = null;
        List<String> requestedExcludingAttributesList = null;
        if (requestedAttributes != null) {
            requestedAttributesList = Arrays.asList(requestedAttributes.split(","));
        }
        if (requestedExcludingAttributes != null) {
            requestedExcludingAttributesList = Arrays.asList(requestedExcludingAttributes.split(","));
        }
        Map<String, Attribute> attributeList = scimObject.getAttributeList();
        ArrayList<Attribute> attributeTemporyList = new ArrayList<Attribute>();
        for (Attribute attribute : attributeList.values()) {
            attributeTemporyList.add(attribute);
        }
        for (Attribute attribute : attributeTemporyList) {
            if (attribute.getReturned().equals((Object)SCIMDefinitions.Returned.NEVER)) {
                scimObject.deleteAttribute(attribute.getName());
            }
            if (requestedAttributes == null && requestedExcludingAttributes == null) {
                if (attribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                    scimObject.deleteAttribute(attribute.getName());
                }
            } else if (requestedAttributes != null) {
                if ((attribute.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) || attribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) && !requestedAttributesList.contains(attribute.getName()) && !AbstractValidator.isSubAttributeExistsInList(requestedAttributesList, attribute)) {
                    scimObject.deleteAttribute(attribute.getName());
                }
            } else if (requestedExcludingAttributes != null) {
                if (attribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                    scimObject.deleteAttribute(attribute.getName());
                }
                if (attribute.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && requestedExcludingAttributesList.contains(attribute.getName())) {
                    scimObject.deleteAttribute(attribute.getName());
                }
            }
            if (!attribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) continue;
            if (attribute.getMultiValued().booleanValue()) {
                List<Attribute> valuesList = ((MultiValuedAttribute)attribute).getAttributeValues();
                for (Attribute subAttribute : valuesList) {
                    Map<String, Attribute> valuesSubAttributeList = ((ComplexAttribute)subAttribute).getSubAttributesList();
                    ArrayList<Attribute> valuesSubAttributeTemporyList = new ArrayList<Attribute>();
                    for (Attribute subSimpleAttribute : valuesSubAttributeList.values()) {
                        valuesSubAttributeTemporyList.add(subSimpleAttribute);
                    }
                    for (Attribute subSimpleAttribute : valuesSubAttributeTemporyList) {
                        AbstractValidator.removeValuesSubAttributeOnReturn(subSimpleAttribute, subAttribute, attribute, requestedAttributes, requestedExcludingAttributes, requestedAttributesList, requestedExcludingAttributesList, scimObject);
                    }
                }
                continue;
            }
            Map<String, Attribute> subAttributeList = ((ComplexAttribute)attribute).getSubAttributesList();
            ArrayList<Attribute> subAttributeTemporyList = new ArrayList<Attribute>();
            for (Attribute subAttribute : subAttributeList.values()) {
                subAttributeTemporyList.add(subAttribute);
            }
            for (Attribute subAttribute : subAttributeTemporyList) {
                if (subAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                    if (subAttribute.getMultiValued().booleanValue()) {
                        List<Attribute> valuesList = ((MultiValuedAttribute)subAttribute).getAttributeValues();
                        for (Attribute subSubValue : valuesList) {
                            Map<String, Attribute> subValuesSubAttributeList = ((ComplexAttribute)subSubValue).getSubAttributesList();
                            ArrayList<Attribute> valuesSubSubAttributeTemporyList = new ArrayList<Attribute>();
                            for (Attribute subSubSimpleAttribute : subValuesSubAttributeList.values()) {
                                valuesSubSubAttributeTemporyList.add(subSubSimpleAttribute);
                            }
                            for (Attribute subSubSimpleAttribute : valuesSubSubAttributeTemporyList) {
                                AbstractValidator.removeValuesSubSubAttributeOnReturn(attribute, subAttribute, subSubValue, subSubSimpleAttribute, requestedAttributes, requestedExcludingAttributes, requestedAttributesList, requestedExcludingAttributesList, scimObject);
                            }
                        }
                    } else {
                        ArrayList<Attribute> subSubAttributeTemporyList = new ArrayList<Attribute>();
                        Map<String, Attribute> subSubAttributeList = ((ComplexAttribute)subAttribute).getSubAttributesList();
                        for (Attribute subSubAttribute : subSubAttributeList.values()) {
                            subSubAttributeTemporyList.add(subSubAttribute);
                        }
                        for (Attribute subSubAttribute : subSubAttributeTemporyList) {
                            AbstractValidator.removeSubSubAttributesOnReturn(attribute, subAttribute, subSubAttribute, requestedAttributes, requestedExcludingAttributes, requestedAttributesList, requestedExcludingAttributesList, scimObject);
                        }
                    }
                    AbstractValidator.removeSubAttributesOnReturn(subAttribute, attribute, requestedAttributes, requestedExcludingAttributes, requestedAttributesList, requestedExcludingAttributesList, scimObject);
                    continue;
                }
                AbstractValidator.removeSubAttributesOnReturn(subAttribute, attribute, requestedAttributes, requestedExcludingAttributes, requestedAttributesList, requestedExcludingAttributesList, scimObject);
            }
        }
    }

    private static void removeSubAttributesOnReturn(Attribute subAttribute, Attribute attribute, String requestedAttributes, String requestedExcludingAttributes, List<String> requestedAttributesList, List<String> requestedExcludingAttributesList, AbstractSCIMObject scimObject) {
        if (subAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.NEVER)) {
            scimObject.deleteSubAttribute(attribute.getName(), subAttribute.getName());
        }
        if (requestedAttributes == null && requestedExcludingAttributes == null) {
            if (subAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                scimObject.deleteSubAttribute(attribute.getName(), subAttribute.getName());
            }
        } else if (requestedAttributes != null) {
            if (!(!subAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && !subAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST) || requestedAttributesList.contains(attribute.getName() + "." + subAttribute.getName()) || requestedAttributesList.contains(attribute.getName()) || AbstractValidator.isSubSubAttributeExistsInList(requestedAttributesList, attribute, subAttribute))) {
                scimObject.deleteSubAttribute(attribute.getName(), subAttribute.getName());
            }
        } else if (requestedExcludingAttributes != null) {
            if (subAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                scimObject.deleteSubAttribute(attribute.getName(), subAttribute.getName());
            }
            if (subAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && requestedExcludingAttributesList.contains(attribute.getName() + "." + subAttribute.getName())) {
                scimObject.deleteSubAttribute(attribute.getName(), subAttribute.getName());
            }
        }
    }

    private static void removeSubSubAttributesOnReturn(Attribute attribute, Attribute subAttribute, Attribute subSubAttribute, String requestedAttributes, String requestedExcludingAttributes, List<String> requestedAttributesList, List<String> requestedExcludingAttributesList, AbstractSCIMObject scimObject) throws CharonException {
        if (subSubAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.NEVER)) {
            scimObject.deleteSubSubAttribute(subSubAttribute.getName(), subAttribute.getName(), attribute.getName());
        }
        if (requestedAttributes == null && requestedExcludingAttributes == null) {
            if (subSubAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                scimObject.deleteSubSubAttribute(subSubAttribute.getName(), subAttribute.getName(), attribute.getName());
            }
        } else if (requestedAttributes != null) {
            if (!(!subSubAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && !subSubAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST) || requestedAttributesList.contains(attribute.getName() + "." + subAttribute.getName() + "." + subSubAttribute.getName()) || requestedAttributesList.contains(attribute.getName()) || requestedAttributesList.contains(attribute.getName() + "." + subAttribute.getName()) || subSubAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.ALWAYS))) {
                scimObject.deleteSubSubAttribute(subSubAttribute.getName(), subAttribute.getName(), attribute.getName());
            }
        } else if (requestedExcludingAttributes != null) {
            if (subSubAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                scimObject.deleteSubSubAttribute(subSubAttribute.getName(), subAttribute.getName(), attribute.getName());
            }
            if (subSubAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && requestedExcludingAttributesList.contains(attribute.getName() + "." + subAttribute.getName() + "." + subSubAttribute.getName())) {
                scimObject.deleteSubSubAttribute(subSubAttribute.getName(), subAttribute.getName(), attribute.getName());
            }
        }
    }

    private static void removeValuesSubAttributeOnReturn(Attribute subSimpleAttribute, Attribute subAttribute, Attribute attribute, String requestedAttributes, String requestedExcludingAttributes, List<String> requestedAttributesList, List<String> requestedExcludingAttributesList, AbstractSCIMObject scimObject) {
        if (subSimpleAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.NEVER)) {
            scimObject.deleteValuesSubAttribute(attribute.getName(), subAttribute.getName(), subSimpleAttribute.getName());
        }
        if (requestedAttributes == null && requestedExcludingAttributes == null) {
            if (attribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                scimObject.deleteValuesSubAttribute(attribute.getName(), subAttribute.getName(), subSimpleAttribute.getName());
            }
        } else if (requestedAttributes != null) {
            if (!(!subSimpleAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && !subSimpleAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST) || requestedAttributesList.contains(attribute.getName() + "." + subSimpleAttribute.getName()) || requestedAttributesList.contains(attribute.getName()) || AbstractValidator.isSubSubAttributeExistsInList(requestedAttributesList, attribute, subSimpleAttribute))) {
                scimObject.deleteValuesSubAttribute(attribute.getName(), subAttribute.getName(), subSimpleAttribute.getName());
            }
        } else if (requestedExcludingAttributes != null) {
            if (subSimpleAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                scimObject.deleteValuesSubAttribute(attribute.getName(), subAttribute.getName(), subSimpleAttribute.getName());
            }
            if (subSimpleAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && requestedExcludingAttributesList.contains(attribute.getName() + "." + subSimpleAttribute.getName())) {
                scimObject.deleteValuesSubAttribute(attribute.getName(), subAttribute.getName(), subSimpleAttribute.getName());
            }
        }
    }

    private static void removeValuesSubSubAttributeOnReturn(Attribute attribute, Attribute subAttribute, Attribute subValue, Attribute subSimpleAttribute, String requestedAttributes, String requestedExcludingAttributes, List<String> requestedAttributesList, List<String> requestedExcludingAttributesList, AbstractSCIMObject scimObject) {
        if (subSimpleAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.NEVER)) {
            scimObject.deleteSubValuesSubAttribute(attribute.getName(), subAttribute.getName(), subValue.getName(), subSimpleAttribute.getName());
        }
        if (requestedAttributes == null && requestedExcludingAttributes == null) {
            if (attribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                scimObject.deleteSubValuesSubAttribute(attribute.getName(), subAttribute.getName(), subValue.getName(), subSimpleAttribute.getName());
            }
        } else if (requestedAttributes != null) {
            if (!(!subSimpleAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && !subSimpleAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST) || requestedAttributesList.contains(attribute.getName() + "." + subAttribute.getName() + "." + subSimpleAttribute.getName()) || requestedAttributesList.contains(attribute.getName()) || requestedAttributesList.contains(attribute.getName() + "." + subAttribute.getName()))) {
                scimObject.deleteSubValuesSubAttribute(attribute.getName(), subAttribute.getName(), subValue.getName(), subSimpleAttribute.getName());
            }
        } else if (requestedExcludingAttributes != null) {
            if (subSimpleAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                scimObject.deleteSubValuesSubAttribute(attribute.getName(), subAttribute.getName(), subValue.getName(), subSimpleAttribute.getName());
            }
            if (subSimpleAttribute.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && requestedExcludingAttributesList.contains(attribute.getName() + "." + subAttribute.getName() + "." + subSimpleAttribute.getName())) {
                scimObject.deleteSubValuesSubAttribute(attribute.getName(), subAttribute.getName(), subValue.getName(), subSimpleAttribute.getName());
            }
        }
    }

    private static boolean isSubAttributeExistsInList(List<String> requestedAttributes, Attribute attribute) {
        block6: {
            List<Attribute> subAttributes;
            block5: {
                subAttributes = null;
                if (!(attribute instanceof MultiValuedAttribute)) break block5;
                subAttributes = ((MultiValuedAttribute)attribute).getAttributeValues();
                if (subAttributes == null) break block6;
                for (Attribute subAttribute : subAttributes) {
                    boolean isSubSubAttributeExists;
                    ArrayList<Attribute> subSimpleAttributes = new ArrayList<Attribute>(((ComplexAttribute)subAttribute).getSubAttributesList().values());
                    for (Attribute subSimpleAttribute : subSimpleAttributes) {
                        if (!requestedAttributes.contains(attribute.getName() + "." + subSimpleAttribute.getName())) continue;
                        return true;
                    }
                    if (!subAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX) || !(isSubSubAttributeExists = AbstractValidator.isSubSubAttributeExistsInList(requestedAttributes, attribute, subAttribute))) continue;
                    return true;
                }
                break block6;
            }
            if (attribute instanceof ComplexAttribute) {
                subAttributes = new ArrayList<Attribute>(((ComplexAttribute)attribute).getSubAttributesList().values());
                for (Attribute subAttribute : subAttributes) {
                    boolean isSubSubAttributeExists;
                    if (requestedAttributes.contains(attribute.getName() + "." + subAttribute.getName())) {
                        return true;
                    }
                    if (!subAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX) || !(isSubSubAttributeExists = AbstractValidator.isSubSubAttributeExistsInList(requestedAttributes, attribute, subAttribute))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isSubSubAttributeExistsInList(List<String> requestedAttributes, Attribute grandParentAttribute, Attribute parentAttribute) {
        block5: {
            List<Attribute> subAttributes;
            block4: {
                subAttributes = null;
                if (!(parentAttribute instanceof MultiValuedAttribute)) break block4;
                subAttributes = ((MultiValuedAttribute)parentAttribute).getAttributeValues();
                if (subAttributes == null) break block5;
                for (Attribute subAttribute : subAttributes) {
                    ArrayList<Attribute> subSimpleAttributes = new ArrayList<Attribute>(((ComplexAttribute)subAttribute).getSubAttributesList().values());
                    for (Attribute subSimpleAttribute : subSimpleAttributes) {
                        if (!requestedAttributes.contains(grandParentAttribute.getName() + "." + parentAttribute.getName() + "." + subSimpleAttribute.getName())) continue;
                        return true;
                    }
                }
                break block5;
            }
            if (parentAttribute instanceof ComplexAttribute) {
                subAttributes = new ArrayList<Attribute>(((ComplexAttribute)parentAttribute).getSubAttributesList().values());
                for (Attribute subAttribute : subAttributes) {
                    if (!requestedAttributes.contains(grandParentAttribute.getName() + "." + parentAttribute.getName() + "." + subAttribute.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected static AbstractSCIMObject checkIfReadOnlyAndImmutableAttributesModified(AbstractSCIMObject oldObject, AbstractSCIMObject newObject, SCIMResourceTypeSchema resourceSchema) throws BadRequestException, CharonException {
        ArrayList<AttributeSchema> attributeSchemaList = resourceSchema.getAttributesList();
        Map<String, Attribute> oldAttributeList = oldObject.getAttributeList();
        Map<String, Attribute> newAttributeList = newObject.getAttributeList();
        for (AttributeSchema attributeSchema : attributeSchemaList) {
            if (attributeSchema.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) {
                String error;
                if (newAttributeList.containsKey(attributeSchema.getName()) && oldAttributeList.containsKey(attributeSchema.getName())) {
                    error = "Read only attribute: " + attributeSchema.getName() + " is set from consumer in the SCIM Object. " + "Removing it and updating from previous value.";
                    logger.debug(error);
                    newObject.deleteAttribute(attributeSchema.getName());
                    newObject.setAttribute((Attribute)CopyUtil.deepCopy(oldObject.getAttribute(attributeSchema.getName())));
                } else if (newAttributeList.containsKey(attributeSchema.getName()) && !oldAttributeList.containsKey(attributeSchema.getName())) {
                    error = "Read only attribute: " + attributeSchema.getName() + " is set from consumer in the SCIM Object. " + "Removing it.";
                    logger.debug(error);
                    newObject.deleteAttribute(attributeSchema.getName());
                } else if (!newAttributeList.containsKey(attributeSchema.getName()) && oldAttributeList.containsKey(attributeSchema.getName())) {
                    newObject.setAttribute((Attribute)CopyUtil.deepCopy(oldObject.getAttribute(attributeSchema.getName())));
                }
            } else if (attributeSchema.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                if (newAttributeList.containsKey(attributeSchema.getName()) && oldAttributeList.containsKey(attributeSchema.getName())) {
                    AbstractValidator.checkForSameValues(oldAttributeList, newAttributeList, attributeSchema);
                } else if (!newAttributeList.containsKey(attributeSchema.getName()) && oldAttributeList.containsKey(attributeSchema.getName())) {
                    newObject.setAttribute((Attribute)CopyUtil.deepCopy(oldObject.getAttribute(attributeSchema.getName())));
                }
            }
            AbstractValidator.checkIfReadOnlyAndImmutableSubAttributesModified(newAttributeList, oldAttributeList, attributeSchema);
        }
        return newObject;
    }

    private static void checkIfReadOnlyAndImmutableSubAttributesModified(Map<String, Attribute> newAttributeList, Map<String, Attribute> oldAttributeList, AttributeSchema attributeSchema) throws BadRequestException, CharonException {
        block13: {
            List<SCIMAttributeSchema> subAttributeSchemaList;
            AbstractAttribute newAttribute;
            block16: {
                AbstractAttribute oldAttribute;
                block15: {
                    block14: {
                        newAttribute = (AbstractAttribute)newAttributeList.get(attributeSchema.getName());
                        oldAttribute = (AbstractAttribute)oldAttributeList.get(attributeSchema.getName());
                        subAttributeSchemaList = attributeSchema.getSubAttributeSchemas();
                        if (subAttributeSchemaList == null) break block13;
                        if (SCIMResourceSchemaManager.getInstance().getExtensionName() != null && attributeSchema.getName().equals(SCIMResourceSchemaManager.getInstance().getExtensionName())) {
                            AbstractValidator.checkIfReadOnlyAndImmutableExtensionAttributesModified(subAttributeSchemaList, newAttribute, oldAttribute);
                        }
                        if (newAttribute == null || oldAttribute == null) break block14;
                        if (attributeSchema.getMultiValued()) {
                            List<Attribute> newSubValuesList = ((MultiValuedAttribute)newAttribute).getAttributeValues();
                            List<Attribute> oldSubValuesList = ((MultiValuedAttribute)oldAttribute).getAttributeValues();
                            if (newSubValuesList.size() != oldSubValuesList.size() && attributeSchema.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                                throw new BadRequestException("mutability");
                            }
                            for (Attribute attribute : newSubValuesList) {
                                if (AbstractValidator.isListContains(((ComplexAttribute)attribute).getName(), oldSubValuesList) || !attributeSchema.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) continue;
                                throw new BadRequestException("mutability");
                            }
                        } else {
                            AbstractValidator.checkForReadOnlyAndImmutableInComplexAttributes(newAttribute, oldAttribute, subAttributeSchemaList);
                        }
                        break block13;
                    }
                    if (newAttribute != null || oldAttribute == null) break block15;
                    if (attributeSchema.getMultiValued()) {
                        List<Attribute> oldSubValuesList = ((MultiValuedAttribute)oldAttribute).getAttributeValues();
                        Attribute clonedMultiValuedAttribute = (Attribute)CopyUtil.deepCopy(oldAttribute);
                        clonedMultiValuedAttribute.deleteSubAttributes();
                        for (Attribute attribute : oldSubValuesList) {
                            Attribute attribute2 = (Attribute)CopyUtil.deepCopy(attribute);
                            attribute2.deleteSubAttributes();
                            for (AttributeSchema attributeSchema2 : subAttributeSchemaList) {
                                if (!attributeSchema2.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) && !attributeSchema2.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE) || !((ComplexAttribute)attribute).isSubAttributeExist(attributeSchema2.getName())) continue;
                                Attribute clonedSubValuesAttribute = (Attribute)CopyUtil.deepCopy(((ComplexAttribute)attribute).getSubAttribute(attributeSchema2.getName()));
                                ((ComplexAttribute)attribute2).setSubAttribute(clonedSubValuesAttribute);
                            }
                            ((MultiValuedAttribute)clonedMultiValuedAttribute).setAttributeValue(attribute2);
                        }
                    } else {
                        Map<String, Attribute> oldSubAttributeList = ((ComplexAttribute)oldAttribute).getSubAttributesList();
                        Attribute clonedAttribute = (Attribute)CopyUtil.deepCopy(oldAttribute);
                        clonedAttribute.deleteSubAttributes();
                        for (AttributeSchema attributeSchema3 : subAttributeSchemaList) {
                            if (!attributeSchema3.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) && !attributeSchema3.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE) || !oldSubAttributeList.containsKey(attributeSchema3.getName())) continue;
                            ((ComplexAttribute)clonedAttribute).setSubAttribute((Attribute)CopyUtil.deepCopy(oldSubAttributeList.get(attributeSchema3.getName())));
                        }
                        newAttributeList.put(clonedAttribute.getName(), clonedAttribute);
                    }
                    break block13;
                }
                if (newAttribute == null || oldAttribute != null) break block13;
                if (!attributeSchema.getMultiValued()) break block16;
                if (!attributeSchema.getMultiValued()) break block13;
                List<Attribute> newSubValuesList = ((MultiValuedAttribute)newAttribute).getAttributeValues();
                for (Attribute attribute : newSubValuesList) {
                    for (AttributeSchema attributeSchema4 : subAttributeSchemaList) {
                        if (!attributeSchema4.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) continue;
                        ((ComplexAttribute)attribute).removeSubAttribute(attributeSchema4.getName());
                    }
                }
                break block13;
            }
            Map<String, Attribute> newSubAttributeList = ((ComplexAttribute)newAttribute).getSubAttributesList();
            for (AttributeSchema attributeSchema5 : subAttributeSchemaList) {
                if (!attributeSchema5.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || !newSubAttributeList.containsKey(attributeSchema5.getName())) continue;
                String string = "Read only attribute: " + attributeSchema5.getName() + " is set from consumer in the SCIM Object. Removing it.";
                logger.debug(string);
                ((ComplexAttribute)newAttribute).removeSubAttribute(attributeSchema5.getName());
            }
        }
    }

    private static void checkIfReadOnlyAndImmutableExtensionAttributesModified(List<SCIMAttributeSchema> subAttributeSchemaList, AbstractAttribute newAttribute, AbstractAttribute oldAttribute) throws CharonException, BadRequestException {
        Map<Object, Object> newAttributeList = new HashMap();
        Map<Object, Object> oldAttributeList = new HashMap();
        if (newAttribute != null) {
            newAttributeList = ((ComplexAttribute)newAttribute).getSubAttributesList();
        }
        if (oldAttribute != null) {
            oldAttributeList = ((ComplexAttribute)oldAttribute).getSubAttributesList();
        }
        for (AttributeSchema attributeSchema : subAttributeSchemaList) {
            if (attributeSchema.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) {
                String error;
                if (newAttributeList.containsKey(attributeSchema.getName()) && oldAttributeList.containsKey(attributeSchema.getName())) {
                    error = "Read only attribute: " + attributeSchema.getName() + " is set from consumer in the SCIM Object. " + "Removing it and updating from previous value.";
                    logger.debug(error);
                    ((ComplexAttribute)newAttribute).removeSubAttribute(attributeSchema.getName());
                    ((ComplexAttribute)newAttribute).setSubAttribute((Attribute)CopyUtil.deepCopy(((ComplexAttribute)oldAttribute).getSubAttribute(attributeSchema.getName())));
                } else if (newAttributeList.containsKey(attributeSchema.getName()) && !oldAttributeList.containsKey(attributeSchema.getName())) {
                    error = "Read only attribute: " + attributeSchema.getName() + " is set from consumer in the SCIM Object. " + "Removing it.";
                    logger.debug(error);
                    ((ComplexAttribute)newAttribute).removeSubAttribute(attributeSchema.getName());
                } else if (!newAttributeList.containsKey(attributeSchema.getName()) && oldAttributeList.containsKey(attributeSchema.getName())) {
                    ((ComplexAttribute)newAttribute).setSubAttribute((Attribute)CopyUtil.deepCopy(((ComplexAttribute)oldAttribute).getSubAttribute(attributeSchema.getName())));
                }
            } else if (attributeSchema.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                if (newAttributeList.containsKey(attributeSchema.getName()) && oldAttributeList.containsKey(attributeSchema.getName())) {
                    AbstractValidator.checkForSameValues(oldAttributeList, newAttributeList, attributeSchema);
                } else if (!newAttributeList.containsKey(attributeSchema.getName()) && oldAttributeList.containsKey(attributeSchema.getName())) {
                    ((ComplexAttribute)newAttribute).setSubAttribute((Attribute)CopyUtil.deepCopy(((ComplexAttribute)oldAttribute).getSubAttribute(attributeSchema.getName())));
                }
            }
            if (!attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) continue;
            AbstractValidator.checkIfReadOnlyAndImmutableSubAttributesModified(newAttributeList, oldAttributeList, attributeSchema);
        }
    }

    private static boolean isListContains(String attributeName, List<Attribute> list) {
        for (Attribute attribute : list) {
            if (!attribute.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    private static void checkForSameValues(Map<String, Attribute> oldAttributeList, Map<String, Attribute> newAttributeList, AttributeSchema attributeSchema) throws BadRequestException {
        Attribute newTemporyAttribute = newAttributeList.get(attributeSchema.getName());
        Attribute oldTemporyAttribute = oldAttributeList.get(attributeSchema.getName());
        if (newTemporyAttribute instanceof SimpleAttribute ? !((SimpleAttribute)newTemporyAttribute).getValue().equals(((SimpleAttribute)oldTemporyAttribute).getValue()) : newTemporyAttribute instanceof MultiValuedAttribute && !attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX) && !AbstractValidator.checkListEquality(((MultiValuedAttribute)newTemporyAttribute).getAttributePrimitiveValues(), ((MultiValuedAttribute)oldTemporyAttribute).getAttributePrimitiveValues())) {
            throw new BadRequestException("mutability");
        }
    }

    private static boolean checkListEquality(List<Object> l1, List<Object> l2) {
        HashSet<Object> s1 = new HashSet<Object>(l1);
        HashSet<Object> s2 = new HashSet<Object>(l2);
        return s1.equals(s2);
    }

    private static void checkForReadOnlyAndImmutableInComplexAttributes(Attribute newAttribute, Attribute oldAttribute, List<SCIMAttributeSchema> subAttributeSchemaList) throws CharonException, BadRequestException {
        Map<String, Attribute> newSubAttributeList = ((ComplexAttribute)newAttribute).getSubAttributesList();
        Map<String, Attribute> oldSubAttributeList = ((ComplexAttribute)oldAttribute).getSubAttributesList();
        for (AttributeSchema attributeSchema : subAttributeSchemaList) {
            if (attributeSchema.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) {
                String error;
                if (newSubAttributeList.containsKey(attributeSchema.getName()) && oldSubAttributeList.containsKey(attributeSchema.getName())) {
                    error = "Read only attribute: " + attributeSchema.getName() + " is set from consumer in the SCIM Object. " + "Removing it and updating from previous value.";
                    logger.debug(error);
                    ((ComplexAttribute)newAttribute).removeSubAttribute(attributeSchema.getName());
                    ((ComplexAttribute)newAttribute).setSubAttribute((Attribute)CopyUtil.deepCopy(((ComplexAttribute)oldAttribute).getSubAttribute(attributeSchema.getName())));
                    continue;
                }
                if (newSubAttributeList.containsKey(attributeSchema.getName()) && !oldSubAttributeList.containsKey(attributeSchema.getName())) {
                    error = "Read only attribute: " + attributeSchema.getName() + " is set from consumer in the SCIM Object. " + "Removing it.";
                    logger.debug(error);
                    ((ComplexAttribute)newAttribute).removeSubAttribute(attributeSchema.getName());
                    continue;
                }
                if (newSubAttributeList.containsKey(attributeSchema.getName()) || !oldSubAttributeList.containsKey(attributeSchema.getName())) continue;
                ((ComplexAttribute)newAttribute).setSubAttribute((Attribute)CopyUtil.deepCopy(((ComplexAttribute)oldAttribute).getSubAttribute(attributeSchema.getName())));
                continue;
            }
            if (!attributeSchema.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) continue;
            if (newSubAttributeList.containsKey(attributeSchema.getName()) && oldSubAttributeList.containsKey(attributeSchema.getName())) {
                AbstractValidator.checkForSameValues(newSubAttributeList, oldSubAttributeList, attributeSchema);
                continue;
            }
            if (newSubAttributeList.containsKey(attributeSchema.getName()) || !oldSubAttributeList.containsKey(attributeSchema.getName())) continue;
            ((ComplexAttribute)newAttribute).setSubAttribute((Attribute)CopyUtil.deepCopy(((ComplexAttribute)oldAttribute).getSubAttribute(attributeSchema.getName())));
        }
    }

    protected static void setDisplayNameInComplexMultiValuedAttributes(AbstractSCIMObject scimObject, SCIMResourceTypeSchema resourceSchema) throws CharonException, BadRequestException {
        Map<String, Attribute> attributeList = scimObject.getAttributeList();
        ArrayList<AttributeSchema> attributeSchemaList = resourceSchema.getAttributesList();
        for (AttributeSchema attributeSchema : attributeSchemaList) {
            if (attributeSchema.getMultiValued() && attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                if (attributeSchema.getSubAttributeSchema("display") == null || !attributeList.containsKey(attributeSchema.getName())) continue;
                Attribute multiValuedAttribute = attributeList.get(attributeSchema.getName());
                AbstractValidator.setDisplayNameInComplexMultiValuedSubAttributes(multiValuedAttribute, attributeSchema);
                continue;
            }
            if (!attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) continue;
            List<SCIMAttributeSchema> subAttributeSchemaList = attributeSchema.getSubAttributeSchemas();
            for (AttributeSchema attributeSchema2 : subAttributeSchemaList) {
                Attribute extensionAttribute;
                if (!attributeSchema2.getMultiValued() || !attributeSchema2.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX) || attributeSchema2.getSubAttributeSchema("display") == null || (extensionAttribute = attributeList.get(attributeSchema.getName())) == null || ((ComplexAttribute)extensionAttribute).getSubAttribute(attributeSchema2.getName()) == null) continue;
                Attribute multiValuedAttribute = attributeList.get(attributeSchema.getName()).getSubAttribute(attributeSchema2.getName());
                AbstractValidator.setDisplayNameInComplexMultiValuedSubAttributes(multiValuedAttribute, attributeSchema2);
            }
        }
    }

    private static void setDisplayNameInComplexMultiValuedSubAttributes(Attribute multiValuedAttribute, AttributeSchema attributeSchema) throws CharonException, BadRequestException {
        List<Attribute> subValuesList = ((MultiValuedAttribute)multiValuedAttribute).getAttributeValues();
        for (Attribute subValue : subValuesList) {
            if (((ComplexAttribute)subValue).getSubAttributesList().isEmpty()) continue;
            for (AttributeSchema attributeSchema2 : attributeSchema.getSubAttributeSchemas()) {
                if (!attributeSchema2.getName().equals("value")) continue;
                if (!attributeSchema2.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX) && !attributeSchema2.getMultiValued()) {
                    SimpleAttribute simpleAttribute = null;
                    simpleAttribute = new SimpleAttribute("display", ((SimpleAttribute)subValue.getSubAttribute(attributeSchema2.getName())).getValue());
                    AttributeSchema subSchema = attributeSchema.getSubAttributeSchema("display");
                    simpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(subSchema, simpleAttribute);
                    ((ComplexAttribute)subValue).setSubAttribute(simpleAttribute);
                    continue;
                }
                if (attributeSchema2.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX) || !attributeSchema2.getMultiValued()) continue;
                MultiValuedAttribute valueSubAttribute = (MultiValuedAttribute)subValue.getSubAttribute(attributeSchema2.getName());
                Object displayValue = null;
                try {
                    displayValue = valueSubAttribute.getAttributePrimitiveValues().get(0);
                }
                catch (Exception e) {
                    String error = "Can not set display attribute value without a value attribute value.";
                    throw new BadRequestException("invalidSyntax", error);
                }
                SimpleAttribute simpleAttribute = new SimpleAttribute("display", displayValue);
                AttributeSchema subSchema = attributeSchema.getSubAttributeSchema("display");
                simpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(subSchema, simpleAttribute);
                ((ComplexAttribute)subValue).setSubAttribute(simpleAttribute);
            }
        }
    }
}

