/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;

public class Group
extends AbstractSCIMObject {
    private static final long serialVersionUID = 6106269076155338045L;

    public String getDisplayName() throws CharonException {
        if (this.isAttributeExist("displayName")) {
            return ((SimpleAttribute)this.attributeList.get("displayName")).getStringValue();
        }
        return null;
    }

    public void setDisplayName(String displayName) throws CharonException, BadRequestException {
        if (this.isAttributeExist("displayName")) {
            ((SimpleAttribute)this.attributeList.get("displayName")).updateValue(displayName);
        } else {
            SimpleAttribute displayAttribute = new SimpleAttribute("displayName", displayName);
            displayAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.DISPLAY_NAME, displayAttribute);
            this.attributeList.put("displayName", displayAttribute);
        }
    }

    public List<Object> getMembers() {
        ArrayList<Object> memberList = new ArrayList<Object>();
        if (this.isAttributeExist("members")) {
            MultiValuedAttribute members = (MultiValuedAttribute)this.attributeList.get("members");
            List<Attribute> subValuesList = members.getAttributeValues();
            for (Attribute subValue : subValuesList) {
                ComplexAttribute complexAttribute = (ComplexAttribute)subValue;
                Map<String, Attribute> subAttributesList = complexAttribute.getSubAttributesList();
                if (subAttributesList == null || !subAttributesList.containsKey("value")) continue;
                memberList.add(((SimpleAttribute)subAttributesList.get("value")).getValue());
            }
            return memberList;
        }
        return null;
    }

    public List<String> getMembersWithDisplayName() {
        MultiValuedAttribute members;
        List<Attribute> values;
        ArrayList<String> displayNames = new ArrayList<String>();
        if (this.isAttributeExist("members") && (values = (members = (MultiValuedAttribute)this.attributeList.get("members")).getAttributeValues()) != null) {
            List<Attribute> subValuesList = members.getAttributeValues();
            for (Attribute subValue : subValuesList) {
                ComplexAttribute complexAttribute = (ComplexAttribute)subValue;
                Map<String, Attribute> subAttributesList = complexAttribute.getSubAttributesList();
                if (subAttributesList == null || !subAttributesList.containsKey("display")) continue;
                displayNames.add((String)((SimpleAttribute)subAttributesList.get("display")).getValue());
            }
            return displayNames;
        }
        return displayNames;
    }

    public void setMember(String userId, String userName) throws BadRequestException, CharonException {
        if (this.isAttributeExist("members")) {
            MultiValuedAttribute members = (MultiValuedAttribute)this.attributeList.get("members");
            ComplexAttribute complexAttribute = this.setMemberCommon(userId, userName);
            members.setAttributeValue(complexAttribute);
        } else {
            MultiValuedAttribute members = new MultiValuedAttribute("members");
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.MEMBERS, members);
            ComplexAttribute complexAttribute = this.setMemberCommon(userId, userName);
            members.setAttributeValue(complexAttribute);
            this.setAttribute(members);
        }
    }

    private ComplexAttribute setMemberCommon(String userId, String userName) throws BadRequestException, CharonException {
        ComplexAttribute complexAttribute = new ComplexAttribute();
        complexAttribute.setName("members_" + userId + "default");
        SimpleAttribute valueSimpleAttribute = new SimpleAttribute("value", userId);
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.VALUE, valueSimpleAttribute);
        SimpleAttribute displaySimpleAttribute = new SimpleAttribute("display", userName);
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.DISPLAY, displaySimpleAttribute);
        complexAttribute.setSubAttribute(valueSimpleAttribute);
        complexAttribute.setSubAttribute(displaySimpleAttribute);
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.MEMBERS, complexAttribute);
        return complexAttribute;
    }

    public void setSchemas() {
        SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getGroupResourceSchema();
        List<String> schemasList = schema.getSchemasList();
        for (String scheme : schemasList) {
            this.setSchema(scheme);
        }
    }
}

