/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.objects;

import java.util.List;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;

public class User
extends AbstractSCIMObject {
    private static final long serialVersionUID = 6106269076155338045L;

    public String getUserName() throws CharonException {
        return this.getSimpleAttributeStringVal("userName");
    }

    public void setUserName(String userName) throws CharonException, BadRequestException {
        this.setSimpleAttribute("userName", SCIMSchemaDefinitions.SCIMUserSchemaDefinition.USERNAME, userName);
    }

    public String getPassword() throws CharonException {
        return this.getSimpleAttributeStringVal("password");
    }

    public void setPassword(String password) throws CharonException, BadRequestException {
        this.setSimpleAttribute("password", SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PASSWORD, password);
    }

    private void setSimpleAttribute(String attributeName, AttributeSchema attributeSchema, Object value) throws CharonException, BadRequestException {
        if (this.isAttributeExist(attributeName)) {
            ((SimpleAttribute)this.attributeList.get(attributeName)).updateValue(value);
        } else {
            SimpleAttribute simpleAttribute = new SimpleAttribute(attributeName, value);
            simpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(attributeSchema, simpleAttribute);
            this.attributeList.put(attributeName, simpleAttribute);
        }
    }

    private String getSimpleAttributeStringVal(String attributeName) throws CharonException {
        return this.isAttributeExist(attributeName) ? ((SimpleAttribute)this.attributeList.get(attributeName)).getStringValue() : null;
    }

    public void setGroup(String type, String value, String display) throws CharonException, BadRequestException {
        SimpleAttribute typeSimpleAttribute = null;
        SimpleAttribute valueSimpleAttribute = null;
        SimpleAttribute displaySimpleAttribute = null;
        ComplexAttribute complexAttribute = new ComplexAttribute();
        if (type != null) {
            typeSimpleAttribute = new SimpleAttribute("type", type);
            typeSimpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_TYPE, typeSimpleAttribute);
            complexAttribute.setSubAttribute(typeSimpleAttribute);
        }
        if (value != null) {
            valueSimpleAttribute = new SimpleAttribute("value", value);
            valueSimpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_VALUE, valueSimpleAttribute);
            complexAttribute.setSubAttribute(valueSimpleAttribute);
        }
        if (display != null) {
            displaySimpleAttribute = new SimpleAttribute("display", display);
            displaySimpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_DISPLAY, displaySimpleAttribute);
            complexAttribute.setSubAttribute(displaySimpleAttribute);
        }
        if (complexAttribute.getSubAttributesList().size() != 0) {
            Object typeVal = "default";
            Object valueVal = "default";
            if (typeSimpleAttribute != null && typeSimpleAttribute.getValue() != null) {
                typeVal = typeSimpleAttribute.getValue();
            }
            if (valueSimpleAttribute != null && valueSimpleAttribute.getValue() != null) {
                valueVal = valueSimpleAttribute.getValue();
            }
            String complexAttributeName = "groups_" + valueVal + "_" + typeVal;
            complexAttribute.setName(complexAttributeName);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUPS, complexAttribute);
            this.setGroup(complexAttribute);
        }
    }

    private void setGroup(ComplexAttribute groupPropertiesAttribute) throws CharonException, BadRequestException {
        if (this.attributeList.containsKey("groups")) {
            MultiValuedAttribute groupsAttribute = (MultiValuedAttribute)this.attributeList.get("groups");
            groupsAttribute.setAttributeValue(groupPropertiesAttribute);
        } else {
            MultiValuedAttribute groupsAttribute = new MultiValuedAttribute("groups");
            groupsAttribute.setAttributeValue(groupPropertiesAttribute);
            groupsAttribute = (MultiValuedAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUPS, groupsAttribute);
            this.attributeList.put("groups", groupsAttribute);
        }
    }

    public void setSchemas() {
        SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
        List<String> schemasList = schema.getSchemasList();
        for (String scheme : schemasList) {
            this.setSchema(scheme);
        }
    }
}

