/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.attributes;

import java.time.Instant;
import org.wso2.charon3.core.attributes.AbstractAttribute;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;

public class DefaultAttributeFactory {
    public static Attribute createAttribute(AttributeSchema attributeSchema, AbstractAttribute attribute) throws CharonException, BadRequestException {
        attribute.setMutability(attributeSchema.getMutability());
        attribute.setRequired(attributeSchema.getRequired());
        attribute.setReturned(attributeSchema.getReturned());
        attribute.setCaseExact(attributeSchema.getCaseExact());
        attribute.setMultiValued(attributeSchema.getMultiValued());
        attribute.setDescription(attributeSchema.getDescription());
        attribute.setUniqueness(attributeSchema.getUniqueness());
        attribute.setURI(attributeSchema.getURI());
        try {
            if (attribute instanceof SimpleAttribute) {
                return DefaultAttributeFactory.createSimpleAttribute(attributeSchema, (SimpleAttribute)attribute);
            }
            attribute.setType(attributeSchema.getType());
            return attribute;
        }
        catch (CharonException e) {
            String error = "Unknown attribute schema.";
            throw new CharonException(error);
        }
        catch (BadRequestException e) {
            String error = "Violation in attribute schema. DataType doesn't match that of the value.";
            throw new BadRequestException(error, "invalidValue");
        }
    }

    protected static SimpleAttribute createSimpleAttribute(AttributeSchema attributeSchema, SimpleAttribute simpleAttribute) throws CharonException, BadRequestException {
        if (simpleAttribute.getValue() != null) {
            if (DefaultAttributeFactory.isAttributeDataTypeValid(simpleAttribute.getValue(), attributeSchema.getType())) {
                simpleAttribute.setType(attributeSchema.getType());
                return simpleAttribute;
            }
            throw new BadRequestException("invalidValue");
        }
        return simpleAttribute;
    }

    protected static boolean isAttributeDataTypeValid(Object attributeValue, SCIMDefinitions.DataType attributeDataType) throws BadRequestException {
        switch (attributeDataType) {
            case STRING: {
                return attributeValue instanceof String;
            }
            case BOOLEAN: {
                return attributeValue instanceof Boolean;
            }
            case DECIMAL: {
                return attributeValue instanceof Double;
            }
            case INTEGER: {
                return attributeValue instanceof Integer;
            }
            case DATE_TIME: {
                return attributeValue instanceof Instant;
            }
            case BINARY: {
                return attributeValue instanceof Byte[];
            }
            case REFERENCE: {
                return attributeValue instanceof String;
            }
            case COMPLEX: {
                return attributeValue instanceof String;
            }
        }
        throw new BadRequestException("invalidValue");
    }
}

